/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.input;

import com.mathworks.install.JSONInstallationFileParser;
import com.mathworks.install.input.ComponentData;
import com.mathworks.install.input.DeltaData;
import com.mathworks.install.input.InstallationInputFile;
import com.mathworks.install.input.ProductData;
import java.io.File;

class ProductOrComponentJSONFile
implements InstallationInputFile {
    private final JSONInstallationFileParser jsonInstallationFileParser;
    private final File file;

    public ProductOrComponentJSONFile(File file, JSONInstallationFileParser jSONInstallationFileParser) {
        this.file = file;
        this.jsonInstallationFileParser = jSONInstallationFileParser;
    }

    public File getFile() {
        return this.file;
    }

    public void parse() {
        if (this.isProductJSON()) {
            this.jsonInstallationFileParser.parseProductJSON(this.file, ProductData.class);
        } else if (this.isDeltaJSON()) {
            this.jsonInstallationFileParser.parseDeltaJSON(this.file, DeltaData.class);
        } else if (this.isComponentJSON()) {
            this.jsonInstallationFileParser.parseComponentJSON(this.file, ComponentData.class);
        }
    }

    private boolean isProductJSON() {
        return this.file.getName().startsWith("product");
    }

    private boolean isDeltaJSON() {
        return this.file.getName().startsWith("delta");
    }

    private boolean isComponentJSON() {
        return this.file.getName().startsWith("component");
    }
}

