/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.input;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.mathworks.install.JSONInstallationFileParser;
import com.mathworks.install.UpdateComponentContainer;
import com.mathworks.install.UpdateProductContainer;
import com.mathworks.install.input.ComponentData;
import com.mathworks.install.input.DeltaData;
import com.mathworks.install.input.ProductData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

class JSONInstallationFileParserImpl
implements JSONInstallationFileParser {
    private final UpdateProductContainer productContainer;
    private final UpdateComponentContainer componentContainer;

    @Inject
    public JSONInstallationFileParserImpl(UpdateProductContainer updateProductContainer, UpdateComponentContainer updateComponentContainer) {
        this.productContainer = updateProductContainer;
        this.componentContainer = updateComponentContainer;
    }

    public final void parseProductJSON(InputStream inputStream, Class<ProductData> clazz) {
        ProductData productData = this.getUpdateData(this.getIOUtilsFileToString(inputStream), clazz);
        this.productContainer.setUpdateProductData(productData);
    }

    public final void parseProductJSON(File file, Class<ProductData> clazz) {
        ProductData productData = this.getUpdateData(this.fileToString(file), clazz);
        this.productContainer.setUpdateProductData(productData);
    }

    public final void parseDeltaJSON(File file, Class<DeltaData> clazz) {
        DeltaData deltaData = this.getUpdateData(this.fileToString(file), clazz);
        this.componentContainer.setUpdateDeltaData(deltaData);
    }

    public final void parseDeltaJSON(InputStream inputStream, Class<DeltaData> clazz) {
        DeltaData deltaData = this.getUpdateData(this.getIOUtilsFileToString(inputStream), clazz);
        this.componentContainer.setUpdateDeltaData(deltaData);
    }

    public void parseComponentJSON(File file, Class<ComponentData> clazz) {
        ComponentData componentData = this.getUpdateData(this.fileToString(file), clazz);
        this.productContainer.setUpdateComponentData(componentData);
    }

    public void parseComponentJSON(InputStream inputStream, Class<ComponentData> clazz) {
        ComponentData componentData = this.getUpdateData(this.getIOUtilsFileToString(inputStream), clazz);
        this.productContainer.setUpdateComponentData(componentData);
    }

    private String fileToString(File file) {
        String string = "";
        try {
            string = FileUtils.readFileToString((File)file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    private <T> T getUpdateData(String string, Class<T> clazz) {
        Gson gson = new Gson();
        return (T)gson.fromJson(string, clazz);
    }

    private String getIOUtilsFileToString(InputStream inputStream) {
        try {
            String string = IOUtils.toString((InputStream)inputStream);
            return string;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return "";
    }
}

