/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.input;

import com.mathworks.install.ComponentData;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class DownloadLocationUtility {
    private static final String COMMON_FOLDER = "common";
    private static final String ARCHIVES_FOLDER = "archives";

    private DownloadLocationUtility() {
    }

    public static File getPathForReadingArchives(File file) {
        return DownloadLocationUtility.getArchivesFolderPath(file);
    }

    public static File getLocationForComponentArchives(File file, ComponentData componentData) {
        return DownloadLocationUtility.getCorrespondingEncFolderLocation(DownloadLocationUtility.getArchivesFolderPath(file), componentData);
    }

    public static File getCorrespondingEncFolderLocation(File file, ComponentData componentData) {
        ArrayList arrayList = componentData.getPlatforms();
        String string = componentData.getLocale();
        File file2 = DownloadLocationUtility.getDocFolderPath(file, componentData, string);
        if (file2 != null) {
            return file2;
        }
        if (arrayList.size() == 1) {
            return new File(file, (String)arrayList.get(0));
        }
        return new File(file, COMMON_FOLDER);
    }

    private static File getDocFolderPath(File file, ComponentData componentData, String string) {
        File file2 = null;
        if (!string.isEmpty()) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            String string2 = stringTokenizer.nextToken();
            String string3 = componentData.getName();
            if (string3.contains("_doc_" + string2)) {
                file2 = new File(file, "doc_" + string2);
            }
        }
        return file2;
    }

    public static File getLocationForProductdata(File file, String string) {
        if (string.equals(COMMON_FOLDER)) {
            return new File(DownloadLocationUtility.getArchivesFolderPath(file), COMMON_FOLDER);
        }
        return new File(DownloadLocationUtility.getArchivesFolderPath(file), string);
    }

    private static File getArchivesFolderPath(File file) {
        return new File(file.getPath() + File.separator + ARCHIVES_FOLDER);
    }
}

