/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.input;

import com.mathworks.install.ContentOptimizer;
import com.mathworks.install.InputStreamProvider;
import com.mathworks.install.InstallerDownloadInfoContainer;
import com.mathworks.install.JSONInstallationFileParser;
import com.mathworks.install.XMLParseException;
import com.mathworks.install.archive.Archive;
import com.mathworks.install.archive.ArchiveFactory;
import com.mathworks.install.input.ComponentData;
import com.mathworks.install.input.ComponentSourceProvider;
import com.mathworks.install.input.DeltaData;
import com.mathworks.install.input.InstallationInputFile;
import com.mathworks.install.input.ProductData;
import com.mathworks.install.input.XMLInstallationFileParser;
import com.mathworks.install_impl.input.ArchiveInputStreamProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOUtils;

final class DWSInstallationInputFile
implements InstallationInputFile {
    private final File file;
    private final ArchiveFactory archiveFactory;
    private final XMLInstallationFileParser xmlInstallationFileParser;
    private final ComponentSourceProvider componentSourceProvider;
    private final ContentOptimizer contentOptimizer;
    private final InstallerDownloadInfoContainer installerDownloadInfoContainer;
    private final JSONInstallationFileParser jsonInstallationFileParser;

    public DWSInstallationInputFile(File file, ArchiveFactory archiveFactory, XMLInstallationFileParser xMLInstallationFileParser, ComponentSourceProvider componentSourceProvider, ContentOptimizer contentOptimizer, InstallerDownloadInfoContainer installerDownloadInfoContainer, JSONInstallationFileParser jSONInstallationFileParser) {
        this.file = file;
        this.archiveFactory = archiveFactory;
        this.xmlInstallationFileParser = xMLInstallationFileParser;
        this.componentSourceProvider = componentSourceProvider;
        this.contentOptimizer = contentOptimizer;
        this.installerDownloadInfoContainer = installerDownloadInfoContainer;
        this.jsonInstallationFileParser = jSONInstallationFileParser;
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException, XMLParseException, JAXBException {
        InputStream inputStream = null;
        Archive archive = null;
        try {
            archive = this.archiveFactory.createArchive(this.getFile());
            for (String string : archive.getEntries()) {
                ArchiveInputStreamProvider archiveInputStreamProvider = new ArchiveInputStreamProvider(archive, string);
                if (this.contentOptimizer.accept(string)) {
                    if (string.contains("product_data.json")) {
                        this.jsonInstallationFileParser.parseProductJSON(archiveInputStreamProvider.getInputStream(), ProductData.class);
                        continue;
                    }
                    if (string.contains("delta_data.json")) {
                        this.jsonInstallationFileParser.parseDeltaJSON(archiveInputStreamProvider.getInputStream(), DeltaData.class);
                        continue;
                    }
                    if (string.contains("component_data.json")) {
                        this.jsonInstallationFileParser.parseComponentJSON(archiveInputStreamProvider.getInputStream(), ComponentData.class);
                        continue;
                    }
                    this.xmlInstallationFileParser.readInDefinition((InputStreamProvider)archiveInputStreamProvider, this.componentSourceProvider);
                    continue;
                }
                if (!string.contains("installerdata.xml")) continue;
                inputStream = archiveInputStreamProvider.getInputStream();
                this.installerDownloadInfoContainer.readInDefinition(inputStream);
            }
        }
        finally {
            if (archive != null) {
                archive.closeQuietly();
            }
            if (inputStream != null) {
                IOUtils.closeQuietly(inputStream);
            }
        }
    }
}

