/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.input;

import com.mathworks.install.ContentOptimizer;
import com.mathworks.install.InputStreamProvider;
import com.mathworks.install.XMLParseException;
import com.mathworks.install.archive.Archive;
import com.mathworks.install.archive.ArchiveFactory;
import com.mathworks.install.input.ComponentSourceFactory;
import com.mathworks.install.input.ComponentSourceProvider;
import com.mathworks.install.input.InstallationInputFile;
import com.mathworks.install.input.XMLInstallationFileParser;
import com.mathworks.install_impl.input.ArchiveInputStreamProvider;
import com.mathworks.install_impl.input.CompressedXMLComponentSourceProvider;
import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBException;

final class CompressedXMLInstallationInputFile
implements InstallationInputFile {
    private final File allXMLsZip;
    private final ArchiveFactory archiveFactory;
    private final XMLInstallationFileParser xmlInstallationFileParser;
    private final ComponentSourceFactory componentSourceFactory;
    private final ContentOptimizer contentOptimizer;

    public CompressedXMLInstallationInputFile(File file, ArchiveFactory archiveFactory, XMLInstallationFileParser xMLInstallationFileParser, ComponentSourceFactory componentSourceFactory, ContentOptimizer contentOptimizer) {
        this.allXMLsZip = file;
        this.archiveFactory = archiveFactory;
        this.xmlInstallationFileParser = xMLInstallationFileParser;
        this.componentSourceFactory = componentSourceFactory;
        this.contentOptimizer = contentOptimizer;
    }

    public File getFile() {
        return this.allXMLsZip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException, XMLParseException, JAXBException {
        Archive archive = null;
        try {
            archive = this.archiveFactory.createArchive(this.getFile());
            String string = this.allXMLsZip.getParent() + File.separator;
            for (String string2 : archive.getEntries()) {
                if (!this.contentOptimizer.accept(string2)) continue;
                this.xmlInstallationFileParser.readInDefinition((InputStreamProvider)new ArchiveInputStreamProvider(archive, string2), (ComponentSourceProvider)new CompressedXMLComponentSourceProvider(string + string2, this.componentSourceFactory));
            }
        }
        finally {
            if (archive != null) {
                archive.closeQuietly();
            }
        }
    }
}

