/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.input;

import com.mathworks.install.JSONInstallationFileParser;
import com.mathworks.install.archive.ArchiveFactory;
import com.mathworks.install.input.ComponentSourceFactory;
import com.mathworks.install.input.InstallationInputFile;
import com.mathworks.install.input.InstallationInputFileStrategy;
import com.mathworks.install.input.XMLInstallationFileParser;
import com.mathworks.install_impl.input.ProductArchiveFile;
import com.mathworks.install_impl.input.ProductOrComponentJSONFile;
import com.mathworks.install_impl.input.ProductOrComponentXMLFile;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

abstract class AbstractInstallationInputFileStrategy
implements InstallationInputFileStrategy {
    AbstractInstallationInputFileStrategy() {
    }

    public InstallationInputFile createProductArchive(File file, ArchiveFactory archiveFactory, XMLInstallationFileParser xMLInstallationFileParser, ComponentSourceFactory componentSourceFactory) {
        return new ProductArchiveFile(file, archiveFactory, xMLInstallationFileParser, componentSourceFactory);
    }

    public InstallationInputFile createProductOrComponentXMLFile(File file, XMLInstallationFileParser xMLInstallationFileParser, ComponentSourceFactory componentSourceFactory) {
        return new ProductOrComponentXMLFile(file, xMLInstallationFileParser, componentSourceFactory);
    }

    public InstallationInputFile createProductOrComponentJSONFile(File file, JSONInstallationFileParser jSONInstallationFileParser) {
        return new ProductOrComponentJSONFile(file, jSONInstallationFileParser);
    }

    public boolean isProductArchive(File file) {
        return FilenameUtils.isExtension((String)file.getName(), (String)"zip");
    }
}

