/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.FileProcessor;
import com.mathworks.instutil.ProcessExecutor;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.filefilter.FileFilterUtils;

final class StartMdwasInstaller
implements FileProcessor {
    private ProcessExecutor processExecutor;
    private final AppLogger appLogger;

    public StartMdwasInstaller(ProcessExecutor processExecutor, AppLogger appLogger) {
        this.processExecutor = processExecutor;
        this.appLogger = appLogger;
    }

    public void processFile(File file, File file2, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.appLogger.logMsg("Installing MDWAS service: " + file.getName());
        this.runMdwasInstaller(file, "-install");
    }

    private void runMdwasInstaller(File file, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add('\"' + file.getAbsolutePath() + '\"');
        arrayList.addAll(Arrays.asList(stringArray));
        String string = Arrays.toString(arrayList.toArray());
        try {
            if (Files.exists(file.toPath(), new LinkOption[0])) {
                this.appLogger.logMsg("Running " + string);
                int n = this.processExecutor.executeWithTimeout(arrayList.toArray(new String[arrayList.size()]));
                if (n == 0) {
                    this.appLogger.logMsg("Completed running " + string);
                } else {
                    this.appLogger.logMsg("Error running " + string + " status = " + n);
                }
            } else {
                this.appLogger.logMsg("Error running: " + string + " does not exist");
            }
        }
        catch (Exception exception) {
            this.appLogger.logMsg("Exception running " + string + exception.toString());
        }
    }

    public void undoProcessFile(File file, File file2, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.appLogger.logMsg("Uninstalling MDWAS service: " + file.getName());
        this.runMdwasInstaller(file, "-uninstall", "MDWAS_LocalService");
    }

    public FilenameFilter getFilenameFilter() {
        return FileFilterUtils.falseFileFilter();
    }
}

