/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.Command;
import com.mathworks.install.command.DirectoryResolver;
import com.mathworks.install.command.FileProcessor;
import com.mathworks.install_impl.command.InstallationRootDirectoryResolver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

final class ProcessFilesCommand
implements Command {
    private final String[] fileNamesToProcess;
    private final FileProcessor fileProcessor;
    private final DirectoryResolver directoryResolver;

    public ProcessFilesCommand(FileProcessor fileProcessor, String string, String ... stringArray) {
        this(new InstallationRootDirectoryResolver(string), fileProcessor, stringArray);
    }

    ProcessFilesCommand(DirectoryResolver directoryResolver, FileProcessor fileProcessor, String ... stringArray) {
        this.directoryResolver = directoryResolver;
        this.fileProcessor = fileProcessor;
        this.fileNamesToProcess = (String[])stringArray.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        ArrayList<File> arrayList = new ArrayList<File>();
        this.buildFileList(arrayList, file, this.fileNamesToProcess);
        String string2 = ProcessFilesCommand.changeCurrentDirectoryToBinArch(string, file);
        try {
            for (File file2 : arrayList) {
                this.fileProcessor.processFile(file2, file, installFlowControlHandler);
            }
        }
        finally {
            ProcessFilesCommand.restoreCurrentDirectory(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        ArrayList<File> arrayList = new ArrayList<File>();
        this.buildFileList(arrayList, file, this.fileNamesToProcess);
        String string2 = ProcessFilesCommand.changeCurrentDirectoryToBinArch(string, file);
        try {
            for (File file2 : arrayList) {
                this.fileProcessor.undoProcessFile(file2, file, installFlowControlHandler);
            }
        }
        finally {
            ProcessFilesCommand.restoreCurrentDirectory(string2);
        }
    }

    private static void restoreCurrentDirectory(String string) {
        System.setProperty("user.dir", string);
    }

    private static String changeCurrentDirectoryToBinArch(String string, File file) {
        String string2 = System.getProperty("user.dir");
        String string3 = file + File.separator + "bin" + File.separator + string;
        System.setProperty("user.dir", string3);
        return string2;
    }

    private void buildFileList(Collection<File> collection, File file, String ... stringArray) {
        File file2 = this.directoryResolver.resolveDirectory(file);
        if (stringArray.length > 0) {
            for (String string : stringArray) {
                collection.add(new File(file2, string));
            }
        } else {
            File[] fileArray = file2.listFiles(this.fileProcessor.getFilenameFilter());
            if (fileArray != null) {
                collection.addAll(Arrays.asList(fileArray));
            }
        }
    }
}

