/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.Command;
import com.mathworks.install.resources.InstallResourceKeys;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;

final class OLERegisterCommand
implements Command {
    private final String dllName;
    private final String relPathToDllDir;
    private final String matlabVersion;
    private final AppLogger appLogger;

    OLERegisterCommand(String string, String string2, String string3, AppLogger appLogger) {
        this.dllName = string;
        this.relPathToDllDir = string2;
        this.matlabVersion = string3;
        this.appLogger = appLogger;
    }

    public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        String string2 = new File(file, this.relPathToDllDir).getAbsolutePath();
        int n = this.registerAutomationServer(this.dllName, string2, this.matlabVersion);
        if (n == 0) {
            String string3 = InstallResourceKeys.MATLAB_OLE_MESSAGE.getString(new Object[0]);
            String string4 = InstallResourceKeys.MATLAB_OLE_TITLE.getString(new Object[0]);
            installFlowControlHandler.alert(string4, string3);
        }
    }

    public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        String string2 = new File(file, this.relPathToDllDir).getAbsolutePath();
        this.unregisterAutomationServer(this.dllName, string2, this.matlabVersion);
    }

    private int registerAutomationServer(String string, String string2, String string3) {
        this.appLogger.logMsg("Registering " + string + " as an automation server.");
        int n = 0;
        try {
            n = this.nativeRegisterAutomationServer(string, string2, string3);
        }
        catch (Exception exception) {
            this.appLogger.logMsg("Exception registering automation server: " + exception.getMessage());
        }
        return n;
    }

    private int unregisterAutomationServer(String string, String string2, String string3) {
        this.appLogger.logMsg("Unregistering " + string + " as an automation server.");
        int n = 0;
        try {
            n = this.nativeUnRegisterAutomationServer(string, string2, string3);
        }
        catch (Exception exception) {
            this.appLogger.logMsg("Exception unregistering automation server: " + exception.getMessage());
        }
        return n;
    }

    private native int nativeRegisterAutomationServer(String var1, String var2, String var3);

    private native int nativeUnRegisterAutomationServer(String var1, String var2, String var3);
}

