/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallOptionType;
import com.mathworks.install.command.Command;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.Machine;
import com.mathworks.instutil.licensefiles.LicenseFileParser;
import com.mathworks.instutil.licensefiles.LicenseFileParserImpl;
import com.mathworks.instutil.licensefiles.LicenseFileWriter;
import com.mathworks.instutil.licensefiles.LicenseLocationFactory;
import com.mathworks.instutil.licensefiles.LicenseLocationFactoryImpl;
import com.mathworks.instutil.licensefiles.LicenseUtilityFactory;
import java.io.File;
import java.io.IOException;

public final class InstallLicenseFileCommand
implements Command {
    private final LicenseLocationFactory licenseLocationFactory = new LicenseLocationFactoryImpl();
    private final FilePermissions filePermissions;
    private final Machine machine;
    private final IO io;
    private final InstallOption installOption;
    private final UsageDataCollector usageDataCollector;

    public InstallLicenseFileCommand(InstallOption installOption, FilePermissions filePermissions, Machine machine, IO iO, UsageDataCollector usageDataCollector) {
        this.installOption = installOption;
        this.filePermissions = filePermissions;
        this.machine = machine;
        this.io = iO;
        this.usageDataCollector = usageDataCollector;
    }

    public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.installLicense(file, installFlowControlHandler);
    }

    public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
    }

    private void installLicense(File file, InstallFlowControlHandler installFlowControlHandler) {
        String string = this.installOption.getContext();
        if (string != null) {
            LicenseFileParserImpl licenseFileParserImpl = new LicenseFileParserImpl();
            boolean bl = LicenseUtilityFactory.createDefaultLicenseUtilityForTSUR((LicenseFileWriter)new MyLicenseFileWriter(file, installFlowControlHandler), (String)string).installLicense((LicenseFileParser)licenseFileParserImpl);
            boolean bl2 = false;
            try {
                if (!licenseFileParserImpl.containsServerLine(string)) {
                    if (bl) {
                        bl2 = true;
                    }
                } else {
                    String string2 = licenseFileParserImpl.getServerPortNumber(string);
                    if (string2.equals("")) {
                        string2 = "UNDEFINED";
                    }
                    this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_NETWORK_LICENSE_SERVER_PORT_NUMBER, (Object)string2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_NETWORK_LICENSE_SERVER_LINE_ADDED, (Object)bl2);
        }
    }

    private class MyLicenseFileWriter
    implements LicenseFileWriter {
        private final File destinationFolder;
        private final InstallFlowControlHandler installFlowControlHandler;

        MyLicenseFileWriter(File file, InstallFlowControlHandler installFlowControlHandler) {
            this.destinationFolder = file;
            this.installFlowControlHandler = installFlowControlHandler;
        }

        public String getRootDir() {
            return this.destinationFolder.getAbsolutePath();
        }

        public void exception(Throwable throwable, boolean bl) {
            this.installFlowControlHandler.exception(throwable);
        }

        public Machine getMachineInfo() {
            return InstallLicenseFileCommand.this.machine;
        }

        public String getUName() {
            return InstallLicenseFileCommand.this.machine.getUName();
        }

        public String getHostName() {
            return InstallLicenseFileCommand.this.machine.getHostName();
        }

        public void setMachineInfo(Machine machine) {
        }

        public FilePermissions getFilePermissionsUtility() {
            return InstallLicenseFileCommand.this.filePermissions;
        }

        public boolean isNetworkBased(String string) {
            return true;
        }

        public boolean isNetworkClient(LicenseFileParser licenseFileParser, String string) {
            return InstallOptionType.CLIENT_LICENSE_FILE.equals((Object)InstallLicenseFileCommand.this.installOption.getType()) || this.isServerAndClient();
        }

        public boolean isNetworkServer() {
            return InstallOptionType.SERVER_LICENSE_FILE.equals((Object)InstallLicenseFileCommand.this.installOption.getType()) || this.isServerAndClient();
        }

        private boolean isServerAndClient() {
            return InstallOptionType.SERVER_AND_CLIENT_LICENSE_FILE.equals((Object)InstallLicenseFileCommand.this.installOption.getType());
        }

        public void sendMessage(String string, String string2) {
            this.installFlowControlHandler.alert(string, string2);
        }

        public LicenseLocationFactory getLicenseLocationFactory() {
            return InstallLicenseFileCommand.this.licenseLocationFactory;
        }

        public String getEthernetAddress() {
            return InstallLicenseFileCommand.this.machine.getEthernetAddress();
        }

        public String getIpAddress() {
            return InstallLicenseFileCommand.this.machine.getIpAddress();
        }

        public IO getIO() {
            return InstallLicenseFileCommand.this.io;
        }
    }
}

