/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.Command;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;

class GenerateClasspathCommand
implements Command {
    private final IO io;

    public GenerateClasspathCommand(IO iO) {
        this.io = iO;
    }

    public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.createClassPathTxt(file, installFlowControlHandler);
    }

    public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.createClassPathTxt(file, installFlowControlHandler);
    }

    private List<String> getPreOrderedJarList(File file) {
        ArrayList<String> arrayList = new ArrayList();
        File file2 = new File(new File(file, "toolbox"), "local");
        File file3 = new File(file2, "reordered_list");
        try {
            arrayList = FileUtils.readLines((File)file3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList;
    }

    private void createClassPathTxt(File file, InstallFlowControlHandler installFlowControlHandler) throws InterruptedException {
        File file2 = new File(new File(file, "toolbox"), "local");
        List list = (List)this.io.recursiveListFiles(new File(file2, "classpath"), FileFilterUtils.suffixFileFilter((String)".jcp"), DirectoryFileFilter.INSTANCE);
        File file3 = new File(file2, "classpath.txt");
        this.io.deleteFile(file3);
        if (list.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder("# DO NOT MODIFY THIS FILE.  IT IS AN AUTOGENERATED FILE.");
            String string = System.getProperty("line.separator");
            stringBuilder.append(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                for (File object : list) {
                    Collection collection = this.io.readLinesFromFile(object, new ArrayList());
                    for (String string2 : collection) {
                        if (string2.startsWith("#")) continue;
                        arrayList.add(string2);
                    }
                }
                stringBuilder.append("$matlabroot/java/patch").append(string);
                for (String string3 : this.getPreOrderedJarList(file)) {
                    if (!arrayList.contains(string3)) continue;
                    stringBuilder.append(string3.trim());
                    stringBuilder.append(string);
                    arrayList.remove(string3);
                }
                for (String string4 : arrayList) {
                    stringBuilder.append(string4.trim());
                    stringBuilder.append(string);
                }
                this.io.writeStringToFile(stringBuilder.toString(), file3, System.currentTimeMillis(), 420, new IOObserver[0]);
            }
            catch (IOException iOException) {
                this.io.deleteFile(file3);
                installFlowControlHandler.exitImmediately((Throwable)iOException);
            }
        }
    }
}

