/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.Command;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.ProcessExecutor;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;

final class FileAssociationsCommand
implements Command {
    final AppLogger appLogger;
    final Platform platform;
    final ProcessExecutor processExecutor;
    int[] prodCodes;

    FileAssociationsCommand(int[] nArray, AppLogger appLogger, Platform platform, ProcessExecutor processExecutor) {
        this.prodCodes = Arrays.copyOfRange(nArray, 0, nArray.length);
        this.appLogger = appLogger;
        this.platform = platform;
        this.processExecutor = processExecutor;
    }

    public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.doFileAssociation(file.getAbsolutePath(), this.prodCodes);
    }

    public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.undoFileAssociation(file.getAbsolutePath(), this.prodCodes);
    }

    private void doFileAssociation(String string, int[] nArray) {
        long l = FileAssociationsCommand.getProductMask(nArray);
        if (l == ProductMask.NoProduct.value) {
            return;
        }
        File file = new File(string, this.getExecutableRelativePath("fileassoc"));
        if (!file.exists()) {
            this.appLogger.logMsg("Failed to udpate file associations: the executable does not exist");
            return;
        }
        if (!file.canExecute()) {
            this.appLogger.logMsg("Failed to udpate file associations: the executable cannot be run");
            return;
        }
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(file.toString());
            arrayList.add("--mlroot");
            arrayList.add(string);
            arrayList.add("--products");
            arrayList.add(String.valueOf(l));
            arrayList.add("--install");
            this.appLogger.logMsg("Updating file associations at " + string);
            int n = this.processExecutor.executeWithTimeout(arrayList.toArray(new String[0]), 5000L);
            if (n == 0) {
                this.appLogger.logMsg("Successfully updated file associations at " + string);
            } else {
                this.appLogger.logMsg("Failed to update file associations at " + string + " with error code " + n);
            }
        }
        catch (Exception exception) {
            this.appLogger.logMsg("Exception caught with message: " + exception.getMessage());
        }
    }

    private void undoFileAssociation(String string, int[] nArray) {
        long l = FileAssociationsCommand.getProductMask(nArray);
        if (l == ProductMask.NoProduct.value) {
            return;
        }
        File file = new File(string, this.getExecutableRelativePath("fileassoc"));
        if (!file.exists()) {
            this.appLogger.logMsg("Failed to remove file associations: the executable does not exist");
            return;
        }
        if (!file.canExecute()) {
            this.appLogger.logMsg("Failed to remove file associations: the executable cannot be run");
            return;
        }
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(file.toString());
            arrayList.add("--mlroot");
            arrayList.add(string);
            arrayList.add("--products");
            arrayList.add(String.valueOf(l));
            arrayList.add("--uninstall");
            this.appLogger.logMsg("Deleting file associations at " + string);
            int n = this.processExecutor.executeWithTimeout(arrayList.toArray(new String[0]), 5000L);
            if (n == 0) {
                this.appLogger.logMsg("Successfully deleted file associations at " + string);
            } else {
                this.appLogger.logMsg("Failed to remove file associations at " + string + " with error code " + n);
            }
        }
        catch (Exception exception) {
            this.appLogger.logMsg("Exception caught with message: " + exception.getMessage());
        }
    }

    private String getExecutableRelativePath(String string) {
        String string2 = File.separator + "bin" + File.separator + this.platform.getArchString() + File.separator + string;
        if (this.platform.isWindows()) {
            string2 = string2.concat(".exe");
        }
        return string2;
    }

    private static long getProductMask(int[] nArray) {
        long l = ProductMask.NoProduct.value;
        EnumMap<ProductCode, ProductMask> enumMap = new EnumMap<ProductCode, ProductMask>(ProductCode.class);
        enumMap.put(ProductCode.Matlab, ProductMask.MATLAB);
        enumMap.put(ProductCode.Polyspace_Bug_Finder, ProductMask.POLYSPACE);
        for (int n : nArray) {
            if (n == ProductCode.Matlab_Distributed_Computing_Engine.value) {
                l = ProductMask.NoProduct.value;
                break;
            }
            for (Map.Entry entry : enumMap.entrySet()) {
                if (n != entry.getKey().value) continue;
                l |= ((ProductMask)((Object)entry.getValue())).value;
            }
        }
        return l;
    }

    private static enum ProductMask {
        NoProduct(0L),
        MATLAB(4L),
        POLYSPACE(8L),
        AllProducts(-4L);

        private final long value;

        private ProductMask(long l) {
            this.value = l;
        }
    }

    private static enum ProductCode {
        Matlab(1),
        Polyspace_Bug_Finder(164),
        Polyspace_Code_Prover(165),
        Matlab_Distributed_Computing_Engine(94);

        private final int value;

        private ProductCode(int n2) {
            this.value = n2;
        }
    }
}

