/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.command;

import com.google.inject.Inject;
import com.mathworks.install.command.DotNetFramework;
import com.mathworks.install.command.NativeDotNet;
import com.mathworks.instutil.MWNativeLibraryLoader;
import com.mathworks.instutil.ProcessExecutor;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;

public final class DotNetFrameworkImpl
implements DotNetFramework {
    private final ProcessExecutor processExecutor;
    private final AppLogger appLogger;
    private final MWNativeLibraryLoader nativeLibraryLoader;
    private final NativeDotNet nativeDotNet;
    private final ExecutorService executorService;

    @Inject
    DotNetFrameworkImpl(ProcessExecutor processExecutor, AppLogger appLogger, MWNativeLibraryLoader mWNativeLibraryLoader, ExecutorService executorService) {
        this(processExecutor, appLogger, mWNativeLibraryLoader, new MyNativeDotNet(), executorService);
    }

    public DotNetFrameworkImpl(ProcessExecutor processExecutor, AppLogger appLogger, MWNativeLibraryLoader mWNativeLibraryLoader, NativeDotNet nativeDotNet, ExecutorService executorService) {
        this.processExecutor = processExecutor;
        this.appLogger = appLogger;
        this.nativeLibraryLoader = mWNativeLibraryLoader;
        this.nativeDotNet = nativeDotNet;
        this.executorService = executorService;
    }

    public boolean isAssemblyFrameworkAvailable() {
        boolean bl = false;
        try {
            if (this.nativeDotNet.isDotNetFrameWorkVersionFourInstalled() || this.nativeDotNet.isDotNetFrameworkVersionTwoInstalled()) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        return bl;
    }

    public boolean installAssembly(File file, File file2) {
        try {
            if (!this.isAssemblyFrameworkAvailable()) {
                return true;
            }
            ArrayList arrayList = new ArrayList();
            String string = new File(file2, "GACInstaller.exe").getAbsolutePath();
            Object[] objectArray = new String[]{string, file.getAbsolutePath()};
            this.appLogger.logMsg("Running " + Arrays.toString(objectArray));
            long l = 20000L;
            int n = this.processExecutor.runtimeExecWithTimeout(arrayList, (String[])objectArray, l, this.executorService);
            this.appLogger.logMsg("Status: " + n);
            return true;
        }
        catch (Throwable throwable) {
            this.appLogger.logMsg("Status: " + throwable.toString());
            return true;
        }
    }

    private static native boolean isDotNetFrameworkVersionTwoInstalled();

    private static native boolean isDotNetFrameworkVersionFourInstalled();

    private static class MyNativeDotNet
    implements NativeDotNet {
        private MyNativeDotNet() {
        }

        public boolean isDotNetFrameworkVersionTwoInstalled() {
            return DotNetFrameworkImpl.isDotNetFrameworkVersionTwoInstalled();
        }

        public boolean isDotNetFrameWorkVersionFourInstalled() {
            boolean bl = DotNetFrameworkImpl.isDotNetFrameworkVersionFourInstalled();
            return bl;
        }
    }
}

