/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.command;

import com.google.inject.Inject;
import com.mathworks.install.ApplicationSpecificCommand;
import com.mathworks.install.BooleanHolder;
import com.mathworks.install.CommandErrorHandler;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallConfigurationPersistence;
import com.mathworks.install.InstallOption;
import com.mathworks.install.RegisterAppPath;
import com.mathworks.install.command.Command;
import com.mathworks.install.command.DesktopShortcuts;
import com.mathworks.install.command.DirectoryResolver;
import com.mathworks.install.command.DotNetFramework;
import com.mathworks.install.command.StartMenuShortcuts;
import com.mathworks.install.command.SystemDirectoryProvider;
import com.mathworks.install.service.Service;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install_impl.command.AbstractCommandFactory;
import com.mathworks.install_impl.command.AssemblyFileInstaller;
import com.mathworks.install_impl.command.AssemblyFrameworkCommand;
import com.mathworks.install_impl.command.DeletePreferencesCommand;
import com.mathworks.install_impl.command.DesktopShortcutCreator;
import com.mathworks.install_impl.command.DllRegisterer;
import com.mathworks.install_impl.command.FileAssociationsCommand;
import com.mathworks.install_impl.command.FileCopier;
import com.mathworks.install_impl.command.InsertPathIntoSystemPathCommand;
import com.mathworks.install_impl.command.InstallLicenseFileCommand;
import com.mathworks.install_impl.command.InstallServiceProcessor;
import com.mathworks.install_impl.command.InstallServiceProcessorWindows;
import com.mathworks.install_impl.command.InstallationRootDirectoryResolver;
import com.mathworks.install_impl.command.NoOpCommand;
import com.mathworks.install_impl.command.OLERegisterCommand;
import com.mathworks.install_impl.command.ProcessFilesCommand;
import com.mathworks.install_impl.command.ProcessServicesCommand;
import com.mathworks.install_impl.command.RegisterApplicationCommand;
import com.mathworks.install_impl.command.RegisterAssemblyFolderCommand;
import com.mathworks.install_impl.command.RegisterNextGenUninstallerCommand;
import com.mathworks.install_impl.command.RegisterUninstallerCommand;
import com.mathworks.install_impl.command.RegisterUninstallerForUserAppCommand;
import com.mathworks.install_impl.command.RemoveServiceProcessor;
import com.mathworks.install_impl.command.StartMdwasInstaller;
import com.mathworks.install_impl.command.StartMenuShortcutCreator;
import com.mathworks.install_impl.command.StopServiceProcessor;
import com.mathworks.install_impl.command.WriteInstallConfiguration;
import com.mathworks.install_impl.command.WriteInstallConfigurationToLocation;
import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.Machine;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.ProcessExecutor;
import com.mathworks.instutil.Registry;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;

final class CommandFactoryWindows
extends AbstractCommandFactory {
    private final ProcessExecutor processExecutor;
    private final ExecutorService executorService;
    private final IO io;
    private final Registry registry;
    private final DotNetFramework dotNetFramework;
    private final AppLogger appLogger;
    private final FilePermissions filePermissions;
    private final Machine machine;
    private Platform platform;
    private UsageDataCollector usageDataCollector;

    @Inject
    public CommandFactoryWindows(ProcessExecutor processExecutor, ExecutorService executorService, IO iO, Registry registry, DotNetFramework dotNetFramework, AppLogger appLogger, FilePermissions filePermissions, Machine machine, Platform platform, ApplicationSpecificCommand applicationSpecificCommand, UsageDataCollector usageDataCollector) {
        super(iO, appLogger, applicationSpecificCommand);
        this.processExecutor = processExecutor;
        this.executorService = executorService;
        this.io = iO;
        this.registry = registry;
        this.dotNetFramework = dotNetFramework;
        this.appLogger = appLogger;
        this.filePermissions = filePermissions;
        this.machine = machine;
        this.platform = platform;
        this.usageDataCollector = usageDataCollector;
    }

    public Command createRegisterDllsCommand(String string, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        DllRegisterer dllRegisterer = new DllRegisterer(this.processExecutor, this.executorService, new MySystemDirectoryProvider(), this.appLogger, arrayList);
        return new ProcessFilesCommand(dllRegisterer, string, stringArray);
    }

    public Command createRegisterDllsWithPathsCommand(String string, List<String> list, String ... stringArray) {
        DllRegisterer dllRegisterer = new DllRegisterer(this.processExecutor, this.executorService, new MySystemDirectoryProvider(), this.appLogger, list);
        return new ProcessFilesCommand(dllRegisterer, string, stringArray);
    }

    private native String nativeGetSystemDirectory();

    public Command createRegisterSystemDllsCommand(String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        DllRegisterer dllRegisterer = new DllRegisterer(this.processExecutor, this.executorService, new MySystemDirectoryProvider(), this.appLogger, arrayList);
        return new ProcessFilesCommand(new SystemDirectoryResolver(), dllRegisterer, stringArray);
    }

    public Command createRemoveServicesCommand(Service ... serviceArray) {
        return new ProcessServicesCommand(new RemoveServiceProcessor(), serviceArray);
    }

    public Command createStopServicesCommand(Service ... serviceArray) {
        return new ProcessServicesCommand(new StopServiceProcessor(), serviceArray);
    }

    public Command createInstallServicesCommand(Service ... serviceArray) {
        return new ProcessServicesCommand(new InstallServiceProcessor(), serviceArray);
    }

    public Command createInstallAssemblyFilesCommand(String string, String ... stringArray) {
        AssemblyFileInstaller assemblyFileInstaller = new AssemblyFileInstaller(this.dotNetFramework, string, this.appLogger);
        return new ProcessFilesCommand(assemblyFileInstaller, string, stringArray);
    }

    public Command createRegisterAssemblyFolderCommand(String string, String string2) {
        return new RegisterAssemblyFolderCommand(this.registry, string, string2, this.appLogger);
    }

    public Command createAssemblyFrameworkCommand(String string, CommandErrorHandler commandErrorHandler, Command ... commandArray) {
        return new AssemblyFrameworkCommand(this.dotNetFramework, string, commandErrorHandler, commandArray);
    }

    public Command createRegisterUninstallerCommand(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return new RegisterUninstallerCommand(this.registry, string, string2, string3, string4, string5, string6, string7, this.appLogger);
    }

    public Command createRegisterNextGenUninstallerCommand(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return new RegisterNextGenUninstallerCommand(this.registry, string, string2, string3, string4, string5, string6, string7, this.appLogger);
    }

    public Command createRegisterApplicationCommand(RegisterAppPath registerAppPath) {
        return new RegisterApplicationCommand(this.registry, this.appLogger, registerAppPath);
    }

    public Command createOLEAutomationCommand(String string, String string2, String string3) {
        return new OLERegisterCommand(string, string2, string3, this.appLogger);
    }

    public Command createInsertPathIntoSystemPathCommand(String string, String string2, BooleanHolder booleanHolder) {
        return new InsertPathIntoSystemPathCommand(string, string2, this.registry, this.appLogger, this.platform, booleanHolder);
    }

    public Command createCopyFilesToSystemDirectoryCommand(String string, String ... stringArray) {
        FileCopier fileCopier = new FileCopier(this.io, new SystemDirectoryResolver(), this.appLogger);
        return new ProcessFilesCommand(fileCopier, string, stringArray);
    }

    public Command createCopyFilesToInstallationCommand(String string, String string2, FilenameFilter filenameFilter) {
        FileCopier fileCopier = new FileCopier(this.io, new InstallationRootDirectoryResolver(string2), filenameFilter, this.appLogger);
        return new ProcessFilesCommand(fileCopier, string, new String[0]);
    }

    public Command createFileAssociationsCommand(int[] nArray) {
        return new FileAssociationsCommand(nArray, this.appLogger, this.platform, this.processExecutor);
    }

    public Command createWriteLicenseFileCommand(InstallOption installOption) {
        return new InstallLicenseFileCommand(installOption, this.filePermissions, this.machine, this.io, this.usageDataCollector);
    }

    public Command createInstallLicenseManagerServiceCommand(InstallOption installOption, Service service) {
        return new ProcessServicesCommand(new InstallServiceProcessorWindows(installOption), service);
    }

    public Command createSymbolicLinkCommand(InstallOption installOption, String string) {
        return new NoOpCommand();
    }

    public Command createDeletePreferencesCommand(InstallOption installOption) {
        return new DeletePreferencesCommand(this.io, this.appLogger);
    }

    public Command createWriteInstallConfigurationCommand(InstallConfigurationPersistence installConfigurationPersistence, InstallConfiguration installConfiguration) {
        return new WriteInstallConfiguration(installConfigurationPersistence, installConfiguration);
    }

    public final Command createWriteInstallConfigurationCommandToLocation(InstallConfigurationPersistence installConfigurationPersistence, InstallConfiguration installConfiguration, File file) {
        return new WriteInstallConfigurationToLocation(installConfigurationPersistence, installConfiguration, file);
    }

    public Command createRegisterUninstallerForUserAppCommand(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return new RegisterUninstallerForUserAppCommand(this.registry, string, string2, string3, string4, string5, string6, string7, this.appLogger);
    }

    public Command createDesktopShortcutCommand(String string, String string2, String string3, String string4, String string5, boolean bl) {
        return this.createDesktopShortcutCommand(string, string2, string3, string4, string5, bl, true);
    }

    public Command createDesktopShortcutCommand(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2) {
        DesktopShortcutCreator desktopShortcutCreator = new DesktopShortcutCreator(CommandFactoryWindows.getShortcutFileName(string3), string4, this.appLogger, new MyDesktopShortcuts(), string5, bl, bl2);
        return new ProcessFilesCommand(desktopShortcutCreator, string, string2);
    }

    public Command createStartMenuShortcutCommand(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2) {
        return this.createStartMenuShortcutCommand(string, string2, string3, string4, string5, string6, bl, bl2, true);
    }

    public Command createStartMenuShortcutCommand(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2, boolean bl3) {
        StartMenuShortcutCreator startMenuShortcutCreator = new StartMenuShortcutCreator(CommandFactoryWindows.getShortcutFileName(string3), string4, string5, this.appLogger, this.io, new MyStartMenuShortcuts(), string6, bl, bl2, bl3);
        return new ProcessFilesCommand(startMenuShortcutCreator, string, string2);
    }

    public Command createRunMdwasInstallerCommand(String string, String ... stringArray) {
        StartMdwasInstaller startMdwasInstaller = new StartMdwasInstaller(this.processExecutor, this.appLogger);
        return new ProcessFilesCommand(startMdwasInstaller, string, stringArray);
    }

    private static String getShortcutFileName(String string) {
        return string + ".lnk";
    }

    private native void createStartMenuShortcut(String var1, String var2, String var3, String var4, boolean var5, String var6, boolean var7, boolean var8);

    private static native void getSpecialFolderPath(String var0, StringBuffer var1);

    private native void createDesktopShortcut(String var1, String var2, String var3, boolean var4, String var5, boolean var6);

    private static native String getShortcutTarget(String var0);

    private class MyDesktopShortcuts
    implements DesktopShortcuts {
        private MyDesktopShortcuts() {
        }

        public void createShortcutOnDesktop(File file, String string, String string2, String string3, boolean bl, boolean bl2) {
            CommandFactoryWindows.this.createDesktopShortcut(file.getAbsolutePath(), string, string2, bl2, string3, bl);
        }

        public File getDesktopFolder() {
            StringBuffer stringBuffer = new StringBuffer();
            CommandFactoryWindows.getSpecialFolderPath("desktop", stringBuffer);
            return new File(stringBuffer.toString());
        }

        public String getShortcutTargetPath(File file) {
            return CommandFactoryWindows.getShortcutTarget(file.getAbsolutePath());
        }
    }

    private class MyStartMenuShortcuts
    implements StartMenuShortcuts {
        private MyStartMenuShortcuts() {
        }

        public void createShortcutInStartMenuFolder(File file, String string, String string2, String string3, String string4, boolean bl, boolean bl2, boolean bl3) {
            CommandFactoryWindows.this.createStartMenuShortcut(file.getAbsolutePath(), string, string2, string3, bl3, string4, bl, bl2);
        }

        public File getStartMenuFolder() {
            StringBuffer stringBuffer = new StringBuffer();
            CommandFactoryWindows.getSpecialFolderPath("startmenu", stringBuffer);
            return new File(stringBuffer.toString());
        }

        public String getShortcutTargetPath(File file) {
            return CommandFactoryWindows.getShortcutTarget(file.getAbsolutePath());
        }
    }

    private class SystemDirectoryResolver
    implements DirectoryResolver {
        private SystemDirectoryResolver() {
        }

        public File resolveDirectory(File file) {
            return new File(CommandFactoryWindows.this.nativeGetSystemDirectory());
        }
    }

    private class MySystemDirectoryProvider
    implements SystemDirectoryProvider {
        private MySystemDirectoryProvider() {
        }

        public File getSystemDirectory() {
            return new File(CommandFactoryWindows.this.nativeGetSystemDirectory());
        }
    }
}

