/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.command;

import com.mathworks.install.CommandErrorHandler;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.Command;
import com.mathworks.install.command.DotNetFramework;
import java.io.File;
import java.io.IOException;

final class AssemblyFrameworkCommand
implements Command {
    private final DotNetFramework dotNetFramework;
    private final String errMsg;
    private CommandErrorHandler commandErrorHandler;
    private final Command[] commands;

    public AssemblyFrameworkCommand(DotNetFramework dotNetFramework, String string, CommandErrorHandler commandErrorHandler, Command ... commandArray) {
        this.dotNetFramework = dotNetFramework;
        this.errMsg = string;
        this.commandErrorHandler = commandErrorHandler;
        this.commands = (Command[])commandArray.clone();
    }

    public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        if (this.dotNetFramework.isAssemblyFrameworkAvailable()) {
            for (Command command : this.commands) {
                command.execute(string, file, installFlowControlHandler);
            }
        } else {
            this.commandErrorHandler.handleError(this.errMsg, installFlowControlHandler);
        }
    }

    public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        for (Command command : this.commands) {
            command.undo(string, file, installFlowControlHandler);
        }
    }
}

