/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.command;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.DotNetFramework;
import com.mathworks.install.command.FileProcessor;
import com.mathworks.install.resources.InstallResourceKeys;
import com.mathworks.install_impl.command.InstallationRootDirectoryResolver;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.commons.io.filefilter.FileFilterUtils;

final class AssemblyFileInstaller
implements FileProcessor {
    private final DotNetFramework dotNetFramework;
    private final String gacInstallerDir;
    private final AppLogger appLogger;

    public AssemblyFileInstaller(DotNetFramework dotNetFramework, String string, AppLogger appLogger) {
        this.dotNetFramework = dotNetFramework;
        this.gacInstallerDir = string;
        this.appLogger = appLogger;
    }

    public void processFile(File file, File file2, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.appLogger.logMsg("Installing assembly " + file.getName());
        File file3 = new InstallationRootDirectoryResolver(this.gacInstallerDir).resolveDirectory(file2);
        if (!this.dotNetFramework.installAssembly(file, file3)) {
            installFlowControlHandler.alert(InstallResourceKeys.GAC_INSTALL_ERROR_MESSAGE.getString(new Object[]{file.getAbsolutePath()}));
        }
    }

    public void undoProcessFile(File file, File file2, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
    }

    public FilenameFilter getFilenameFilter() {
        return FileFilterUtils.falseFileFilter();
    }
}

