/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.command;

import com.google.inject.Inject;
import com.mathworks.install.ApplicationSpecificCommand;
import com.mathworks.install.BooleanHolder;
import com.mathworks.install.CommandErrorHandler;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallConfigurationPersistence;
import com.mathworks.install.InstallOption;
import com.mathworks.install.RegisterAppPath;
import com.mathworks.install.command.Command;
import com.mathworks.install.service.Service;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install_impl.command.AbstractCommandFactory;
import com.mathworks.install_impl.command.InstallLicenseFileCommand;
import com.mathworks.install_impl.command.NoOpCommand;
import com.mathworks.install_impl.command.WriteInstallConfiguration;
import com.mathworks.install_impl.command.WriteInstallConfigurationToLocation;
import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.Machine;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;

abstract class AbstractNonWindowsCommandFactory
extends AbstractCommandFactory {
    private final Machine machine;
    private final FilePermissions filePermissionsUtil;
    private final IO io;
    private UsageDataCollector usageDataCollector;

    @Inject
    AbstractNonWindowsCommandFactory(FilePermissions filePermissions, Machine machine, IO iO, AppLogger appLogger, ApplicationSpecificCommand applicationSpecificCommand, UsageDataCollector usageDataCollector) {
        super(iO, appLogger, applicationSpecificCommand);
        this.filePermissionsUtil = filePermissions;
        this.machine = machine;
        this.io = iO;
        this.usageDataCollector = usageDataCollector;
    }

    public final Command createRegisterDllsCommand(String string, String ... stringArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    public Command createRegisterDllsWithPathsCommand(String string, List<String> list, String ... stringArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    public final Command createRegisterSystemDllsCommand(String ... stringArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    public final Command createRemoveServicesCommand(Service ... serviceArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    public final Command createStopServicesCommand(Service ... serviceArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    public final Command createInstallServicesCommand(Service ... serviceArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    public final Command createOLEAutomationCommand(String string, String string2, String string3) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    public final Command createInstallAssemblyFilesCommand(String string, String ... stringArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    public final Command createRegisterAssemblyFolderCommand(String string, String string2) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    public final Command createAssemblyFrameworkCommand(String string, CommandErrorHandler commandErrorHandler, Command ... commandArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    public final Command createRegisterUninstallerCommand(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    public final Command createRegisterNextGenUninstallerCommand(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    public final Command createRegisterApplicationCommand(RegisterAppPath registerAppPath) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    public final Command createInsertPathIntoSystemPathCommand(String string, String string2, BooleanHolder booleanHolder) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    public final Command createCopyFilesToSystemDirectoryCommand(String string, String ... stringArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    public final Command createCopyFilesToInstallationCommand(String string, String string2, FilenameFilter filenameFilter) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    public final Command createWriteLicenseFileCommand(InstallOption installOption) {
        return new InstallLicenseFileCommand(installOption, this.filePermissionsUtil, this.machine, this.io, this.usageDataCollector);
    }

    public final Command createDeletePreferencesCommand(InstallOption installOption) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    public final Command createWriteInstallConfigurationCommand(InstallConfigurationPersistence installConfigurationPersistence, InstallConfiguration installConfiguration) {
        return new WriteInstallConfiguration(installConfigurationPersistence, installConfiguration);
    }

    public final Command createWriteInstallConfigurationCommandToLocation(InstallConfigurationPersistence installConfigurationPersistence, InstallConfiguration installConfiguration, File file) {
        return new WriteInstallConfigurationToLocation(installConfigurationPersistence, installConfiguration, file);
    }

    public final Command createDesktopShortcutCommand(String string, String string2, String string3, String string4, String string5, boolean bl) {
        return this.createDesktopShortcutCommand(string, string2, string3, string4, string5, bl, true);
    }

    public final Command createDesktopShortcutCommand(String string, String string2, String string3, String string4, String string5, boolean bl, boolean bl2) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    public final Command createStartMenuShortcutCommand(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2) {
        return this.createStartMenuShortcutCommand(string, string2, string3, string4, string5, string6, bl, bl2, true);
    }

    public final Command createStartMenuShortcutCommand(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2, boolean bl3) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    public Command createFileAssociationsCommand(int[] nArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    public Command createRegisterUninstallerForUserAppCommand(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    private static Command createNoOpCommand() {
        return new NoOpCommand();
    }

    public Command createInstallLicenseManagerServiceCommand(InstallOption installOption, Service service) {
        return new NoOpCommand();
    }

    public Command createRunMdwasInstallerCommand(String string, String ... stringArray) {
        return new NoOpCommand();
    }
}

