/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.command;

import com.mathworks.install.ApplicationSpecificCommand;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallOption;
import com.mathworks.install.command.Command;
import com.mathworks.install.command.CommandFactory;
import com.mathworks.install.command.doc.BuildSharedDocCommand;
import com.mathworks.install_impl.command.DeleteMarkerFileCommand;
import com.mathworks.install_impl.command.GenerateClasspathCommand;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.LicenseNumberProvider;
import com.mathworks.instutil.licensefiles.JITFileCreationUtility;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

abstract class AbstractCommandFactory
implements CommandFactory {
    protected final IO io;
    protected final AppLogger appLogger;
    private final ApplicationSpecificCommand applicationSpecificCommand;

    AbstractCommandFactory(IO iO, AppLogger appLogger, ApplicationSpecificCommand applicationSpecificCommand) {
        this.io = iO;
        this.appLogger = appLogger;
        this.applicationSpecificCommand = applicationSpecificCommand;
    }

    public final Command createGenerateClasspathCommand() {
        return new GenerateClasspathCommand(this.io);
    }

    public Command createSharedDocCommand() {
        return new BuildSharedDocCommand(this.io);
    }

    public final Command createDeleteMarkerFileCommand() {
        return new DeleteMarkerFileCommand(this.io, this.appLogger);
    }

    public final Command createCopyFileToDirectoryCommand(final File file, final String string, final String string2) {
        return new Command(){

            public void execute(String string3, File file2, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
                FileUtils.copyFile((File)file, (File)new File(string, string2));
            }

            public void undo(String string3, File file2, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
            }
        };
    }

    public Command[] getAdditionalApplicationSpecificCommands(Properties properties) {
        return this.applicationSpecificCommand.getApplicationSpecificCommands();
    }

    public final Command createUpdateJITFileCommand(final InstallOption installOption, final LicenseNumberProvider licenseNumberProvider) {
        return new Command(){

            public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) {
                JITFileCreationUtility.updateJITFile((String)installOption.getContext(), (String)file.getAbsolutePath(), (LicenseNumberProvider)licenseNumberProvider);
            }

            public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) {
            }
        };
    }
}

