/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.archive.zip.commonscompress;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.archive.ArchiveFileExtractor;
import com.mathworks.install.archive.zip.commonscompress.ArchiveEntryAdapter;
import com.mathworks.install.archive.zip.commonscompress.ArchiveEntryExtractor;
import com.mathworks.install.status.InstallStatusObserver;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

class ZipArchiveFileExtractorImpl
implements ArchiveFileExtractor {
    private final ArchiveEntryExtractor extractor;

    public ZipArchiveFileExtractorImpl(ArchiveEntryExtractor archiveEntryExtractor) {
        this.extractor = archiveEntryExtractor;
    }

    public void extract(File file, File file2, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration enumeration = zipFile.getEntries();
            while (enumeration.hasMoreElements()) {
                ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)enumeration.nextElement();
                ArchiveEntryAdapter archiveEntryAdapter = new ArchiveEntryAdapter((ArchiveEntry)zipArchiveEntry);
                this.extractor.extract(zipFile.getInputStream(zipArchiveEntry), archiveEntryAdapter, file2, installFlowControlHandler, installStatusObserverArray);
            }
        }
    }
}

