/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.archive.zip.commonscompress;

import com.google.inject.Inject;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.archive.ArchiveInputStreamExtractor;
import com.mathworks.install.archive.zip.commonscompress.ArchiveEntryAdapter;
import com.mathworks.install.archive.zip.commonscompress.ArchiveEntryExtractor;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;

final class CopyInputStreamToTempZipFileExtractor
implements ArchiveInputStreamExtractor {
    private final ArchiveEntryExtractor extractor;
    private final IO myIO;

    @Inject
    public CopyInputStreamToTempZipFileExtractor(ArchiveEntryExtractor archiveEntryExtractor, IO iO) {
        this.extractor = archiveEntryExtractor;
        this.myIO = iO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(InputStream inputStream, File file, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        ZipFile zipFile;
        block4: {
            File file2 = null;
            zipFile = null;
            try {
                file2 = this.createTempFileFromStream(inputStream);
                zipFile = new ZipFile(file2);
                Enumeration enumeration = zipFile.getEntries();
                while (enumeration.hasMoreElements()) {
                    this.extractEntry((ZipArchiveEntry)enumeration.nextElement(), zipFile, file, installFlowControlHandler, installStatusObserverArray);
                }
                if (file2 == null) break block4;
                file2.delete();
            }
            catch (Throwable throwable) {
                if (file2 != null) {
                    file2.delete();
                }
                ZipFile.closeQuietly(zipFile);
                throw throwable;
            }
        }
        ZipFile.closeQuietly((ZipFile)zipFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTempFileFromStream(InputStream inputStream) throws IOException, InterruptedException {
        try {
            File file = File.createTempFile("zip", null);
            this.myIO.createFileFromStream(inputStream, file, 0L, 292, new IOObserver[0]);
            File file2 = file;
            return file2;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractEntry(ZipArchiveEntry zipArchiveEntry, ZipFile zipFile, File file, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        InputStream inputStream = null;
        try {
            inputStream = zipFile.getInputStream(zipArchiveEntry);
            ArchiveEntryAdapter archiveEntryAdapter = new ArchiveEntryAdapter((ArchiveEntry)zipArchiveEntry);
            this.extractor.extract(inputStream, archiveEntryAdapter, file, installFlowControlHandler, installStatusObserverArray);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }
}

