/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.archive.zip.commonscompress;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.mathworks.install.archive.ArchiveFactory;
import com.mathworks.install.archive.ArchiveFileExtractor;
import com.mathworks.install.archive.ArchiveInputStreamExtractor;
import com.mathworks.install.archive.zip.commonscompress.ArchiveEntryExtractor;
import com.mathworks.install_impl.archive.DecodeArchiveInputStreamExtractor;
import com.mathworks.install_impl.archive.zip.commonscompress.ArchiveEntryExtractorImpl;
import com.mathworks.install_impl.archive.zip.commonscompress.BZipTwoTarArchiveFileExtractorImpl;
import com.mathworks.install_impl.archive.zip.commonscompress.CommonsCompressArchiveFactory;
import com.mathworks.install_impl.archive.zip.commonscompress.CopyInputStreamToTempZipFileExtractor;
import com.mathworks.install_impl.archive.zip.commonscompress.GZipTarArchiveFileExtractorImpl;
import com.mathworks.install_impl.archive.zip.commonscompress.ZipArchiveFileExtractorImpl;
import com.mathworks.install_impl.archive.zip.commonscompress.ZipArchiveInputStreamExtractor;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.Platform;

public final class CommonsCompressModule
extends AbstractModule {
    public static final String NO_DECODE_STREAM = "NoDecodeStream";
    public static final String ZIP_ARCHIVE_FILE_EXTRACTOR = "ZipArchiveFileExtractor";
    public static final String GZIP_TAR_ARCHIVE_FILE_EXTRACTOR = "GzipTarArchiveFileExtractor";
    public static final String BZ2_TAR_ARCHIVE_FILE_EXTRACTOR = "BZ2TarArchiveFileExtractor";

    protected void configure() {
        this.bind(ArchiveFactory.class).to(CommonsCompressArchiveFactory.class);
    }

    @Provides
    static ArchiveEntryExtractor provideArchiveEntryExtractor(IO iO) {
        return new ArchiveEntryExtractorImpl(iO);
    }

    @Provides
    static ArchiveFileExtractor provideArchiveFileExtractor(ArchiveEntryExtractor archiveEntryExtractor) {
        return new ZipArchiveFileExtractorImpl(archiveEntryExtractor);
    }

    @Provides
    @Named(value="ZipArchiveFileExtractor")
    static ArchiveFileExtractor provideZipArchiveFileExtractor(ArchiveEntryExtractor archiveEntryExtractor) {
        return new ZipArchiveFileExtractorImpl(archiveEntryExtractor);
    }

    @Provides
    @Named(value="GzipTarArchiveFileExtractor")
    static ArchiveFileExtractor provideGzipTarArchiveFileExtractor(ArchiveEntryExtractor archiveEntryExtractor) {
        return new GZipTarArchiveFileExtractorImpl(archiveEntryExtractor);
    }

    @Provides
    @Named(value="BZ2TarArchiveFileExtractor")
    static ArchiveFileExtractor provideBZipTwoArchiveFileExtractor(ArchiveEntryExtractor archiveEntryExtractor) {
        return new BZipTwoTarArchiveFileExtractorImpl(archiveEntryExtractor);
    }

    @Provides
    static ArchiveInputStreamExtractor provideArchiveInputStreamExtractor(Platform platform, ArchiveEntryExtractor archiveEntryExtractor, IO iO) {
        Object object = platform.isWindows() ? new ZipArchiveInputStreamExtractor(archiveEntryExtractor) : new CopyInputStreamToTempZipFileExtractor(archiveEntryExtractor, iO);
        return new DecodeArchiveInputStreamExtractor((ArchiveInputStreamExtractor)object);
    }

    @Provides
    @Named(value="NoDecodeStream")
    static ArchiveInputStreamExtractor provideNoDecodeArchiveInputStreamExtractor(Platform platform, ArchiveEntryExtractor archiveEntryExtractor, IO iO) {
        if (platform.isWindows()) {
            return new ZipArchiveInputStreamExtractor(archiveEntryExtractor);
        }
        return new CopyInputStreamToTempZipFileExtractor(archiveEntryExtractor, iO);
    }
}

