/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.archive.zip.commonscompress;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.archive.zip.commonscompress.ArchiveEntryExtractor;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.install_impl.archive.zip.commonscompress.AbstractTarArchiveFileExtractor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

class BZipTwoTarArchiveFileExtractorImpl
extends AbstractTarArchiveFileExtractor {
    private final ArchiveEntryExtractor extractor;

    public BZipTwoTarArchiveFileExtractorImpl(ArchiveEntryExtractor archiveEntryExtractor) {
        this.extractor = archiveEntryExtractor;
    }

    public void extract(File file, File file2, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        Path path = Files.createTempFile("interim", "tar", new FileAttribute[0]);
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
             FileOutputStream fileOutputStream = new FileOutputStream(path.toString());
             BZip2CompressorInputStream bZip2CompressorInputStream = new BZip2CompressorInputStream((InputStream)bufferedInputStream, true);){
            int n;
            byte[] byArray = new byte[1024];
            while (-1 != (n = bZip2CompressorInputStream.read(byArray))) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            bZip2CompressorInputStream.close();
        }
        this.extractTarEntries(this.extractor, file2, installFlowControlHandler, path, installStatusObserverArray);
        path.toFile().deleteOnExit();
    }
}

