/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl.archive.zip.commonscompress;

import com.google.inject.Inject;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.archive.zip.commonscompress.ArchiveEntryAdapter;
import com.mathworks.install.archive.zip.commonscompress.ArchiveEntryExtractor;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.install_impl.status.IOObserverAdapter;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public final class ArchiveEntryExtractorImpl
implements ArchiveEntryExtractor {
    private final IO myIO;

    @Inject
    public ArchiveEntryExtractorImpl(IO iO) {
        this.myIO = iO;
    }

    public void extract(InputStream inputStream, ArchiveEntryAdapter archiveEntryAdapter, File file, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        if (!archiveEntryAdapter.isDirectory()) {
            File file2 = new File(file, ArchiveEntryExtractorImpl.fixSlashes(archiveEntryAdapter.getName()));
            for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                installStatusObserver.addFile(file2);
            }
            if (archiveEntryAdapter.isSymlink()) {
                this.myIO.createSymLink(archiveEntryAdapter.getLinkName(inputStream), file2.getAbsolutePath());
            } else if (archiveEntryAdapter.isLink()) {
                File file3 = new File(file, ArchiveEntryExtractorImpl.fixSlashes(archiveEntryAdapter.getLinkName(inputStream)));
                if (file3 != null && file3.exists()) {
                    File file4 = file2.getParentFile();
                    if (file4 != null && !file4.exists()) {
                        Files.createDirectories(file4.toPath(), new FileAttribute[0]);
                    }
                    Files.createLink(file2.toPath(), file3.toPath());
                }
            } else {
                this.myIO.createFileFromStream(inputStream, file2, archiveEntryAdapter.getTime(), archiveEntryAdapter.getPermissions(), new IOObserver[]{new IOObserverAdapter(installFlowControlHandler, installStatusObserverArray)});
            }
        }
    }

    private static String fixSlashes(String string) {
        return string.replace('/', File.separatorChar);
    }
}

