/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl;

import com.mathworks.install.ComponentContainer;
import com.mathworks.install.ComponentContainerHandler;
import com.mathworks.install.ComponentData;
import com.mathworks.install.Product;
import com.mathworks.install.ProductContainer;
import com.mathworks.install.XMLParseException;
import com.mathworks.install.XMLParseStrategy;
import com.mathworks.install.XMLParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

final class XMLParserImpl
implements XMLParser {
    private static final String INSTALLER_TYPE_PROFESSIONAL = "professional";
    private final SAXBuilder saxBuilder = new SAXBuilder();
    private final ComponentContainerHandler componentContainerHandler;
    private final XMLParseStrategy xmlParseStrategy;
    private ProductContainer productContainer;
    private ComponentContainer componentContainer;

    public XMLParserImpl(ProductContainer productContainer, ComponentContainer componentContainer, ComponentContainerHandler componentContainerHandler, XMLParseStrategy xMLParseStrategy) {
        this.productContainer = productContainer;
        this.componentContainer = componentContainer;
        this.componentContainerHandler = componentContainerHandler;
        this.xmlParseStrategy = xMLParseStrategy;
    }

    public void addToProductContainer(Product product, ComponentData[] componentDataArray, String string, String string2, String[] stringArray, boolean bl, Document document) throws IOException {
        this.productContainer.add(product, componentDataArray, string, string2, stringArray, bl, XMLParserImpl.getXML(document));
    }

    public void parse(byte[] byArray, String string) throws IOException, XMLParseException {
        this.parseRootElement(this.getDocument(new ByteArrayInputStream(byArray)), string);
    }

    void parseRootElement(Document document, String string) throws IOException {
        Element element = document.getRootElement();
        if ("productData".equalsIgnoreCase(element.getName())) {
            this.xmlParseStrategy.parseProductData(document, string, (XMLParser)this, element);
        } else if ("productAdditionalComps".equalsIgnoreCase(element.getName())) {
            this.xmlParseStrategy.parseProductAdditionalComponents(document, string, (XMLParser)this, element);
        } else if ("productOptionalComps".equalsIgnoreCase(element.getName())) {
            this.xmlParseStrategy.parseProductOptionalComponents(document, string, (XMLParser)this, element);
        } else if ("componentData".equalsIgnoreCase(element.getName())) {
            for (Object e : element.getChildren()) {
                Element element2 = (Element)e;
                this.buildComponent(element2, document);
            }
        }
    }

    private Document getDocument(InputStream inputStream) throws IOException, XMLParseException {
        Document document;
        try {
            document = this.saxBuilder.build(inputStream);
        }
        catch (JDOMException jDOMException) {
            throw new XMLParseException((Throwable)jDOMException);
        }
        return document;
    }

    void buildComponent(Element element, Document document) throws IOException {
        String string = element.getChildText("componentBaseName");
        String string2 = element.getChildText("componentFileName");
        String[] stringArray = XMLParserImpl.getPlatformListFromElement(element);
        String string3 = element.getChildText("componentVersion");
        int n = element.getChild("locationId") == null ? 1 : new Integer(element.getChildText("locationId"));
        String string4 = element.getChildText("releaseFamily");
        String string5 = element.getChildText("type");
        long l = XMLParserImpl.getSize(element);
        long l2 = new Long(element.getChildText("uncompressedBytes"));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        Element element2 = element.getChild("componentFileName");
        Attribute attribute = element2.getAttribute("manifest");
        if (attribute != null) {
            arrayList.add(attribute.getValue());
        }
        String string6 = XMLParserImpl.getLocale(element);
        boolean bl = XMLParserImpl.getIsInstructionSet(element);
        String string7 = element.getChildText("componentName");
        ComponentData componentData = this.componentContainer.createComponent(XMLParserImpl.getBackwardCompatibleComponentName(string2, string7), string3, string6, stringArray, bl);
        this.componentContainerHandler.addComponent(componentData, XMLParserImpl.getXML(document), string2, string, string4, string5, l2, l, n, arrayList.toArray(new String[arrayList.size()]));
    }

    private static String getBackwardCompatibleComponentName(String string, String string2) {
        return string2 == null ? FilenameUtils.removeExtension((String)string) : string2;
    }

    private static String getLocale(Element element) {
        String string = element.getChildText("locale");
        return string == null ? "" : string;
    }

    private static boolean getIsInstructionSet(Element element) {
        boolean bl = false;
        String string = element.getChildText("instrset");
        if (string != null) {
            bl = string.equals("1");
        }
        return bl;
    }

    static String getXML(Document document) throws IOException {
        StringWriter stringWriter = new StringWriter();
        XMLOutputter xMLOutputter = new XMLOutputter();
        xMLOutputter.setFormat(Format.getPrettyFormat());
        xMLOutputter.output(document, (Writer)stringWriter);
        return stringWriter.toString();
    }

    private static long getSize(Element element) {
        String string = element.getChildText("size");
        if (string == null) {
            return 0L;
        }
        return new Long(string);
    }

    public Product getCoreProductData(Element element, String string) throws IOException {
        String string2 = element.getChildText("productName");
        int n = new Integer(element.getChildText("productNumber"));
        String string3 = "";
        if (element.getChildText("productBaseCode") != null) {
            string3 = element.getChildText("productBaseCode");
        }
        String string4 = element.getChildText("productVersion");
        boolean bl = Boolean.valueOf(element.getChildText("isControllingProduct"));
        String string5 = element.getChildText("releaseFamily");
        String string6 = "NO_DESCRIPTION";
        if (element.getChildText("releaseDescription") != null) {
            string6 = element.getChildText("releaseDescription");
        }
        return this.productContainer.createProduct(string2, n, string3, string4, bl, string, string5, string6);
    }

    public ComponentData[] getDependsOnComponents(Element element) {
        ArrayList<ComponentData> arrayList = new ArrayList<ComponentData>();
        Element element2 = element.getChild("dependsOn");
        for (Object e : element2.getChildren()) {
            Element element3 = (Element)e;
            String[] stringArray = XMLParserImpl.getPlatformListFromElement(element3);
            String string = XMLParserImpl.getProductArchiveCompatibleComponentName(element3.getChildText("name"));
            ComponentData componentData = this.componentContainer.createComponent(string, element3.getChildText("version"), XMLParserImpl.getLocale(element3), stringArray, XMLParserImpl.getIsInstructionSet(element3));
            arrayList.add(componentData);
        }
        return arrayList.toArray(new ComponentData[arrayList.size()]);
    }

    private static String getProductArchiveCompatibleComponentName(String string) {
        return "zip".equals(FilenameUtils.getExtension((String)string)) ? FilenameUtils.removeExtension((String)string) : string;
    }

    public void mergeAdditionalProductData(Product product, Element element, String string) throws IOException {
        String[] stringArray = XMLParserImpl.getPlatformListFromElement(element);
        ComponentData[] componentDataArray = this.getDependsOnComponents(element);
        Collection<Product> collection = this.getProductsByTagName(element, string, "requiredProducts");
        Collection<Product> collection2 = this.getProductsByTagName(element, string, "altDependencies");
        String[] stringArray2 = XMLParserImpl.getUsageListFromElement(element);
        String string2 = element.getChildText("releaseFamily");
        String string3 = "NO_DESCRIPTION";
        if (element.getChildText("releaseDescription") != null) {
            string3 = element.getChildText("releaseDescription");
        }
        String string4 = "";
        if (element.getChildText("licenseAgreementType") != null) {
            string4 = element.getChildText("licenseAgreementType");
        }
        String string5 = "";
        if (element.getChildText("productType") != null) {
            string5 = element.getChildText("productType");
        }
        this.productContainer.merge(product, componentDataArray, collection.toArray(new Product[collection.size()]), collection2.toArray(new Product[collection2.size()]), stringArray, stringArray2, string2, string3, string4, string5);
    }

    private Collection<Product> getProductsByTagName(Element element, String string, String string2) throws IOException {
        ArrayList<Product> arrayList = new ArrayList<Product>();
        if (element.getChild(string2) != null) {
            for (Object e : element.getChild(string2).getChildren()) {
                Element element2 = (Element)e;
                Product product = this.getCoreProductData(element2, string);
                arrayList.add(product);
            }
        }
        return arrayList;
    }

    private static String[] getUsageListFromElement(Element element) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Element element2 = element.getChild("installerUsage");
        if (element2 == null) {
            arrayList.add(INSTALLER_TYPE_PROFESSIONAL);
        } else {
            for (Object e : element2.getChildren()) {
                Element element3 = (Element)e;
                arrayList.add(element3.getText());
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] getPlatformListFromElement(Element element) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Element element2 = element.getChild("platformList");
        String string = element.getChildText("platform");
        if (element2 != null) {
            List list = element2.getChildren("platform");
            for (Element element3 : list) {
                arrayList.add(element3.getText());
            }
        } else if (string != null) {
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

