/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl;

import com.mathworks.install.Product;
import com.mathworks.install_impl.AbstractValidatedFik;
import java.util.Collection;
import java.util.HashSet;

final class ValidatedFikImpl
extends AbstractValidatedFik {
    private final String fik;
    private final boolean isDemo;
    private final boolean isNetwork;
    private final Collection<Integer> productNumberCollection = new HashSet<Integer>();

    public ValidatedFikImpl(String string, boolean bl, boolean bl2, int[] nArray) {
        this.fik = string;
        this.isDemo = bl;
        this.isNetwork = bl2;
        this.getProductNumbersOnFik(nArray);
    }

    public String get() {
        return this.fik;
    }

    private void getProductNumbersOnFik(int[] nArray) {
        for (int n : nArray) {
            if (n <= 0 && !this.isNetwork) continue;
            this.productNumberCollection.add(n);
        }
    }

    @Override
    public Integer[] getProducts() {
        return this.productNumberCollection.toArray(new Integer[this.productNumberCollection.size()]);
    }

    public boolean canActivate() {
        return !this.isNetwork && !this.containsMDCS();
    }

    public boolean canInstall(Product product, long l) {
        return this.productNumberCollection.contains(product.getProductNumber());
    }

    public boolean requiresLicenseFile() {
        return this.isNetwork;
    }

    private boolean containsMDCS() {
        return this.productNumberCollection.contains(94);
    }

    @Override
    public boolean isJITEnabledFik() {
        return false;
    }

    @Override
    public boolean isTEUEnabledFik() {
        return false;
    }
}

