/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.mathworks.install.ApplicationSpecificCommand;
import com.mathworks.install.CommandContainer;
import com.mathworks.install.ComponentAggregator;
import com.mathworks.install.ComponentContainer;
import com.mathworks.install.ComponentInstaller;
import com.mathworks.install.ContentOptimizer;
import com.mathworks.install.DefaultDirectoryProvider;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallConfigurationPersistence;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallOptionProvider;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.InstalledProductData;
import com.mathworks.install.InstalledProductDataFactory;
import com.mathworks.install.InstalledProductDataVersion;
import com.mathworks.install.InstallerBuilder;
import com.mathworks.install.InstallerDownloadInfoContainer;
import com.mathworks.install.InstallerFactory;
import com.mathworks.install.InstallerRequirements;
import com.mathworks.install.ProductContainer;
import com.mathworks.install.ProductCorrelator;
import com.mathworks.install.ProductInstaller;
import com.mathworks.install.XMLParseStrategy;
import com.mathworks.install.XMLParserFactory;
import com.mathworks.install.command.Command;
import com.mathworks.install.command.CommandFactory;
import com.mathworks.install.input.InstallationInputFileFactory;
import com.mathworks.install.input.XMLInstallationFileParser;
import com.mathworks.install.service.ServiceFactory;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install_impl.ApplicationSpecificCommandAdapter;
import com.mathworks.install_impl.CommandContainerImpl;
import com.mathworks.install_impl.ComponentContainerImpl;
import com.mathworks.install_impl.ComponentInstallerImpl;
import com.mathworks.install_impl.ContentOptimizerImpl;
import com.mathworks.install_impl.DefaultDirectoryProviderNonWindows;
import com.mathworks.install_impl.DefaultDirectoryProviderWindows;
import com.mathworks.install_impl.InstallConfigurationAdapter;
import com.mathworks.install_impl.InstallOptionProviderImpl;
import com.mathworks.install_impl.InstalledProductDataFactoryImpl;
import com.mathworks.install_impl.InstalledProductDataImpl;
import com.mathworks.install_impl.InstalledProductDataVersionImpl;
import com.mathworks.install_impl.InstallerBuilderImpl;
import com.mathworks.install_impl.InstallerDownloadInfoContainerImpl;
import com.mathworks.install_impl.InstallerFactoryImpl;
import com.mathworks.install_impl.PreProductInstaller;
import com.mathworks.install_impl.ProductContainerImpl;
import com.mathworks.install_impl.ProductInstallerImpl;
import com.mathworks.install_impl.XMLInstallationFileParserImpl;
import com.mathworks.install_impl.XMLParseStrategyForInstall;
import com.mathworks.install_impl.XMLParserFactoryImpl;
import com.mathworks.install_impl.archive.zip.commonscompress.CommonsCompressModule;
import com.mathworks.install_impl.command.CommandModule;
import com.mathworks.install_impl.input.InputModule;
import com.mathworks.install_impl.service.ServiceModule;
import com.mathworks.install_impl.status.InstallStatusObserverAdapter;
import com.mathworks.install_impl.status.LoggingInstallStatusObserver;
import com.mathworks.instutil.Downloader;
import com.mathworks.instutil.DownloaderImpl;
import com.mathworks.instutil.ExecutorServiceManager;
import com.mathworks.instutil.ExecutorServiceManagerImpl;
import com.mathworks.instutil.FileIO;
import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.FilePermissionsUtil;
import com.mathworks.instutil.FolderUtils;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.LicenseNumberProvider;
import com.mathworks.instutil.LicenseNumberProviderImpl;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.ProcessExecutor;
import com.mathworks.instutil.ProcessExecutorImpl;
import com.mathworks.instutil.Registry;
import com.mathworks.instutil.RegistryImpl;
import com.mathworks.instutil.SecurityOverride;
import com.mathworks.instutil.URLConnectionFactory;
import com.mathworks.instutil.URLConnectionFactoryImpl;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public final class UpdateInstallerModule
extends AbstractModule {
    private static final String LOGGING_STATUS_OBSERVER = "loggingStatusObserver";
    private static final String INSTALL_STATUS_OBSERVER = "installStatusObserver";
    private static final String UNINSTALL_STATUS_FACTOR = "uninstallStatusFactor";
    private final Module archiveModule;
    private final InstallConfiguration installConfiguration;
    private static final String PRE_INSTALLER = "PreInstaller";
    private static final String POST_INSTALLER = "PostInstaller";

    public UpdateInstallerModule() {
        this(new InstallConfigurationAdapter());
    }

    public UpdateInstallerModule(InstallConfiguration installConfiguration) {
        this(installConfiguration, (Module)new CommonsCompressModule());
    }

    private UpdateInstallerModule(InstallConfiguration installConfiguration, Module module) {
        this.installConfiguration = installConfiguration;
        this.archiveModule = module;
    }

    @Provides
    static Downloader provideDownloader(URLConnectionFactory uRLConnectionFactory, FolderUtils folderUtils) {
        return new DownloaderImpl(uRLConnectionFactory, folderUtils);
    }

    @Provides
    static URLConnectionFactory provideURLConnectionFactory() {
        return new URLConnectionFactoryImpl();
    }

    @Provides
    static InstalledProductDataFactory provideInstalledProductDataFactory(XMLParserFactory xMLParserFactory, ExecutorServiceManager executorServiceManager, Platform platform, InstallConfiguration installConfiguration, IO iO, AppLogger appLogger) {
        return new InstalledProductDataFactoryImpl(xMLParserFactory, executorServiceManager.getMultiThreadedExecutorService(), platform, installConfiguration, iO, appLogger);
    }

    @Singleton
    @Provides
    static InstalledProductData provideInstalledProductData(XMLParserFactory xMLParserFactory, ExecutorServiceManager executorServiceManager, Platform platform, InstalledProductDataVersion installedProductDataVersion, IO iO, AppLogger appLogger) {
        ComponentContainerImpl componentContainerImpl = new ComponentContainerImpl();
        return new InstalledProductDataImpl(new ProductContainerImpl(componentContainerImpl), componentContainerImpl, xMLParserFactory, executorServiceManager.getMultiThreadedExecutorService(), platform, installedProductDataVersion, iO, appLogger);
    }

    @Provides
    static DefaultDirectoryProvider provideDefaultDirectoryProvider(Platform platform, Registry registry, InstallConfiguration installConfiguration) {
        if (platform.isWindows()) {
            return new DefaultDirectoryProviderWindows(registry, installConfiguration, platform);
        }
        return new DefaultDirectoryProviderNonWindows(installConfiguration, platform);
    }

    @Provides
    @Singleton
    static InstallerBuilder provideInstallerBuilder(Platform platform, ProductContainer productContainer, InstallerFactory installerFactory, InstalledProductData installedProductData, ExecutorServiceManager executorServiceManager, InstallConfiguration installConfiguration, InstallationInputFileFactory installationInputFileFactory, AppLogger appLogger, XMLInstallationFileParser xMLInstallationFileParser) {
        return new InstallerBuilderImpl(platform.getArchString(), productContainer, installerFactory, installedProductData, executorServiceManager, installationInputFileFactory, appLogger, installConfiguration, xMLInstallationFileParser);
    }

    @Provides
    static CommandContainer provideCommandContainer(Platform platform, Properties properties, CommandFactory commandFactory, ServiceFactory serviceFactory, InstallConfiguration installConfiguration, InstallConfigurationPersistence installConfigurationPersistence, IO iO, InstallerRequirements installerRequirements, LicenseNumberProvider licenseNumberProvider, File file) {
        String string = file == null ? properties.getProperty("root") : file.getAbsolutePath();
        return new CommandContainerImpl(string, commandFactory, serviceFactory, installConfiguration, iO, installConfigurationPersistence, installerRequirements, properties, platform, licenseNumberProvider);
    }

    @Provides
    @Singleton
    public static LicenseNumberProvider provideLicenseProvider(Properties properties) {
        return new LicenseNumberProviderImpl(properties.getProperty("licenseNumber", ""));
    }

    @Provides
    static InstallerFactory provideInstallerFactory(InstallOptionProvider installOptionProvider, @Named(value="PreInstaller") ProductInstaller productInstaller, ProductInstaller productInstaller2, InstalledProductData installedProductData, @Named(value="PostInstaller") ProductInstaller productInstaller3, InstalledProductDataFactory installedProductDataFactory, ProductContainer productContainer, IO iO, AppLogger appLogger, UsageDataCollector usageDataCollector, ProductCorrelator productCorrelator) {
        return new InstallerFactoryImpl(installOptionProvider, installedProductData, installedProductDataFactory, productContainer, iO, appLogger, usageDataCollector, productCorrelator, productInstaller, productInstaller2, productInstaller3);
    }

    @Provides
    static IO provideIO(FilePermissions filePermissions, SecurityOverride securityOverride) {
        return new FileIO(filePermissions, securityOverride);
    }

    @Provides
    @Named(value="PreInstaller")
    static ProductInstaller providePreInstaller(CommandContainer commandContainer) {
        return new PreProductInstaller(commandContainer);
    }

    @Provides
    @Named(value="PostInstaller")
    static ProductInstaller providePostInstaller(final CommandContainer commandContainer) {
        return new ProductInstaller(){

            public void installProducts(String string, File file, File file2, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray, InstallFlowControlHandler installFlowControlHandler, ComponentContainer componentContainer, InstallStatusObserver ... installStatusObserverArray) throws InterruptedException {
            }

            public void updateProducts(InstallableProduct[] installableProductArray, ComponentContainer componentContainer, File file, File file2, InstallFlowControlHandler installFlowControlHandler, Platform platform, ProductContainer productContainer, InstallStatusObserver ... installStatusObserverArray) throws InterruptedException {
                for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                    installStatusObserver.postInstall();
                }
                for (InstallStatusObserver installStatusObserver : commandContainer.getPostInstallCommands(installableProductArray)) {
                    installFlowControlHandler.checkTaskState();
                    try {
                        installStatusObserver.execute(platform.getArchString(), file, installFlowControlHandler);
                        this.update(installStatusObserverArray);
                    }
                    catch (IOException iOException) {
                        installFlowControlHandler.exception((Throwable)iOException);
                    }
                }
                installFlowControlHandler.checkTaskState();
            }

            public void downloadProducts(String string, File file, InstallableProduct[] installableProductArray, InstallFlowControlHandler installFlowControlHandler, ComponentContainer componentContainer, InstallStatusObserver ... installStatusObserverArray) {
            }

            private void update(InstallStatusObserver[] installStatusObserverArray) {
                for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                    installStatusObserver.updateUnits(0x100000L);
                }
            }

            public long getInstallUnits(String string, File file, InstallableProduct[] installableProductArray, InstallableProduct[] installableProductArray2, InstallOption[] installOptionArray, ProductContainer productContainer, ComponentContainer componentContainer) {
                return (long)commandContainer.getPostInstallCommands(installOptionArray, installableProductArray).length * 0x100000L;
            }

            public List<String> getUpdatableComponentNames(InstallableProduct[] installableProductArray) {
                return new ArrayList<String>();
            }

            public void uninstallProducts(String string, File file, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray, InstallFlowControlHandler installFlowControlHandler, ProductContainer productContainer, ComponentContainer componentContainer, InstallStatusObserver ... installStatusObserverArray) throws InterruptedException {
                Command[] commandArray;
                for (Command command : commandArray = commandContainer.getPostUninstallCommands(installOptionArray, installableProductArray)) {
                    installFlowControlHandler.checkTaskState();
                    try {
                        command.undo(string, file, installFlowControlHandler);
                        this.update(installStatusObserverArray);
                    }
                    catch (IOException iOException) {
                        installFlowControlHandler.exception((Throwable)iOException);
                    }
                }
                installFlowControlHandler.checkTaskState();
            }

            public long getUninstallUnits(String string, File file, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray, ProductContainer productContainer, ComponentContainer componentContainer) {
                int n = commandContainer.getPostUninstallCommands(installOptionArray, installableProductArray).length;
                long l = (long)n * 0x100000L;
                return l;
            }

            public void calculateSpaceRequired(String string, File file, InstallableProduct[] installableProductArray, InstallableProduct[] installableProductArray2, ProductContainer productContainer, ComponentContainer componentContainer, ComponentAggregator componentAggregator) {
            }
        };
    }

    protected void configure() {
        this.bind(ProcessExecutor.class).to(ProcessExecutorImpl.class);
        this.bind(Registry.class).to(RegistryImpl.class);
        this.bind(Platform.class).toInstance((Object)new PlatformImpl());
        this.bind(ProductContainer.class).to(ProductContainerImpl.class).in(Scopes.SINGLETON);
        this.bind(ComponentContainer.class).to(ComponentContainerImpl.class).in(Scopes.SINGLETON);
        this.bind(FilePermissions.class).to(FilePermissionsUtil.class);
        this.bind(ComponentInstaller.class).to(ComponentInstallerImpl.class);
        this.bind(XMLParserFactory.class).to(XMLParserFactoryImpl.class).in(Scopes.SINGLETON);
        this.bind(InstallStatusObserver.class).annotatedWith((Annotation)Names.named((String)LOGGING_STATUS_OBSERVER)).to(LoggingInstallStatusObserver.class);
        this.bind(InstallStatusObserver.class).annotatedWith((Annotation)Names.named((String)INSTALL_STATUS_OBSERVER)).to(InstallStatusObserverAdapter.class);
        this.bind(ProductInstaller.class).to(ProductInstallerImpl.class);
        this.bind(Long.class).annotatedWith((Annotation)Names.named((String)UNINSTALL_STATUS_FACTOR)).toInstance((Object)10000L);
        this.bind(InstallConfiguration.class).toInstance((Object)this.installConfiguration);
        this.bind(InstalledProductDataVersion.class).to(InstalledProductDataVersionImpl.class);
        this.bind(XMLInstallationFileParser.class).to(XMLInstallationFileParserImpl.class);
        this.bind(ContentOptimizer.class).to(ContentOptimizerImpl.class);
        this.bind(XMLParseStrategy.class).to(XMLParseStrategyForInstall.class);
        this.bind(InstallerDownloadInfoContainer.class).to(InstallerDownloadInfoContainerImpl.class);
        this.bind(InstallOptionProvider.class).to(InstallOptionProviderImpl.class);
        this.bind(ExecutorServiceManager.class).to(ExecutorServiceManagerImpl.class).in(Scopes.SINGLETON);
        this.bind(ApplicationSpecificCommand.class).to(ApplicationSpecificCommandAdapter.class);
        this.install((Module)new ServiceModule());
        this.install((Module)new CommandModule());
        this.bind(InstallFlowControlHandler.class).toInstance((Object)new InstallFlowControlHandler(){

            public boolean shouldRetry(String string, String string2, Throwable throwable) {
                return false;
            }

            public boolean checkTaskState() {
                return false;
            }

            public void alert(String string) {
            }

            public void showInfoMessage(String string, String string2) {
            }

            public void exception(Throwable throwable) {
            }

            public void alert(String string, String string2) {
            }

            public void alert(Exception exception) {
            }

            public void logMsg(String string) {
            }

            public void exitImmediately(Throwable throwable) {
            }
        });
        this.install(this.archiveModule);
        this.install((Module)new InputModule());
    }
}

