/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.mathworks.install.ComponentAggregator;
import com.mathworks.install.ComponentContainer;
import com.mathworks.install.ComponentData;
import com.mathworks.install.ComponentInstaller;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallableComponent;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.InstalledProductData;
import com.mathworks.install.Product;
import com.mathworks.install.ProductContainer;
import com.mathworks.install.ProductInstaller;
import com.mathworks.install.UpdateProductContainer;
import com.mathworks.install.resources.InstallResourceKeys;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.install_impl.ComponentSizeAggregator;
import com.mathworks.install_impl.MultiThreadedDownloadPool;
import com.mathworks.instutil.IOObserver;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;

final class ProductInstallerImpl
implements ProductInstaller {
    private static final int DVD1_LOCATION_ID = 1;
    private final ComponentContainer productInstallerComponentContainer;
    private final ComponentInstaller componentInstaller;
    private final InstalledProductData fileList;
    private final InstallStatusObserver installStatusObserver;
    private final long statusFactor;
    private final UsageDataCollector usageDataCollector;
    private final Properties properties;
    private final UpdateProductContainer updateProductContainer;
    private final ProductContainer theProductContainer;
    private final Map<InstallableProduct, Set<InstallableComponent>> productsOnSecondDvd;
    private InstallStatusObserver[] allObservers;
    private Map<String, InstallableComponent> installedComponents;
    private Map<String, ComponentData> latestComponentsToBeInstalled;
    private boolean isRunningFromDVD = false;
    private final AppLogger appLogger;

    @Inject
    ProductInstallerImpl(ProductContainer productContainer, ComponentContainer componentContainer, ComponentInstaller componentInstaller, InstalledProductData installedProductData, @Named(value="loggingStatusObserver") InstallStatusObserver installStatusObserver, @Named(value="uninstallStatusFactor") Long l, UsageDataCollector usageDataCollector, Properties properties, UpdateProductContainer updateProductContainer, AppLogger appLogger) {
        this.theProductContainer = productContainer;
        this.productInstallerComponentContainer = componentContainer;
        this.componentInstaller = componentInstaller;
        this.fileList = installedProductData;
        this.installStatusObserver = installStatusObserver;
        this.statusFactor = l;
        this.usageDataCollector = usageDataCollector;
        this.properties = properties;
        this.appLogger = appLogger;
        this.updateProductContainer = updateProductContainer;
        this.productsOnSecondDvd = new TreeMap<InstallableProduct, Set<InstallableComponent>>(new Comparator<InstallableProduct>(){

            @Override
            public int compare(InstallableProduct installableProduct, InstallableProduct installableProduct2) {
                return installableProduct.getProductData().getName().compareTo(installableProduct2.getProductData().getName());
            }
        });
    }

    public void installProducts(String string, File file, File file2, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray, InstallFlowControlHandler installFlowControlHandler, ComponentContainer componentContainer, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        this.downloadProducts(string, file2, installableProductArray, installFlowControlHandler, componentContainer, installStatusObserverArray);
        this.isRunningFromDVD = this.checkIfRunningFromRightSplitDVDArea(this.properties.getProperty("batDVD1Root", this.properties.getProperty("root")), ".dvd1");
        for (InstallableProduct installableProduct : installableProductArray) {
            this.installProduct(string, file, file2, installFlowControlHandler, this.allObservers, this.installedComponents, this.latestComponentsToBeInstalled, installableProduct);
            this.fileList.installProductFileData(ProductInstallerImpl.getProductNameAndVersion(installableProduct.getProductData()), file.getAbsolutePath(), installableProduct.getXML());
        }
        if (this.secondDVDRequired()) {
            this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_DVD_USED, (Object)"2");
            while (!this.checkIfRunningFromRightSplitDVDArea(this.properties.getProperty("batDVD2Root", this.properties.getProperty("root")), ".dvd2")) {
                installFlowControlHandler.showInfoMessage(InstallResourceKeys.INSERT_SECOND_DVD_TITLE.getString(new Object[0]), InstallResourceKeys.INSERT_SECOND_DVD_MESSAGE.getString(new Object[0]));
            }
            for (Map.Entry entry : this.productsOnSecondDvd.entrySet()) {
                ProductInstallerImpl.updateObserversAndGetProductData((InstallableProduct)entry.getKey(), this.allObservers);
                InstallableComponent[] installableComponentArray = ((Set)entry.getValue()).toArray(new InstallableComponent[0]);
                this.componentInstaller.installComponents(file, file2, installableComponentArray, installFlowControlHandler, this.allObservers);
            }
        }
    }

    public void updateProducts(InstallableProduct[] installableProductArray, ComponentContainer componentContainer, File file, File file2, final InstallFlowControlHandler installFlowControlHandler, Platform platform, ProductContainer productContainer, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        Object object;
        ComponentData[] componentDataArray;
        this.allObservers = ProductInstallerImpl.combineObservers(this.installStatusObserver, installStatusObserverArray);
        LinkedHashSet<InstallableProduct> linkedHashSet = new LinkedHashSet<InstallableProduct>(Arrays.asList(productContainer.getInstallableProducts()));
        this.removeComponentFileData(componentContainer, file);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (InstallableProduct installableProduct : installableProductArray) {
            this.collectInstalledProductsData(installableProduct);
            hashMap.put(installableProduct.getProductData().getName(), installableProduct.getProductData().getNameVersionReleaseAndReleaseDescription());
        }
        List<String> list = this.getUpdatableProductNames(installableProductArray);
        File file3 = Files.createTempDirectory("update", new FileAttribute[0]).toFile();
        long l = System.currentTimeMillis();
        this.componentInstaller.deleteFilesFromComponent(file, componentContainer, componentContainer.getInstalledComponentNames(), this.allObservers);
        long l2 = System.currentTimeMillis();
        double d = (double)(l2 - l) / 1000.0;
        long l3 = System.currentTimeMillis();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list2 = this.updateProductContainer.getComponentsToDelete(string);
            String string2 = (String)hashMap.get(string);
            if (list2.isEmpty()) continue;
            componentDataArray = ProductInstallerImpl.getNonSharedComponents(string2, platform.getArchString(), linkedHashSet, productContainer);
            object = new ArrayList();
            for (ComponentData componentData : componentDataArray) {
                object.add(componentData.getName());
            }
            list2.retainAll((Collection<?>)object);
            Map map = componentContainer.getUpdatableComponents(list2, componentContainer.getInstalledComponentNames());
            if (map.isEmpty()) continue;
            InstallableComponent[] installableComponentArray = map.values().toArray(new InstallableComponent[0]);
            this.componentInstaller.uninstallComponents(file, installableComponentArray, installFlowControlHandler, this.allObservers);
        }
        long l4 = System.currentTimeMillis();
        d += (double)(l4 - l3) / 1000.0;
        double d2 = 0.0;
        componentDataArray = list.iterator();
        while (componentDataArray.hasNext()) {
            List list3;
            object = (String)componentDataArray.next();
            long l5 = System.currentTimeMillis();
            HashSet hashSet = new HashSet();
            hashSet.addAll(this.updateProductContainer.getComponentsToAdd((String)object));
            hashSet.addAll(this.updateProductContainer.getComponentsToUpdate((String)object));
            if (!hashSet.isEmpty()) {
                Map map = this.productInstallerComponentContainer.getUpdatableInstallableComponents(Arrays.asList(hashSet.toArray(new String[0])));
                for (InstallableComponent installableComponent : map.values()) {
                    installableComponent.download(file3, installFlowControlHandler, new IOObserver(){

                        public boolean updateBytes(long l) throws InterruptedException {
                            return installFlowControlHandler.checkTaskState();
                        }
                    }, new InstallStatusObserver[]{this.installStatusObserver});
                }
            }
            long l6 = System.currentTimeMillis();
            d2 += (double)(l6 - l5) / 1000.0;
            ProductInstallerImpl.updateObservers((String)object, this.allObservers);
            long l7 = System.currentTimeMillis();
            List list4 = this.updateProductContainer.getComponentsToUpdate((String)object);
            if (!list4.isEmpty()) {
                this.componentInstaller.updateComponents(file, file2, file3, installFlowControlHandler, this.productInstallerComponentContainer, list4, componentContainer.getInstalledComponentNames(), this.allObservers);
            }
            if (!(list3 = this.updateProductContainer.getComponentsToAdd((String)object)).isEmpty()) {
                this.componentInstaller.addComponents(file, file2, file3, installFlowControlHandler, this.productInstallerComponentContainer, list3, componentContainer.getInstalledComponentNames(), this.allObservers);
            }
            long l8 = System.currentTimeMillis();
            d += (double)(l8 - l7) / 1000.0;
        }
        componentDataArray = this.componentInstaller.getVersionInfoComponent();
        if (!this.fileList.isLockedFilesExist()) {
            this.componentInstaller.installComponents(file, file3, new InstallableComponent[]{componentDataArray}, installFlowControlHandler, this.allObservers);
        } else {
            this.componentInstaller.handleLockedComponent(file, file2, file3, installFlowControlHandler, (InstallableComponent)componentDataArray, this.allObservers);
        }
        FileUtils.forceDelete((File)file3);
        this.updateComponentFileData(installableProductArray, componentContainer.getInstalledComponentNames(), file, platform);
        this.updateProductFileData(installableProductArray, file);
        this.componentInstaller.updateAppdataForComponentsWithTouchedFiles(file, this.productInstallerComponentContainer, componentContainer.getInstalledComponentNames());
        this.usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_TOTAL_INSTALLATION_TIME, (Object)((long)d));
        this.usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_TOTAL_DOWNLOAD_TIME, (Object)((long)d2));
        this.usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_INSTALLATION_SUCCESSFUL, (Object)true);
        this.usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_DOWNLOAD_SUCCESSFUL, (Object)true);
    }

    private void removeComponentFileData(ComponentContainer componentContainer, File file) {
        Map<String, InstallableComponent> map = ProductInstallerImpl.getLatestVersionOfInstalledComponentsByName(componentContainer);
        for (InstallableComponent installableComponent : map.values()) {
            String string = installableComponent.getComponentData().getComponentNameAndVersion();
            this.fileList.uninstallComponentFileData(string, file.getAbsolutePath());
        }
    }

    private void updateComponentFileData(InstallableProduct[] installableProductArray, Set<String> set, File file, Platform platform) throws IOException {
        List<String> list = this.getUpdatableComponentNames(installableProductArray);
        Set<ComponentData> set2 = ProductInstallerImpl.getComponentsOfProducts(ProductInstallerImpl.createProductNameSet(installableProductArray), platform.getArchString(), this.theProductContainer);
        for (ComponentData componentData : set2) {
            InstallableComponent installableComponent = this.productInstallerComponentContainer.getInstallableComponent(componentData);
            if (!list.isEmpty() && list.contains(componentData.getName()) || !set.contains(componentData.getName())) continue;
            this.fileList.installComponentFileData(componentData.getComponentNameAndVersion(), file.getAbsolutePath(), installableComponent.getXML());
        }
    }

    private void updateProductFileData(InstallableProduct[] installableProductArray, File file) throws IOException {
        for (InstallableProduct installableProduct : installableProductArray) {
            this.fileList.removeProduct(ProductInstallerImpl.getProductNameAndVersion(installableProduct.getProductData()), file.getAbsolutePath());
            InstallableProduct installableProduct2 = this.theProductContainer.getInstallableProductByBaseCode(installableProduct.getProductData().getProductBaseCode());
            this.fileList.installProductFileData(ProductInstallerImpl.getProductNameAndVersion(installableProduct2.getProductData()), file.getAbsolutePath(), installableProduct2.getXML());
        }
    }

    private void collectInstalledProductsData(InstallableProduct installableProduct) {
        List list = this.updateProductContainer.getUpdatedProductNames();
        EnumMap<UsageDataCollectorKey, Object> enumMap = new EnumMap<UsageDataCollectorKey, Object>(UsageDataCollectorKey.class);
        int n = installableProduct.getProductData().getProductNumber();
        String string = installableProduct.getProductData().getName();
        enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_NAME, (Object)string);
        enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_VERSION, (Object)installableProduct.getProductData().getVersion());
        enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_BASE_CODE, (Object)installableProduct.getProductData().getProductBaseCode());
        enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_BIT_CODE, (Object)n);
        enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_SELECTED, (Object)true);
        enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_DOWNLOADABLE, (Object)(installableProduct.getDownloadSize() != 0L ? 1 : 0));
        enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_INSTALLED, (Object)true);
        enumMap.put(UsageDataCollectorKey.PRODUCT_DATA_REINSTALLED, (Object)list.contains(string));
        this.usageDataCollector.addData(UsageDataCollectorKey.PRODUCT_DATA_ADD_PRODUCT_DATA, enumMap);
    }

    public void downloadProducts(String string, File file, InstallableProduct[] installableProductArray, InstallFlowControlHandler installFlowControlHandler, ComponentContainer componentContainer, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        this.allObservers = ProductInstallerImpl.combineObservers(this.installStatusObserver, installStatusObserverArray);
        this.installedComponents = ProductInstallerImpl.getLatestVersionOfInstalledComponentsByName(componentContainer);
        Set<ComponentData> set = ProductInstallerImpl.getComponentsOfProducts(ProductInstallerImpl.createProductNameSet(installableProductArray), string, this.theProductContainer);
        this.latestComponentsToBeInstalled = ProductInstallerImpl.getLatestVersionOfComponentsByName(set);
        long l = 0L;
        double d = 0.0;
        MultiThreadedDownloadPool multiThreadedDownloadPool = new MultiThreadedDownloadPool(this.appLogger, this.usageDataCollector);
        for (InstallableProduct installableProduct : installableProductArray) {
            Product product = installableProduct.getProductData();
            String string2 = ProductInstallerImpl.getProductNameAndVersion(product);
            InstallableComponent[] installableComponentArray = this.getComponentsToDownloadForProduct(string, installableProduct);
            ComponentSizeAggregator componentSizeAggregator = new ComponentSizeAggregator();
            for (InstallableComponent installableComponent : installableComponentArray) {
                componentSizeAggregator.add(installableComponent);
            }
            l += componentSizeAggregator.getTotalDownloadSize();
            if (componentSizeAggregator.getTotalDownloadSize() > 0L) {
                for (InstallableComponent installableComponent : this.allObservers) {
                    installableComponent.downloadingProduct(string2, componentSizeAggregator.getTotalDownloadSize());
                }
            }
            long l2 = System.currentTimeMillis();
            if (installableComponentArray.length > 0) {
                multiThreadedDownloadPool.downloadAndWait(file, installFlowControlHandler, Arrays.asList(installableComponentArray), componentSizeAggregator, string2, installStatusObserverArray);
            }
            long l3 = System.currentTimeMillis();
            d += (double)(l3 - l2) / 1000.0;
            installableProduct.writeOutXML(file);
        }
        multiThreadedDownloadPool.shutDownService();
        if (l > 0L) {
            this.usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_TOTAL_DOWNLOAD_TIME, (Object)((long)d));
            this.usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_TOTAL_DOWNLOAD_SIZE, (Object)l);
            for (InstallableProduct installableProduct : this.allObservers) {
                installableProduct.finishedDownloading(l);
            }
        }
    }

    private boolean secondDVDRequired() {
        return !this.productsOnSecondDvd.isEmpty();
    }

    private boolean checkIfRunningFromRightSplitDVDArea(String string, String string2) {
        File file = new File(string, string2);
        return file.isFile();
    }

    private void installProduct(String string, File file, File file2, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver[] installStatusObserverArray, Map<String, InstallableComponent> map, Map<String, ComponentData> map2, InstallableProduct installableProduct) throws InterruptedException, IOException {
        ProductInstallerImpl.updateObserversAndGetProductData(installableProduct, installStatusObserverArray);
        InstallableComponent[] installableComponentArray = this.getComponentsToInstallForProduct(file, installFlowControlHandler, installStatusObserverArray, map, map2, installableProduct, string);
        this.installComponents(file, file2, installFlowControlHandler, installStatusObserverArray, installableComponentArray, installableProduct);
    }

    private void installComponents(File file, File file2, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver[] installStatusObserverArray, InstallableComponent[] installableComponentArray, InstallableProduct installableProduct) throws IOException, InterruptedException {
        if (!this.isRunningFromDVD) {
            this.componentInstaller.installComponents(file, file2, installableComponentArray, installFlowControlHandler, installStatusObserverArray);
        } else {
            HashSet<InstallableComponent> hashSet = new HashSet<InstallableComponent>();
            HashSet<InstallableComponent> hashSet2 = new HashSet<InstallableComponent>();
            for (InstallableComponent installableComponent : installableComponentArray) {
                if (installableComponent.getLocationId() != 1) {
                    hashSet.add(installableComponent);
                    continue;
                }
                hashSet2.add(installableComponent);
            }
            if (!hashSet2.isEmpty()) {
                this.componentInstaller.installComponents(file, file2, hashSet2.toArray(new InstallableComponent[0]), installFlowControlHandler, installStatusObserverArray);
            }
            if (!hashSet.isEmpty()) {
                this.productsOnSecondDvd.put(installableProduct, hashSet);
            }
        }
    }

    private List<String> getUpdatableProductNames(InstallableProduct[] installableProductArray) {
        List list = this.updateProductContainer.getUpdatedProductNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (InstallableProduct installableProduct : installableProductArray) {
            arrayList.add(installableProduct.getProductData().getName());
        }
        list.retainAll(arrayList);
        return list;
    }

    public List<String> getUpdatableComponentNames(InstallableProduct[] installableProductArray) {
        List<String> list = this.getUpdatableProductNames(installableProductArray);
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (String string : list) {
            linkedHashSet.addAll(this.updateProductContainer.getUpdateComponentNames(string));
        }
        return new ArrayList<String>(linkedHashSet);
    }

    private InstallableComponent[] getComponentsToDownloadForProduct(String string, InstallableProduct installableProduct) throws InterruptedException, IOException {
        ComponentVisitor componentVisitor = new ComponentVisitor(){

            @Override
            public void visit(Collection<InstallableComponent> collection, InstallableComponent installableComponent, String string) {
                if (!ProductInstallerImpl.this.installedComponents.containsKey(string)) {
                    collection.add(installableComponent);
                }
            }
        };
        return this.getInstallableComponents(componentVisitor, installableProduct, string);
    }

    private InstallableComponent[] getComponentsToInstallForProduct(final File file, final InstallFlowControlHandler installFlowControlHandler, final InstallStatusObserver[] installStatusObserverArray, final Map<String, InstallableComponent> map, final Map<String, ComponentData> map2, InstallableProduct installableProduct, String string) throws InterruptedException, IOException {
        ComponentVisitor componentVisitor = new ComponentVisitor(){

            @Override
            public void visit(Collection<InstallableComponent> collection, InstallableComponent installableComponent, String string) throws IOException, InterruptedException {
                if (installableComponent != null) {
                    if (map.containsKey(string)) {
                        InstallableComponent installableComponent2 = (InstallableComponent)map.get(string);
                        if (installableComponent2.getComponentData().isOlderThan((ComponentData)map2.get(string))) {
                            ProductInstallerImpl.this.componentInstaller.uninstallComponents(file, new InstallableComponent[]{installableComponent2}, installFlowControlHandler, installStatusObserverArray);
                            collection.add(installableComponent);
                        }
                    } else {
                        collection.add(installableComponent);
                    }
                }
            }
        };
        return this.getInstallableComponents(componentVisitor, installableProduct, string);
    }

    private InstallableComponent[] getInstallableComponents(ComponentVisitor componentVisitor, InstallableProduct installableProduct, String string) throws IOException, InterruptedException {
        ArrayList<InstallableComponent> arrayList = new ArrayList<InstallableComponent>();
        for (ComponentData componentData : installableProduct.getRequiredComponents(string)) {
            String string2 = componentData.getName();
            if (!this.latestComponentsToBeInstalled.containsKey(string2)) continue;
            InstallableComponent installableComponent = this.productInstallerComponentContainer.getInstallableComponent(this.latestComponentsToBeInstalled.get(string2));
            componentVisitor.visit(arrayList, installableComponent, string2);
        }
        return arrayList.toArray(new InstallableComponent[0]);
    }

    private static Map<String, ComponentData> getLatestVersionOfComponentsByName(Collection<ComponentData> collection) {
        LinkedHashMap<String, ComponentData> linkedHashMap = new LinkedHashMap<String, ComponentData>();
        for (ComponentData componentData : collection) {
            String string = componentData.getName();
            if (linkedHashMap.containsKey(string) && !((ComponentData)linkedHashMap.get(string)).isOlderThan(componentData)) continue;
            linkedHashMap.put(string, componentData);
        }
        return linkedHashMap;
    }

    private static Map<String, InstallableComponent> getLatestVersionOfInstalledComponentsByName(ComponentContainer componentContainer) {
        InstallableComponent[] installableComponentArray;
        LinkedHashMap<String, InstallableComponent> linkedHashMap = new LinkedHashMap<String, InstallableComponent>();
        for (InstallableComponent installableComponent : installableComponentArray = componentContainer.getInstalledComponents()) {
            ComponentData componentData = installableComponent.getComponentData();
            String string = componentData.getName();
            if (linkedHashMap.containsKey(string) && !((InstallableComponent)linkedHashMap.get(string)).getComponentData().isOlderThan(componentData)) continue;
            linkedHashMap.put(installableComponent.getComponentData().getName(), installableComponent);
        }
        return linkedHashMap;
    }

    public long getInstallUnits(String string, File file, InstallableProduct[] installableProductArray, InstallableProduct[] installableProductArray2, InstallOption[] installOptionArray, ProductContainer productContainer, ComponentContainer componentContainer) {
        ComponentSizeAggregator componentSizeAggregator = new ComponentSizeAggregator();
        this.aggregateComponentsDuringInstall(string, file, installableProductArray, installableProductArray2, productContainer, componentContainer, componentSizeAggregator);
        return componentSizeAggregator.getTotalInstallUnits(this.statusFactor);
    }

    private static InstallStatusObserver[] combineObservers(InstallStatusObserver installStatusObserver, InstallStatusObserver ... installStatusObserverArray) {
        ArrayList<InstallStatusObserver> arrayList = new ArrayList<InstallStatusObserver>(Arrays.asList(installStatusObserverArray));
        arrayList.add(installStatusObserver);
        return arrayList.toArray(new InstallStatusObserver[0]);
    }

    private static Product updateObserversAndGetProductData(InstallableProduct installableProduct, InstallStatusObserver ... installStatusObserverArray) {
        Product product = installableProduct.getProductData();
        String string = ProductInstallerImpl.getProductName(product);
        ProductInstallerImpl.updateObservers(string, installStatusObserverArray);
        return product;
    }

    private static void updateObservers(String string, InstallStatusObserver ... installStatusObserverArray) {
        for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
            installStatusObserver.addProduct(string);
        }
    }

    private static Product updateObserversAndRemoveProductData(InstallableProduct installableProduct, InstallStatusObserver ... installStatusObserverArray) {
        Product product = installableProduct.getProductData();
        String string = ProductInstallerImpl.getProductName(product);
        for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
            installStatusObserver.removeProduct(string);
        }
        return product;
    }

    private static String getProductNameAndVersion(Product product) {
        return product.getName() + ' ' + product.getVersion();
    }

    private static String getProductName(Product product) {
        return product.getName();
    }

    public void uninstallProducts(String string, File file, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray, InstallFlowControlHandler installFlowControlHandler, ProductContainer productContainer, ComponentContainer componentContainer, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        InstallStatusObserver[] installStatusObserverArray2 = ProductInstallerImpl.combineObservers(this.installStatusObserver, installStatusObserverArray);
        Map<String, InstallableComponent> map = ProductInstallerImpl.getLatestVersionOfInstalledComponentsByName(componentContainer);
        LinkedHashSet<InstallableProduct> linkedHashSet = new LinkedHashSet<InstallableProduct>(Arrays.asList(productContainer.getInstallableProducts()));
        for (InstallableProduct installableProduct : installableProductArray) {
            Product product = ProductInstallerImpl.updateObserversAndRemoveProductData(installableProduct, installStatusObserverArray2);
            String string2 = product.getNameVersionReleaseAndReleaseDescription();
            ComponentData[] componentDataArray = ProductInstallerImpl.getNonSharedComponents(string2, string, linkedHashSet, productContainer);
            ArrayList<InstallableComponent> arrayList = new ArrayList<InstallableComponent>();
            for (ComponentData componentData : componentDataArray) {
                String string3 = componentData.getName();
                if (!map.containsKey(string3)) continue;
                arrayList.add(map.remove(string3));
            }
            ComponentData[] componentDataArray2 = arrayList.toArray(new InstallableComponent[0]);
            this.componentInstaller.uninstallComponents(file, (InstallableComponent[])componentDataArray2, installFlowControlHandler, installStatusObserverArray2);
            componentContainer.uninstallComponents((InstallableComponent[])componentDataArray2);
            InstallableProduct installableProduct2 = productContainer.getInstallableProductByNameVersionReleaseAndReleaseDescription(string2);
            if (installableProduct2 != null) {
                linkedHashSet.remove(installableProduct2);
            }
            this.fileList.removeProduct(ProductInstallerImpl.getProductNameAndVersion(product), file.getAbsolutePath());
        }
    }

    public long getUninstallUnits(String string, File file, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray, ProductContainer productContainer, ComponentContainer componentContainer) {
        Set<String> set = ProductInstallerImpl.createProductNameSet(installableProductArray);
        Set<ComponentData> set2 = ProductInstallerImpl.getComponentsOfProducts(set, string, productContainer);
        ProductInstallerImpl.removeComponentsAlsoInProductsNotBeingUninstalled(string, set, set2, productContainer);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (ComponentData componentData : set2) {
            linkedHashSet.add(componentData.getComponentNameAndVersion());
        }
        return this.fileList.getTotalFileCount(linkedHashSet.toArray(new String[0]), string) * this.statusFactor;
    }

    public void calculateSpaceRequired(String string, File file, InstallableProduct[] installableProductArray, InstallableProduct[] installableProductArray2, ProductContainer productContainer, ComponentContainer componentContainer, ComponentAggregator componentAggregator) {
        ProductInstallerImpl.aggregateComponentsDuringUninstall(string, installableProductArray2, productContainer, componentContainer, componentAggregator);
        this.aggregateComponentsDuringInstall(string, file, installableProductArray, installableProductArray2, productContainer, componentContainer, componentAggregator, this.theProductContainer);
    }

    private void aggregateComponentsDuringInstall(String string, File file, InstallableProduct[] installableProductArray, InstallableProduct[] installableProductArray2, ProductContainer productContainer, ComponentContainer componentContainer, ComponentAggregator componentAggregator, ProductContainer productContainer2) {
        LinkedHashSet<ComponentData> linkedHashSet = new LinkedHashSet<ComponentData>();
        for (InstallableComponent object2 : ProductInstallerImpl.getLatestVersionOfInstalledComponentsByName(componentContainer).values()) {
            linkedHashSet.add(object2.getComponentData());
        }
        Set<ComponentData> set = ProductInstallerImpl.getComponentsOfProducts(ProductInstallerImpl.createProductNameSet(installableProductArray), string, productContainer2);
        Map<String, ComponentData> map = ProductInstallerImpl.getLatestVersionOfComponentsByName((Collection<ComponentData>)set);
        Set<ComponentData> set2 = ProductInstallerImpl.getComponentsOfProducts(ProductInstallerImpl.createProductNameSet(installableProductArray2), string, productContainer);
        ProductInstallerImpl.removeComponentsAlsoInProductsNotBeingUninstalled(string, ProductInstallerImpl.createProductNameSet(installableProductArray2), set2, productContainer);
        LinkedHashMap<String, ComponentData> linkedHashMap = new LinkedHashMap<String, ComponentData>();
        for (ComponentData componentData : linkedHashSet) {
            if (set2.contains(componentData)) continue;
            linkedHashMap.put(componentData.getName(), componentData);
        }
        for (ComponentData componentData : map.values()) {
            InstallableComponent installableComponent = this.productInstallerComponentContainer.getInstallableComponent(componentData);
            if (installableComponent == null) continue;
            String string2 = componentData.getName();
            if (linkedHashMap.containsKey(string2)) {
                ComponentData componentData2 = (ComponentData)linkedHashMap.get(string2);
                if (!componentData2.isOlderThan(componentData)) continue;
                String[] stringArray = this.fileList.getNonSharedFiles(componentData2.getName(), file.getAbsolutePath());
                InstallableComponent installableComponent2 = componentContainer.getInstallableComponent(componentData2);
                componentAggregator.add(installableComponent);
                componentAggregator.remove(installableComponent2, (long)stringArray.length);
                continue;
            }
            componentAggregator.add(installableComponent);
        }
    }

    private void aggregateComponentsDuringInstall(String string, File file, InstallableProduct[] installableProductArray, InstallableProduct[] installableProductArray2, ProductContainer productContainer, ComponentContainer componentContainer, ComponentAggregator componentAggregator) {
        this.aggregateComponentsDuringInstall(string, file, installableProductArray, installableProductArray2, productContainer, componentContainer, componentAggregator, this.theProductContainer);
    }

    private static void aggregateComponentsDuringUninstall(String string, InstallableProduct[] installableProductArray, ProductContainer productContainer, ComponentContainer componentContainer, ComponentAggregator componentAggregator) {
        Set<String> set = ProductInstallerImpl.createProductNameSet(installableProductArray);
        Set<ComponentData> set2 = ProductInstallerImpl.getComponentsOfProducts(set, string, productContainer);
        ProductInstallerImpl.removeComponentsAlsoInProductsNotBeingUninstalled(string, set, set2, productContainer);
        for (ComponentData componentData : ProductInstallerImpl.getLatestVersionOfComponentsByName(set2).values()) {
            InstallableComponent installableComponent = componentContainer.getInstallableComponent(componentData);
            if (installableComponent == null) continue;
            componentAggregator.remove(installableComponent, 0L);
        }
    }

    private static Set<String> createProductNameSet(InstallableProduct[] installableProductArray) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (InstallableProduct installableProduct : installableProductArray) {
            linkedHashSet.add(installableProduct.getProductData().getNameVersionReleaseAndReleaseDescription());
        }
        return linkedHashSet;
    }

    private static void removeComponentsAlsoInProductsNotBeingUninstalled(String string, Collection<String> collection, Collection<ComponentData> collection2, ProductContainer productContainer) {
        for (InstallableProduct installableProduct : productContainer.getInstallableProducts()) {
            Product product = installableProduct.getProductData();
            if (collection.contains(product.getNameVersionReleaseAndReleaseDescription()) && string.equalsIgnoreCase(product.getArchitecture())) continue;
            ProductInstallerImpl.removeSharedComponents(collection2, installableProduct, string);
        }
    }

    private static Set<ComponentData> getComponentsOfProducts(Collection<String> collection, String string, ProductContainer productContainer) {
        LinkedHashSet<ComponentData> linkedHashSet = new LinkedHashSet<ComponentData>();
        for (String string2 : collection) {
            InstallableProduct installableProduct = productContainer.getInstallableProduct(string2, string);
            linkedHashSet.addAll(Arrays.asList(installableProduct.getRequiredComponents(string)));
        }
        return linkedHashSet;
    }

    private static void removeSharedComponents(Collection<ComponentData> collection, InstallableProduct installableProduct, String string) {
        ArrayList<ComponentData> arrayList = new ArrayList<ComponentData>();
        for (ComponentData componentData : collection) {
            if (!componentData.hasPlatform(installableProduct.getProductData().getArchitecture()) || !ProductInstallerImpl.otherProductContainsComponent(installableProduct, componentData, string)) continue;
            arrayList.add(componentData);
        }
        collection.removeAll(arrayList);
    }

    private static boolean otherProductContainsComponent(InstallableProduct installableProduct, ComponentData componentData, String string) {
        for (ComponentData componentData2 : installableProduct.getRequiredComponents(string)) {
            if (!componentData.getName().equalsIgnoreCase(componentData2.getName())) continue;
            return true;
        }
        return false;
    }

    private static ComponentData[] getNonSharedComponents(String string, String string2, Collection<InstallableProduct> collection, ProductContainer productContainer) {
        InstallableProduct installableProduct = productContainer.getInstallableProduct(string, string2);
        LinkedHashSet<ComponentData> linkedHashSet = new LinkedHashSet<ComponentData>(Arrays.asList(installableProduct.getRequiredComponents(string2)));
        for (InstallableProduct installableProduct2 : collection) {
            String string3 = installableProduct2.getProductData().getNameVersionReleaseAndReleaseDescription();
            if (string3.equalsIgnoreCase(string) && installableProduct2.getProductData().getArchitecture().equalsIgnoreCase(string2)) continue;
            ProductInstallerImpl.removeSharedComponents(linkedHashSet, installableProduct2, string2);
        }
        return linkedHashSet.toArray(new ComponentData[0]);
    }

    private static interface ComponentVisitor {
        public void visit(Collection<InstallableComponent> var1, InstallableComponent var2, String var3) throws IOException, InterruptedException;
    }
}

