/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.mathworks.install.CommandContainer;
import com.mathworks.install.ComponentAggregator;
import com.mathworks.install.ComponentContainer;
import com.mathworks.install.ComponentInstaller;
import com.mathworks.install.ContentOptimizer;
import com.mathworks.install.DefaultDirectoryProvider;
import com.mathworks.install.DownloaderBuilderFactory;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallConfigurationPersistence;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallOptionProvider;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.InstalledProductData;
import com.mathworks.install.InstalledProductDataFactory;
import com.mathworks.install.InstalledProductDataVersion;
import com.mathworks.install.InstallerBuilder;
import com.mathworks.install.InstallerDownloadInfoContainer;
import com.mathworks.install.InstallerFactory;
import com.mathworks.install.ProductContainer;
import com.mathworks.install.ProductCorrelator;
import com.mathworks.install.ProductDownloader;
import com.mathworks.install.ProductInstaller;
import com.mathworks.install.XMLParseStrategy;
import com.mathworks.install.XMLParserFactory;
import com.mathworks.install.archive.ArchiveFactory;
import com.mathworks.install.archive.ArchiveInputStreamExtractor;
import com.mathworks.install.command.Command;
import com.mathworks.install.input.InstallationInputFileFactory;
import com.mathworks.install.input.XMLInstallationFileParser;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.install.udc.NoOpUsageDataCollectorImpl;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install_impl.ComponentContainerImpl;
import com.mathworks.install_impl.ComponentInstallerImpl;
import com.mathworks.install_impl.ContentOptimizerImpl;
import com.mathworks.install_impl.DefaultDirectoryProviderNonWindows;
import com.mathworks.install_impl.DefaultDirectoryProviderWindows;
import com.mathworks.install_impl.DefaultProductCorrelatorImpl;
import com.mathworks.install_impl.DownloaderBuilderFactoryImpl;
import com.mathworks.install_impl.InstallCommonModule;
import com.mathworks.install_impl.InstallConfigurationAdapter;
import com.mathworks.install_impl.InstallConfigurationPersistenceImpl;
import com.mathworks.install_impl.InstalledProductDataFactoryImpl;
import com.mathworks.install_impl.InstalledProductDataImpl;
import com.mathworks.install_impl.InstalledProductDataVersionImpl;
import com.mathworks.install_impl.InstallerBuilderImpl;
import com.mathworks.install_impl.InstallerDownloadInfoContainerImpl;
import com.mathworks.install_impl.InstallerFactoryImpl;
import com.mathworks.install_impl.PreProductInstaller;
import com.mathworks.install_impl.ProductContainerImpl;
import com.mathworks.install_impl.ProductDownloaderImpl;
import com.mathworks.install_impl.ProductInstallerImpl;
import com.mathworks.install_impl.XMLInstallationFileParserImpl;
import com.mathworks.install_impl.XMLParseStrategyForInstall;
import com.mathworks.install_impl.XMLParserFactoryImpl;
import com.mathworks.install_impl.archive.zip.commonscompress.CommonsCompressModule;
import com.mathworks.install_impl.input.InputModule;
import com.mathworks.install_impl.status.InstallStatusObserverAdapter;
import com.mathworks.install_impl.status.LoggingInstallStatusObserver;
import com.mathworks.instutil.Downloader;
import com.mathworks.instutil.ExecutorServiceManager;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.MinimalProducts;
import com.mathworks.instutil.MinimalProductsImpl;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.Registry;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.webproxy.ProxyConfiguration;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public final class NextGenInstallModule
extends AbstractModule {
    public static final String LOGGING_STATUS_OBSERVER = "loggingStatusObserver";
    public static final String INSTALL_STATUS_OBSERVER = "installStatusObserver";
    public static final String UNINSTALL_STATUS_FACTOR = "uninstallStatusFactor";
    public static final String NO_DECODE_STREAM = "NoDecodeStream";
    public static final String RELEASE = "release";
    private static final String PRE_INSTALLER = "PreInstaller";
    private static final String POST_INSTALLER = "PostInstaller";
    private final Module archiveModule;
    private final InstallConfiguration installConfiguration;

    public NextGenInstallModule() {
        this(new InstallConfigurationAdapter());
    }

    public NextGenInstallModule(InstallConfiguration installConfiguration) {
        this(installConfiguration, (Module)new CommonsCompressModule());
    }

    private NextGenInstallModule(InstallConfiguration installConfiguration, Module module) {
        this.installConfiguration = installConfiguration;
        this.archiveModule = module;
    }

    @Provides
    static InstalledProductDataFactory provideInstalledProductDataFactory(XMLParserFactory xMLParserFactory, ExecutorServiceManager executorServiceManager, Platform platform, InstallConfiguration installConfiguration, IO iO, AppLogger appLogger) {
        return new InstalledProductDataFactoryImpl(xMLParserFactory, executorServiceManager.getMultiThreadedExecutorService(), platform, installConfiguration, iO, appLogger);
    }

    @Singleton
    @Provides
    static InstalledProductData provideInstalledProductData(ProductContainer productContainer, ComponentContainer componentContainer, XMLParserFactory xMLParserFactory, ExecutorServiceManager executorServiceManager, Platform platform, InstalledProductDataVersion installedProductDataVersion, IO iO, AppLogger appLogger) {
        return new InstalledProductDataImpl(productContainer, componentContainer, xMLParserFactory, executorServiceManager.getMultiThreadedExecutorService(), platform, installedProductDataVersion, iO, appLogger);
    }

    @Provides
    static DefaultDirectoryProvider provideDefaultDirectoryProvider(Platform platform, Registry registry, InstallConfiguration installConfiguration) {
        if (platform.isWindows()) {
            return new DefaultDirectoryProviderWindows(registry, installConfiguration, platform);
        }
        return new DefaultDirectoryProviderNonWindows(installConfiguration, platform);
    }

    @Provides
    static DownloaderBuilderFactory provideDownloaderBuilderFactory(Platform platform, ExecutorServiceManager executorServiceManager, AppLogger appLogger, Downloader downloader, ProxyConfiguration proxyConfiguration, ProductDownloader productDownloader, ArchiveFactory archiveFactory, IO iO, Properties properties, @Named(value="NoDecodeStream") ArchiveInputStreamExtractor archiveInputStreamExtractor, InstallerDownloadInfoContainer installerDownloadInfoContainer, @Named(value="release") String string) {
        return new DownloaderBuilderFactoryImpl(platform, executorServiceManager, appLogger, downloader, proxyConfiguration, archiveInputStreamExtractor, productDownloader, archiveFactory, iO, properties, installerDownloadInfoContainer, string);
    }

    @Provides
    @Singleton
    static InstallerBuilder provideInstallerBuilder(Platform platform, ProductContainer productContainer, InstallerFactory installerFactory, InstalledProductData installedProductData, ExecutorServiceManager executorServiceManager, InstallConfiguration installConfiguration, InstallationInputFileFactory installationInputFileFactory, AppLogger appLogger, XMLInstallationFileParser xMLInstallationFileParser) {
        return new InstallerBuilderImpl(platform.getArchString(), productContainer, installerFactory, installedProductData, executorServiceManager, installationInputFileFactory, appLogger, installConfiguration, xMLInstallationFileParser);
    }

    @Provides
    static InstallerFactory provideInstallerFactory(InstallOptionProvider installOptionProvider, @Named(value="PreInstaller") ProductInstaller productInstaller, ProductInstaller productInstaller2, InstalledProductData installedProductData, @Named(value="PostInstaller") ProductInstaller productInstaller3, InstalledProductDataFactory installedProductDataFactory, ProductContainer productContainer, IO iO, AppLogger appLogger, UsageDataCollector usageDataCollector, ProductCorrelator productCorrelator) {
        return new InstallerFactoryImpl(installOptionProvider, installedProductData, installedProductDataFactory, productContainer, iO, appLogger, usageDataCollector, productCorrelator, productInstaller, productInstaller2, productInstaller3);
    }

    @Provides
    @Named(value="PreInstaller")
    static ProductInstaller providePreInstaller(CommandContainer commandContainer) {
        return new PreProductInstaller(commandContainer);
    }

    @Provides
    @Named(value="PostInstaller")
    static ProductInstaller providePostInstaller(final CommandContainer commandContainer) {
        return new ProductInstaller(){

            public void installProducts(String string, File file, File file2, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray, InstallFlowControlHandler installFlowControlHandler, ComponentContainer componentContainer, InstallStatusObserver ... installStatusObserverArray) throws InterruptedException {
                for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                    installStatusObserver.postInstall();
                }
                for (InstallStatusObserver installStatusObserver : commandContainer.getPostInstallCommandsNextGen(installOptionArray, installableProductArray)) {
                    installFlowControlHandler.checkTaskState();
                    try {
                        installStatusObserver.execute(string, file, installFlowControlHandler);
                        this.update(installStatusObserverArray);
                    }
                    catch (IOException iOException) {
                        installFlowControlHandler.exception((Throwable)iOException);
                    }
                }
                installFlowControlHandler.checkTaskState();
            }

            public void updateProducts(InstallableProduct[] installableProductArray, ComponentContainer componentContainer, File file, File file2, InstallFlowControlHandler installFlowControlHandler, Platform platform, ProductContainer productContainer, InstallStatusObserver ... installStatusObserverArray) {
            }

            public void downloadProducts(String string, File file, InstallableProduct[] installableProductArray, InstallFlowControlHandler installFlowControlHandler, ComponentContainer componentContainer, InstallStatusObserver ... installStatusObserverArray) {
            }

            private void update(InstallStatusObserver[] installStatusObserverArray) {
                for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                    installStatusObserver.updateUnits(0x100000L);
                }
            }

            public long getInstallUnits(String string, File file, InstallableProduct[] installableProductArray, InstallableProduct[] installableProductArray2, InstallOption[] installOptionArray, ProductContainer productContainer, ComponentContainer componentContainer) {
                return (long)commandContainer.getPostInstallCommandsNextGen(installOptionArray, installableProductArray).length * 0x100000L;
            }

            public List<String> getUpdatableComponentNames(InstallableProduct[] installableProductArray) {
                return new ArrayList<String>();
            }

            public void uninstallProducts(String string, File file, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray, InstallFlowControlHandler installFlowControlHandler, ProductContainer productContainer, ComponentContainer componentContainer, InstallStatusObserver ... installStatusObserverArray) throws InterruptedException {
                Command[] commandArray;
                for (Command command : commandArray = commandContainer.getPostUninstallCommands(installOptionArray, installableProductArray)) {
                    installFlowControlHandler.checkTaskState();
                    try {
                        command.undo(string, file, installFlowControlHandler);
                        this.update(installStatusObserverArray);
                    }
                    catch (IOException iOException) {
                        installFlowControlHandler.exception((Throwable)iOException);
                    }
                }
                installFlowControlHandler.checkTaskState();
            }

            public long getUninstallUnits(String string, File file, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray, ProductContainer productContainer, ComponentContainer componentContainer) {
                int n = commandContainer.getPostUninstallCommands(installOptionArray, installableProductArray).length;
                long l = (long)n * 0x100000L;
                return l;
            }

            public void calculateSpaceRequired(String string, File file, InstallableProduct[] installableProductArray, InstallableProduct[] installableProductArray2, ProductContainer productContainer, ComponentContainer componentContainer, ComponentAggregator componentAggregator) {
            }
        };
    }

    @Provides
    @Singleton
    static MinimalProducts provideMinimalProductsImpl() {
        return new MinimalProductsImpl(new ArrayList());
    }

    @Provides
    @Named(value="release")
    public String provideRelease() {
        return InstutilResourceKeys.RELEASE.getBundleString();
    }

    protected void configure() {
        this.bind(ProductContainer.class).to(ProductContainerImpl.class).in(Scopes.SINGLETON);
        this.bind(ComponentContainer.class).to(ComponentContainerImpl.class).in(Scopes.SINGLETON);
        this.bind(ComponentInstaller.class).to(ComponentInstallerImpl.class);
        this.bind(XMLParserFactory.class).to(XMLParserFactoryImpl.class).in(Scopes.SINGLETON);
        this.bind(InstallStatusObserver.class).annotatedWith((Annotation)Names.named((String)LOGGING_STATUS_OBSERVER)).to(LoggingInstallStatusObserver.class);
        this.bind(InstallStatusObserver.class).annotatedWith((Annotation)Names.named((String)INSTALL_STATUS_OBSERVER)).to(InstallStatusObserverAdapter.class);
        this.bind(ProductInstaller.class).to(ProductInstallerImpl.class);
        this.bind(Long.class).annotatedWith((Annotation)Names.named((String)UNINSTALL_STATUS_FACTOR)).toInstance((Object)10000L);
        this.bind(InstallConfiguration.class).toInstance((Object)this.installConfiguration);
        this.bind(InstallConfigurationPersistence.class).to(InstallConfigurationPersistenceImpl.class);
        this.bind(InstalledProductDataVersion.class).to(InstalledProductDataVersionImpl.class);
        this.bind(XMLInstallationFileParser.class).to(XMLInstallationFileParserImpl.class);
        this.bind(ContentOptimizer.class).to(ContentOptimizerImpl.class);
        this.bind(ProductDownloader.class).to(ProductDownloaderImpl.class);
        this.bind(XMLParseStrategy.class).to(XMLParseStrategyForInstall.class);
        this.bind(InstallerDownloadInfoContainer.class).to(InstallerDownloadInfoContainerImpl.class);
        this.bind(UsageDataCollector.class).to(NoOpUsageDataCollectorImpl.class).in(Scopes.SINGLETON);
        this.bind(ProductCorrelator.class).to(DefaultProductCorrelatorImpl.class).in(Scopes.SINGLETON);
        this.install(this.archiveModule);
        this.install((Module)new InputModule());
        this.install((Module)new InstallCommonModule());
    }
}

