/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallableComponent;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.install_impl.ComponentDownloadCallable;
import com.mathworks.install_impl.ComponentSizeAggregator;
import com.mathworks.instutil.DaemonThreadFactory;
import com.mathworks.instutil.IOObserver;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class MultiThreadedDownloadPool {
    static final String MW_INSTALL_POOL_SIZE = "MW_INSTALL_POOL_SIZE";
    static final String THREAD_POOL_NAME = "QueuedDownloadThread";
    static final String DOWNLOAD_FAILURE_DDUX = "Failure during download: ";
    static final String USER_CANCEL_DDUX = "User cancel: ";
    static final int DEFAULT_POOL_SIZE = 4;
    static final int MAXIMUM_POOL_SIZE = 10;
    private final AppLogger appLogger;
    private final UsageDataCollector usageDataCollector;
    private final ExecutorService executorService;
    private final AtomicInteger timeoutCounter = new AtomicInteger();
    private int poolSize;

    MultiThreadedDownloadPool(AppLogger appLogger, UsageDataCollector usageDataCollector) {
        this.appLogger = appLogger;
        this.usageDataCollector = usageDataCollector;
        String string = System.getenv(MW_INSTALL_POOL_SIZE);
        if (string != null && !string.isEmpty()) {
            try {
                this.poolSize = Integer.parseInt(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.poolSize = 4;
            }
        } else {
            this.poolSize = 4;
        }
        if (this.poolSize < 0) {
            this.poolSize = 4;
        }
        this.poolSize = Math.min(this.poolSize, 10);
        appLogger.logMsg("Download thread pool size = " + this.poolSize);
        this.executorService = DaemonThreadFactory.getNewFixedThreadExecutor((int)this.poolSize, (String)THREAD_POOL_NAME);
        usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_THREAD_POOL_SIZE, (Object)this.poolSize);
    }

    int getPoolSize() {
        return this.poolSize;
    }

    List<Runnable> shutDownService() {
        return this.executorService.shutdownNow();
    }

    void downloadAndWait(File file, InstallFlowControlHandler installFlowControlHandler, Collection<InstallableComponent> collection, ComponentSizeAggregator componentSizeAggregator, String string, InstallStatusObserver[] installStatusObserverArray) throws InterruptedException, IOException {
        Object object;
        ArrayBlockingQueue<InstallableComponent> arrayBlockingQueue = new ArrayBlockingQueue<InstallableComponent>(collection.size());
        arrayBlockingQueue.addAll(collection);
        ArrayList<Object> arrayList = new ArrayList<Object>(this.poolSize);
        long l = componentSizeAggregator.getTotalDownloadSize();
        MTDIOObserverImpl mTDIOObserverImpl = new MTDIOObserverImpl(string, installStatusObserverArray, l, installFlowControlHandler);
        for (int i = 0; i < this.poolSize; ++i) {
            object = new ComponentDownloadCallable(arrayBlockingQueue, installStatusObserverArray, file, installFlowControlHandler, mTDIOObserverImpl, this.appLogger, this.timeoutCounter);
            arrayList.add(object);
        }
        try {
            List list = this.executorService.invokeAll(arrayList);
            object = new ArrayList();
            for (Future installableComponent : list) {
                object.addAll((Collection)installableComponent.get());
            }
            Iterator<Future<Object>> iterator = object.iterator();
            while (iterator.hasNext()) {
                InstallableComponent installableComponent = (InstallableComponent)iterator.next();
                installableComponent.downloadAndShowError(file, installFlowControlHandler, (IOObserver)mTDIOObserverImpl, installStatusObserverArray);
            }
        }
        catch (ExecutionException executionException) {
            object = executionException.getCause();
            String string2 = ((Throwable)object).getMessage();
            if (object instanceof InterruptedException) {
                this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_EXIT_REASON, (Object)(USER_CANCEL_DDUX + object));
                throw new InterruptedException(string2);
            }
            this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_EXIT_REASON, (Object)(DOWNLOAD_FAILURE_DDUX + object));
            throw new IOException(string2);
        }
        catch (Exception exception) {
            this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_EXIT_REASON, (Object)(DOWNLOAD_FAILURE_DDUX + exception.getMessage()));
            throw exception;
        }
        finally {
            this.usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_CONNECTION_TIMEOUTS, (Object)this.timeoutCounter.get());
        }
    }

    class MTDIOObserverImpl
    implements IOObserver {
        private String productNameVersion;
        private final InstallStatusObserver[] observers;
        private final long totalDownloadSize;
        private InstallFlowControlHandler flowControlHandler;

        MTDIOObserverImpl(String string, InstallStatusObserver[] installStatusObserverArray, long l, InstallFlowControlHandler installFlowControlHandler) {
            this.productNameVersion = string;
            this.observers = (InstallStatusObserver[])installStatusObserverArray.clone();
            this.flowControlHandler = installFlowControlHandler;
            this.totalDownloadSize = l;
        }

        public boolean updateBytes(long l) throws InterruptedException {
            for (InstallStatusObserver installStatusObserver : this.observers) {
                installStatusObserver.updateDownloadUnits(this.productNameVersion, l, this.totalDownloadSize);
            }
            return this.flowControlHandler.checkTaskState();
        }
    }
}

