/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallOptionProvider;
import com.mathworks.install_impl.InstallConfigurationAdapter;
import com.mathworks.install_impl.InstallOptionProviderImpl;
import com.mathworks.install_impl.NextGenInstallModule;
import com.mathworks.install_impl.archive.zip.commonscompress.CommonsCompressModule;
import com.mathworks.instutil.DefaultSecurityOverrideImpl;
import com.mathworks.instutil.Downloader;
import com.mathworks.instutil.DownloaderImpl;
import com.mathworks.instutil.ExecutorServiceManager;
import com.mathworks.instutil.ExecutorServiceManagerImpl;
import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.FilePermissionsUtil;
import com.mathworks.instutil.FolderUtils;
import com.mathworks.instutil.FolderUtilsImpl;
import com.mathworks.instutil.SecurityOverride;
import com.mathworks.instutil.URLConnectionFactory;
import com.mathworks.instutil.URLConnectionFactoryImpl;
import com.mathworks.instutil.logging.AppLogger;
import com.mathworks.instutil.logging.AppLoggerImpl;

public final class MATLABInstallerModule
extends AbstractModule {
    private static AppLoggerImpl appLogger = null;
    private final Module archiveModule;
    private final InstallConfiguration installConfiguration;

    public MATLABInstallerModule() {
        this(new InstallConfigurationAdapter());
    }

    public MATLABInstallerModule(InstallConfiguration installConfiguration) {
        this(installConfiguration, (Module)new CommonsCompressModule());
    }

    private MATLABInstallerModule(InstallConfiguration installConfiguration, Module module) {
        this.installConfiguration = installConfiguration;
        this.archiveModule = module;
    }

    @Provides
    static Downloader provideDownloader(URLConnectionFactory uRLConnectionFactory, FolderUtils folderUtils) {
        return new DownloaderImpl(uRLConnectionFactory, folderUtils);
    }

    @Provides
    static URLConnectionFactory provideURLConnectionFactory() {
        return new URLConnectionFactoryImpl();
    }

    protected void configure() {
        this.bind(ExecutorServiceManager.class).to(ExecutorServiceManagerImpl.class).in(Scopes.SINGLETON);
        this.bind(InstallOptionProvider.class).to(InstallOptionProviderImpl.class);
        this.bind(FilePermissions.class).to(FilePermissionsUtil.class);
        this.bind(SecurityOverride.class).toInstance((Object)new DefaultSecurityOverrideImpl());
        this.bind(FolderUtils.class).toInstance((Object)new FolderUtilsImpl());
        this.bind(InstallConfiguration.class).toInstance((Object)this.installConfiguration);
        this.install((Module)new NextGenInstallModule(this.installConfiguration));
    }

    @Provides
    static AppLogger providesAppLogger() {
        if (appLogger == null) {
            appLogger = new AppLoggerImpl();
        }
        return appLogger;
    }
}

