/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl;

import com.google.inject.Inject;
import com.mathworks.install.AvailableProduct;
import com.mathworks.install.ComponentAggregator;
import com.mathworks.install.ComponentContainer;
import com.mathworks.install.ComponentData;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallOptionProvider;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.InstalledProductData;
import com.mathworks.install.InstalledProductDataFactory;
import com.mathworks.install.Installer;
import com.mathworks.install.InvalidInstallationFolderException;
import com.mathworks.install.Product;
import com.mathworks.install.ProductContainer;
import com.mathworks.install.ProductCorrelator;
import com.mathworks.install.ProductInstaller;
import com.mathworks.install.resources.InstallResourceKeys;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.install.udc.UdcUtil;
import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.install_impl.AbstractSoftwareManager;
import com.mathworks.install_impl.AvailableProductImpl;
import com.mathworks.install_impl.ComponentContainerImpl;
import com.mathworks.install_impl.ComponentSizeAggregator;
import com.mathworks.install_impl.InstallableProductComparator;
import com.mathworks.install_impl.ProductComparator;
import com.mathworks.install_impl.ProductContainerImpl;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.VersionUtils;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class InstallerImpl
extends AbstractSoftwareManager
implements Installer {
    private static final String WIN32 = "win32";
    private static final String WIN64 = "win64";
    private static final int LICENSE_MANAGER = 0;
    private static final int POLYSPACE = 164;
    private static final int POLYSPACE_SERVER = 167;
    private static final String LOCKED_FILES_LOG = "LockedFiles";
    private final String arch;
    private final IO io;
    private final AppLogger appLogger;
    private final UsageDataCollector usageDataCollector;
    private final ProductCorrelator productCorrelator;
    private final Map<AvailableProduct, InstallableProduct> availableProductMap = new LinkedHashMap<AvailableProduct, InstallableProduct>();
    private final Map<File, ProductContainer> productContainerMap = new HashMap<File, ProductContainer>();
    private final Map<File, ComponentContainer> componentContainerMap = new HashMap<File, ComponentContainer>();
    private final ProductInstaller[] productInstallers;
    private final InstallOptionProvider installOptionProvider;
    private final InstalledProductData fileList;
    private final InstalledProductDataFactory fileListFactory;
    private final ProductContainer theProductContainer;
    private InstallOption[] installOptions;
    private final Collection<InstallableProduct> nonCustomerFacingProducts = new ArrayList<InstallableProduct>();
    private boolean showMinimalProductNote;

    @Inject
    public InstallerImpl(String string, InstallableProduct[] installableProductArray, InstallOptionProvider installOptionProvider, InstalledProductData installedProductData, InstalledProductDataFactory installedProductDataFactory, ProductContainer productContainer, IO iO, AppLogger appLogger, UsageDataCollector usageDataCollector, ProductCorrelator productCorrelator, ProductInstaller ... productInstallerArray) {
        this.arch = string;
        InstallableProduct[] installableProductArray2 = (InstallableProduct[])installableProductArray.clone();
        this.installOptionProvider = installOptionProvider;
        this.fileList = installedProductData;
        this.fileListFactory = installedProductDataFactory;
        this.theProductContainer = productContainer;
        this.io = iO;
        this.appLogger = appLogger;
        this.usageDataCollector = usageDataCollector;
        this.productCorrelator = productCorrelator;
        for (InstallableProduct installableProduct : installableProductArray2) {
            this.addProduct(installableProduct.getProductData());
        }
        this.productInstallers = (ProductInstaller[])productInstallerArray.clone();
        this.installOptions = this.getInstallOptionsForCurrentProductSelection(new Product[0]);
    }

    public void addProduct(Product product) {
        InstallableProduct installableProduct = this.theProductContainer.getInstallableProduct(product);
        if (this.productCorrelator.shouldAddProduct(installableProduct.getProductData())) {
            if (installableProduct.isCustomerFacing()) {
                this.availableProductMap.put(new AvailableProductImpl(installableProduct), installableProduct);
            } else {
                this.nonCustomerFacingProducts.add(installableProduct);
            }
        } else {
            this.appLogger.logMsg("Found unsupported release family " + installableProduct.getReleaseFamily() + " or description " + installableProduct.getReleaseDescription() + " for product: " + installableProduct.getProductData().getNameVersionReleaseAndReleaseDescription());
        }
    }

    public void install(File file, File file2, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        this.usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_INSTALLATION_SUCCESSFUL, (Object)false);
        long l = System.currentTimeMillis();
        InstallableProduct[] installableProductArray = this.getAllProductsToBeOverwritten(file);
        this.uninstallProducts(file, installFlowControlHandler, installableProductArray, this.getOptionsToBeUninstalled(file), installStatusObserverArray);
        InstallableProduct[] installableProductArray2 = this.getAllProductsToBeInstalled();
        for (ProductInstaller productInstaller : this.productInstallers) {
            productInstaller.installProducts(this.arch, file, file2, installableProductArray2, this.installOptions, installFlowControlHandler, this.getComponentContainer(file), installStatusObserverArray);
        }
        this.fileList.writeContentsData(file, (Product[])this.getAvailableProducts());
        this.fileList.writeInstalledProductData(file, installableProductArray2);
        long l2 = System.currentTimeMillis();
        UdcUtil.collectInstallTime((UsageDataCollector)this.usageDataCollector, (long)l, (long)l2);
        this.usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_INSTALLATION_SUCCESSFUL, (Object)true);
        for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
            installStatusObserver.finished();
        }
    }

    public void update(File file, File file2, InstallFlowControlHandler installFlowControlHandler, Platform platform, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        ArrayList arrayList = new ArrayList();
        InstallableProduct[] installableProductArray = this.getAllInstalledProductsForUpdate(file);
        for (ProductInstaller productInstaller : this.productInstallers) {
            productInstaller.updateProducts(installableProductArray, this.getComponentContainer(file), file, file2, installFlowControlHandler, platform, this.getInstalledProductContainer(file), installStatusObserverArray);
            List list = productInstaller.getUpdatableComponentNames(installableProductArray);
            if (list.isEmpty()) continue;
            arrayList.addAll(list);
        }
        if (arrayList != null) {
            this.fileList.updateContentsData(file, arrayList);
            this.fileList.writeInstalledProductData(file, installableProductArray);
            this.fileList.writeLockedFilesPath(new File(file2, LOCKED_FILES_LOG));
        }
        for (ProductInstaller productInstaller : installStatusObserverArray) {
            productInstaller.finished();
        }
    }

    public void download(File file, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        InstallableProduct[] installableProductArray = this.getAllProductsToBeInstalled();
        for (ProductInstaller productInstaller : this.productInstallers) {
            productInstaller.downloadProducts(this.arch, file, installableProductArray, installFlowControlHandler, this.getComponentContainer(file), installStatusObserverArray);
        }
        for (ProductInstaller productInstaller : installStatusObserverArray) {
            productInstaller.finished();
        }
    }

    private void uninstallProducts(File file, InstallFlowControlHandler installFlowControlHandler, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        if (InstallerImpl.productsToBeUninstalled(installableProductArray)) {
            for (ProductInstaller productInstaller : this.productInstallers) {
                productInstaller.uninstallProducts(this.arch, file, installableProductArray, installOptionArray, installFlowControlHandler, this.getInstalledProductContainer(file), this.getComponentContainer(file), installStatusObserverArray);
            }
            this.fileList.writeContentsData(file, (Product[])this.getAvailableProducts());
            this.fileList.clearInstalledProductData(file, installableProductArray);
        }
    }

    public void uninstall(File file, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        List<InstallableProduct> list = Arrays.asList(this.getSelectedCustomerFacingProducts());
        Collections.reverse(list);
        this.uninstallProducts(file, installFlowControlHandler, list.toArray(new InstallableProduct[0]), this.installOptions, installStatusObserverArray);
        for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
            installStatusObserver.finished();
        }
    }

    public Product[] getDependencies() {
        HashSet<Product> hashSet = new HashSet<Product>();
        for (InstallableProduct installableProduct : this.getSelectedCustomerFacingProducts()) {
            hashSet.addAll(Arrays.asList(installableProduct.getRequiredProducts()));
        }
        return hashSet.toArray(new Product[0]);
    }

    public Product[] getDependencySatisfiers(File file) {
        HashSet<Product> hashSet = new HashSet<Product>();
        Product[] productArray = InstallerImpl.getProducts(this.getInstalledCustomerFacingProducts(file));
        hashSet.addAll(Arrays.asList(this.filterOutProductsFromOtherReleases(productArray)));
        hashSet.addAll(Arrays.asList(InstallerImpl.getProducts(this.getSelectedCustomerFacingProducts())));
        return hashSet.toArray(new Product[0]);
    }

    public boolean canSelectIfAlreadyDownloaded() {
        return true;
    }

    public Map<InstallableProduct, List<ComponentData>> getInstructionSetComponents(List<String> list) {
        return InstallerImpl.getInstructionSetComponentsByInstallableProduct(this.toInstallableProducts(this.getSelectedAvailableProducts()), new String[]{this.arch}, list);
    }

    private Product[] filterOutProductsFromOtherReleases(Product[] productArray) {
        ArrayList<Product> arrayList = new ArrayList<Product>();
        for (Product product : productArray) {
            if (!this.productCorrelator.shouldAddProduct(product)) continue;
            arrayList.add(product);
        }
        return arrayList.toArray(new Product[0]);
    }

    public Product[] getProductsThatDependOnProductsToBeUninstalled(File file) {
        HashSet<Product> hashSet = new HashSet<Product>();
        InstallableProduct[] installableProductArray = this.getInstalledCustomerFacingProducts(file);
        Map<Product, InstallableProduct> map = InstallerImpl.getProductToInstallableProductMap(installableProductArray);
        List<InstallableProduct> list = Arrays.asList(this.getCustomerFacingProductsToBeRemoved(file));
        for (InstallableProduct installableProduct : installableProductArray) {
            if (list.contains(installableProduct)) continue;
            for (Product product : installableProduct.getRequiredProducts()) {
                if (!list.contains(map.get(product))) continue;
                hashSet.add(installableProduct.getProductData());
            }
        }
        InstallableProduct[] installableProductArray2 = hashSet.toArray(new Product[0]);
        Arrays.sort(installableProductArray2, new ProductComparator());
        return installableProductArray2;
    }

    public long getBytesRequired(File file) {
        if (this.getSelectedAvailableProducts().length == 0) {
            return 0L;
        }
        ComponentSizeAggregator componentSizeAggregator = this.calculateSpaceRequired(this.getAllProductsToBeInstalled(), file);
        return componentSizeAggregator.getTotalSize();
    }

    private ComponentSizeAggregator calculateSpaceRequired(InstallableProduct[] installableProductArray, File file) {
        ComponentSizeAggregator componentSizeAggregator = new ComponentSizeAggregator();
        InstallableProduct[] installableProductArray2 = this.getAllProductsToBeOverwritten(file);
        for (ProductInstaller productInstaller : this.productInstallers) {
            productInstaller.calculateSpaceRequired(this.arch, file, installableProductArray, installableProductArray2, this.getInstalledProductContainer(file), this.getComponentContainer(file), (ComponentAggregator)componentSizeAggregator);
        }
        return componentSizeAggregator;
    }

    public long getDownloadSize(File file) {
        if (this.getSelectedAvailableProducts().length == 0) {
            return 0L;
        }
        return this.calculateSpaceRequired(this.getAllProductsToBeInstalled(), file).getTotalDownloadSize();
    }

    public long getUninstallTotalUnits(File file) {
        return this.getUninstallTotalUnits(file, this.getCustomerFacingProductsToBeRemoved(file), this.installOptions);
    }

    private long getUninstallTotalUnits(File file, InstallableProduct[] installableProductArray, InstallOption[] installOptionArray) {
        long l = 0L;
        if (InstallerImpl.productsToBeUninstalled(installableProductArray)) {
            for (ProductInstaller productInstaller : this.productInstallers) {
                l += productInstaller.getUninstallUnits(this.arch, file, installableProductArray, installOptionArray, this.getInstalledProductContainer(file), this.getComponentContainer(file));
            }
        }
        return l;
    }

    private static boolean productsToBeUninstalled(InstallableProduct[] installableProductArray) {
        return installableProductArray.length > 0;
    }

    public long getInstallTotalUnits(File file) {
        long l = 0L;
        InstallableProduct[] installableProductArray = this.getAllProductsToBeInstalled();
        InstallableProduct[] installableProductArray2 = this.getAllProductsToBeOverwritten(file);
        for (ProductInstaller productInstaller : this.productInstallers) {
            l += productInstaller.getInstallUnits(this.arch, file, installableProductArray, installableProductArray2, this.installOptions, this.getInstalledProductContainer(file), this.getComponentContainer(file));
        }
        return l + this.getUninstallTotalUnits(file, installableProductArray2, this.getOptionsToBeUninstalled(file));
    }

    private InstallOption[] getOptionsToBeUninstalled(File file) {
        return this.installOptionProvider.getUninstallOptions(InstallerImpl.getProducts(this.getCustomerFacingProductsToBeRemoved(file)));
    }

    public InstallOption getDefaultPreferencesOption() {
        return this.installOptionProvider.getDefaultPreferencesOption();
    }

    public void setUninstallOptions(InstallOption ... installOptionArray) {
        ArrayList<Product> arrayList = new ArrayList<Product>();
        ArrayList<InstallOption> arrayList2 = new ArrayList<InstallOption>();
        arrayList.addAll(Arrays.asList(InstallerImpl.getProducts(this.getSelectedCustomerFacingProducts())));
        arrayList2.addAll(Arrays.asList(this.installOptionProvider.getUninstallOptions(arrayList.toArray(new Product[0]))));
        for (InstallOption installOption : installOptionArray) {
            if (!this.isAnyControllingProductSelected() || !installOption.isSelected()) continue;
            arrayList2.add(installOption);
        }
        this.installOptions = arrayList2.toArray(new InstallOption[0]);
    }

    public AvailableProduct[] getAvailableProducts() {
        AvailableProduct[] availableProductArray = this.availableProductMap.keySet().toArray(new AvailableProduct[0]);
        Arrays.sort(availableProductArray, new ProductComparator());
        return availableProductArray;
    }

    private synchronized ProductContainer getInstalledProductContainer(File file) {
        if (this.productContainerMap.containsKey(file)) {
            return this.productContainerMap.get(file);
        }
        this.populateContainers(file);
        return this.productContainerMap.get(file);
    }

    private synchronized ComponentContainer getComponentContainer(File file) {
        if (this.componentContainerMap.containsKey(file)) {
            return this.componentContainerMap.get(file);
        }
        this.populateContainers(file);
        return this.componentContainerMap.get(file);
    }

    private synchronized void populateContainers(File file) {
        ComponentContainerImpl componentContainerImpl = new ComponentContainerImpl();
        ProductContainerImpl productContainerImpl = new ProductContainerImpl(componentContainerImpl);
        try {
            this.fileListFactory.createInstalledProductData(file, (ProductContainer)productContainerImpl, (ComponentContainer)componentContainerImpl);
        }
        catch (Exception exception) {
            componentContainerImpl = new ComponentContainerImpl();
            productContainerImpl = new ProductContainerImpl(componentContainerImpl);
        }
        this.componentContainerMap.put(file, componentContainerImpl);
        this.productContainerMap.put(file, productContainerImpl);
    }

    public void checkIfOverwritePossible(File file) throws InvalidInstallationFolderException {
        File file2 = new File(new File(file, "bin"), this.arch);
        if (this.appdataExists(file)) {
            this.validateFileList(file);
            if (this.fileListEmptyForThisArchitecture(file)) {
                this.checkWin32OnWin64(file);
                this.checkWin64OnWin32(file);
            }
        } else if (this.io.isDirectory(file2)) {
            throw new InvalidInstallationFolderException(InstallResourceKeys.ERROR_NO_FILE_LIST.getString(new Object[0]));
        }
    }

    private void validateFileList(File file) throws InvalidInstallationFolderException {
        this.fileListFactory.createInstalledProductDataVersion().validate(file, (Product[])this.getAvailableProducts());
    }

    private boolean appdataExists(File file) {
        return this.io.isDirectory(new File(file, "appdata"));
    }

    private void checkWin64OnWin32(File file) throws InvalidInstallationFolderException {
        if (this.arch.equalsIgnoreCase(WIN64) && this.getAllInstalledProducts(file, WIN32).length > 0) {
            throw new InvalidInstallationFolderException(InstallResourceKeys.ERROR_WIN64_ON_WIN32.getString(new Object[0]));
        }
    }

    private void checkWin32OnWin64(File file) throws InvalidInstallationFolderException {
        if (this.arch.equalsIgnoreCase(WIN32) && this.getAllInstalledProducts(file, WIN64).length > 0) {
            throw new InvalidInstallationFolderException(InstallResourceKeys.ERROR_WIN32_ON_WIN64.getString(new Object[0]));
        }
    }

    private boolean fileListEmptyForThisArchitecture(File file) {
        return this.getAllInstalledProducts(file).length == 0;
    }

    public AvailableProduct[] getSelectedProductsAlreadyInstalled(File file) {
        ArrayList<AvailableProduct> arrayList = new ArrayList<AvailableProduct>();
        for (InstallableProduct installableProduct : this.getInstalledCustomerFacingProducts(file)) {
            for (AvailableProduct availableProduct : this.getSelectedAvailableProducts()) {
                if (!this.productsEquivalentForOperation(installableProduct, this.availableProductMap.get(availableProduct))) continue;
                arrayList.add(availableProduct);
            }
        }
        return arrayList.toArray(new AvailableProduct[0]);
    }

    public AvailableProduct[] getAvailableProductsAlreadyInstalled(File file) {
        ArrayList<AvailableProduct> arrayList = new ArrayList<AvailableProduct>();
        for (InstallableProduct installableProduct : this.getInstalledCustomerFacingProducts(file)) {
            for (AvailableProduct availableProduct : this.getAvailableProducts()) {
                InstallableProduct installableProduct2 = this.availableProductMap.get(availableProduct);
                Product product = installableProduct.getProductData();
                Product product2 = installableProduct2.getProductData();
                if (product2.getProductNumber() != product.getProductNumber() || VersionUtils.compareVersionNumbers((String)product2.getVersion(), (String)product.getVersion()) != 0) continue;
                arrayList.add(availableProduct);
            }
        }
        return arrayList.toArray(new AvailableProduct[0]);
    }

    private InstallableProduct[] getCustomerFacingProductsToBeRemoved(File file) {
        if (this.getIncompatibleProducts(file).length > 0) {
            return this.getInstalledCustomerFacingProducts(file);
        }
        ArrayList<InstallableProduct> arrayList = new ArrayList<InstallableProduct>();
        for (InstallableProduct installableProduct : this.getInstalledCustomerFacingProducts(file)) {
            for (AvailableProduct availableProduct : this.getSelectedAvailableProducts()) {
                if (!this.productsEquivalentForOperation(installableProduct, this.availableProductMap.get(availableProduct))) continue;
                arrayList.add(installableProduct);
            }
        }
        return arrayList.toArray(new InstallableProduct[0]);
    }

    private InstallableProduct[] getAllProductsToBeOverwritten(File file) {
        if (this.getIncompatibleProducts(file).length > 0) {
            return this.getAllInstalledProducts(file);
        }
        ArrayList<InstallableProduct> arrayList = new ArrayList<InstallableProduct>();
        for (InstallableProduct installableProduct : this.getAllInstalledProducts(file)) {
            for (InstallableProduct installableProduct2 : this.getAllProductsToBeInstalled()) {
                if (!this.productsEquivalentForOperation(installableProduct, installableProduct2)) continue;
                arrayList.add(installableProduct);
            }
        }
        return arrayList.toArray(new InstallableProduct[0]);
    }

    private boolean productsEquivalentForOperation(InstallableProduct installableProduct, InstallableProduct installableProduct2) {
        boolean bl = false;
        if (this.productCorrelator.isSameFamilyAndType(installableProduct, installableProduct2)) {
            Product product = installableProduct.getProductData();
            Product product2 = installableProduct2.getProductData();
            if (product2.getProductNumber() == product.getProductNumber() && (VersionUtils.compareVersionNumbers((String)product2.getVersion(), (String)product.getVersion()) != 0 || product2.getArchitecture().equalsIgnoreCase(product.getArchitecture()))) {
                bl = true;
            }
        }
        return bl;
    }

    private InstallableProduct[] toInstallableProducts(AvailableProduct[] availableProductArray) {
        ArrayList<InstallableProduct> arrayList = new ArrayList<InstallableProduct>();
        for (AvailableProduct availableProduct : availableProductArray) {
            arrayList.add(this.availableProductMap.get(availableProduct));
        }
        return arrayList.toArray(new InstallableProduct[0]);
    }

    public AvailableProduct[] getIncompatibleProducts(File file) {
        ArrayList<AvailableProduct> arrayList = new ArrayList<AvailableProduct>();
        AvailableProduct[] availableProductArray = this.getSelectedAvailableProducts();
        InstallableProduct[] installableProductArray = this.getAllInstalledProducts(file);
        for (AvailableProduct availableProduct : availableProductArray) {
            InstallableProduct installableProduct = this.availableProductMap.get(availableProduct);
            if (!installableProduct.getProductData().isControlling()) continue;
            for (InstallableProduct installableProduct2 : installableProductArray) {
                if (this.productCorrelator.isSameFamilyAndType(installableProduct, installableProduct2)) continue;
                arrayList.add(availableProduct);
            }
        }
        return arrayList.toArray(new AvailableProduct[0]);
    }

    public boolean folderContainsNewerVersion(AvailableProduct availableProduct, File file) {
        for (InstallableProduct installableProduct : this.getAllInstalledProducts(file)) {
            Product product = installableProduct.getProductData();
            Product product2 = this.availableProductMap.get(availableProduct).getProductData();
            if (product.getProductNumber() != product2.getProductNumber() || VersionUtils.compareVersionNumbers((String)product.getVersion(), (String)product2.getVersion()) <= 0) continue;
            return true;
        }
        return false;
    }

    private InstallableProduct[] getInstalledCustomerFacingProducts(File file) {
        ArrayList<InstallableProduct> arrayList = new ArrayList<InstallableProduct>();
        for (InstallableProduct installableProduct : this.getAllInstalledProducts(file)) {
            if (!installableProduct.isCustomerFacing()) continue;
            arrayList.add(installableProduct);
        }
        return arrayList.toArray(new InstallableProduct[0]);
    }

    private InstallableProduct[] getAllInstalledProducts(File file) {
        InstallableProduct[] installableProductArray = this.getInstalledProductContainer(file).getInstallableProducts(this.arch);
        Arrays.sort(installableProductArray, new InstallableProductComparator());
        return installableProductArray;
    }

    public InstallableProduct[] getAllInstalledProductsForUpdate(File file) {
        InstallableProduct[] installableProductArray = this.getInstalledProductContainer(file).getInstallableProducts(this.arch);
        Arrays.sort(installableProductArray, new InstallableProductComparator());
        ArrayList<InstallableProduct> arrayList = new ArrayList<InstallableProduct>();
        for (InstallableProduct installableProduct : installableProductArray) {
            if (installableProduct.getProductData().getProductNumber() <= 0) continue;
            arrayList.add(installableProduct);
        }
        return arrayList.toArray(new InstallableProduct[0]);
    }

    private InstallableProduct[] getAllInstalledProducts(File file, String string) {
        InstallableProduct[] installableProductArray = this.getInstalledProductContainer(file).getInstallableProducts(string);
        Arrays.sort(installableProductArray, new InstallableProductComparator());
        return installableProductArray;
    }

    public InstallOption[] getInstallOptionsForCurrentProductSelection(Product ... productArray) {
        ArrayList<Product> arrayList = new ArrayList<Product>();
        arrayList.addAll(Arrays.asList(productArray));
        arrayList.addAll(Arrays.asList(InstallerImpl.getProducts(this.getSelectedCustomerFacingProducts())));
        return this.getInstallOptions(arrayList.toArray(new Product[0]));
    }

    public InstallOption[] getInstallOptionsForCurrentProductSelectionForProfessionalInstaller(String string, Product ... productArray) {
        ArrayList<InstallOption> arrayList = new ArrayList<InstallOption>();
        arrayList.addAll(Arrays.asList(this.getInstallOptionsForCurrentProductSelection(productArray)));
        arrayList.add(this.installOptionProvider.getJITLicenseOption(string));
        return arrayList.toArray(new InstallOption[0]);
    }

    private static Product[] getProducts(InstallableProduct[] installableProductArray) {
        ArrayList<Product> arrayList = new ArrayList<Product>();
        for (InstallableProduct installableProduct : installableProductArray) {
            arrayList.add(installableProduct.getProductData());
        }
        return arrayList.toArray(new Product[0]);
    }

    private InstallOption[] getInstallOptions(Product[] productArray) {
        return this.installOptionProvider.getDefaultInstallOptions(productArray);
    }

    public boolean isAnyControllingProductSelected() {
        for (InstallableProduct installableProduct : this.getSelectedCustomerFacingProducts()) {
            if (!installableProduct.getProductData().isControlling()) continue;
            return true;
        }
        return false;
    }

    public boolean isPolyspaceInstallation() {
        for (AvailableProduct availableProduct : this.getAvailableProducts()) {
            if (availableProduct.getProductNumber() < 164 || availableProduct.getProductNumber() > 167) continue;
            return true;
        }
        return false;
    }

    private boolean isLicenseManagerSelected() {
        for (InstallableProduct installableProduct : this.getSelectedCustomerFacingProducts()) {
            if (installableProduct.getProductData().getProductNumber() != 0) continue;
            return true;
        }
        return false;
    }

    public void setInstallOptions(InstallOption[] installOptionArray) {
        this.installOptions = (InstallOption[])installOptionArray.clone();
    }

    public InstallOption[] getInstallOptions() {
        return this.installOptions;
    }

    private InstallableProduct[] getAllProductsToBeInstalled() {
        ArrayList<InstallableProduct> arrayList = new ArrayList<InstallableProduct>();
        arrayList.addAll(Arrays.asList(this.getSelectedCustomerFacingProducts()));
        if (this.isAnyControllingProductSelected() || this.isLicenseManagerSelected()) {
            arrayList.addAll(this.nonCustomerFacingProducts);
        }
        return arrayList.toArray(new InstallableProduct[0]);
    }

    private InstallableProduct[] getSelectedCustomerFacingProducts() {
        return this.toInstallableProducts(this.getSelectedAvailableProducts());
    }

    public AvailableProduct[] getSelectedAvailableProducts() {
        ArrayList<AvailableProduct> arrayList = new ArrayList<AvailableProduct>();
        for (AvailableProduct availableProduct : this.getAvailableProducts()) {
            if (!availableProduct.canInstall()) continue;
            arrayList.add(availableProduct);
        }
        return arrayList.toArray(new AvailableProduct[0]);
    }

    private static Map<Product, InstallableProduct> getProductToInstallableProductMap(InstallableProduct[] installableProductArray) {
        HashMap<Product, InstallableProduct> hashMap = new HashMap<Product, InstallableProduct>();
        for (InstallableProduct installableProduct : installableProductArray) {
            hashMap.put(installableProduct.getProductData(), installableProduct);
        }
        return hashMap;
    }

    public boolean canActivate(InstallConfiguration installConfiguration) {
        for (InstallableProduct installableProduct : this.getAllProductsToBeInstalled()) {
            if (!installableProduct.canActivate(installConfiguration)) continue;
            return true;
        }
        return false;
    }

    public void setShowMinimalProductNote(boolean bl) {
        this.showMinimalProductNote = bl;
    }

    public boolean getShowMinimalProductNote() {
        return this.showMinimalProductNote;
    }

    public boolean isAllInstallableProductsSelected() {
        AvailableProduct[] availableProductArray;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        boolean bl = true;
        for (AvailableProduct availableProduct : availableProductArray = this.getAvailableProducts()) {
            if (!(availableProduct.isSelected() || availableProduct.isInstalled() || hashSet.contains(availableProduct.getProductNumber()))) {
                bl = false;
                break;
            }
            hashSet.add(availableProduct.getProductNumber());
        }
        return bl;
    }
}

