/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl;

import com.google.inject.Inject;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstalledProductDataVersion;
import com.mathworks.install.InvalidInstallationFolderException;
import com.mathworks.install.Product;
import com.mathworks.install.resources.InstallResourceKeys;
import com.mathworks.instutil.InstutilResourceKeys;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public final class InstalledProductDataVersionImpl
implements InstalledProductDataVersion {
    private static final String VERSION = "4.0";
    private static final String XML_FILE_NAME = "version.xml";
    private static final String ROOT_TAG = "installedProductData";
    private static final String VERSION_TAG = "version";
    private static final String USAGE_TAG = "usage";
    private static final String USAGE_ID = "id";
    private static final String USAGE_DISPLAYED_STRING = "displayedString";
    private static final String APPDATA = "appdata";
    private final InstallConfiguration installConfiguration;
    private final String arch;

    @Inject
    public InstalledProductDataVersionImpl(InstallConfiguration installConfiguration, String string) {
        this.installConfiguration = installConfiguration;
        this.arch = string;
    }

    public void validate(File file, Product[] productArray) throws InvalidInstallationFolderException {
        File file2 = InstalledProductDataVersionImpl.getXMLFile(file);
        File file3 = InstalledProductDataVersionImpl.getVersionTxtFile(file);
        if (file2.exists()) {
            this.validateXML(file2, productArray);
        } else {
            this.validateVersionTxt(file3, productArray);
        }
    }

    private static File getVersionTxtFile(File file) {
        return new File(InstalledProductDataVersionImpl.getAppdataFolder(file), "version.txt");
    }

    private void validateVersionTxt(File file, Product[] productArray) throws InvalidInstallationFolderException {
        try {
            String string = FileUtils.readFileToString((File)file);
            if (InstalledProductDataVersionImpl.isVersion1(string)) {
                this.validateUsage(this.installConfiguration, "professional", InstutilResourceKeys.PROFESSIONAL_USAGE_STRING.getString(new Object[0]), productArray);
            } else {
                InstalledProductDataVersionImpl.throwIncompatibleFolderException();
            }
        }
        catch (IOException iOException) {
            InstalledProductDataVersionImpl.throwIncompatibleFolderException();
        }
    }

    private static void throwIncompatibleFolderException() throws InvalidInstallationFolderException {
        throw new InvalidInstallationFolderException(InstallResourceKeys.ERROR_INCOMPATIBLE_FILE_LIST_VERSION.getString(new Object[]{InstutilResourceKeys.RELEASE.getString(new Object[0])}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void validateXML(File file, Product[] productArray) throws InvalidInstallationFolderException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            Element element = InstalledProductDataVersionImpl.getRootElement(fileInputStream);
            this.validateUsage(this.installConfiguration, element, productArray);
        }
        catch (JDOMException jDOMException) {
            InstalledProductDataVersionImpl.throwIncompatibleFolderException();
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
        catch (IOException iOException) {
            InstalledProductDataVersionImpl.throwIncompatibleFolderException();
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileInputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
    }

    private void validateUsage(InstallConfiguration installConfiguration, Element element, Product[] productArray) throws InvalidInstallationFolderException {
        Element element2 = element.getChild(USAGE_TAG);
        String string = element2.getAttributeValue(USAGE_ID);
        String string2 = element2.getAttributeValue(USAGE_DISPLAYED_STRING);
        this.validateUsage(installConfiguration, string, string2, productArray);
    }

    private static Element getRootElement(FileInputStream fileInputStream) throws JDOMException, IOException {
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build((InputStream)fileInputStream);
        return document.getRootElement();
    }

    private void validateUsage(InstallConfiguration installConfiguration, String string, String string2, Product[] productArray) throws InvalidInstallationFolderException {
        if (!installConfiguration.getUsageId(this.arch, productArray).equalsIgnoreCase(string)) {
            throw new InvalidInstallationFolderException(InstallResourceKeys.ERROR_INCOMPATIBLE_FILE_LIST_USAGE.getString(new Object[]{installConfiguration.getUsageString(this.arch, productArray), string2}));
        }
    }

    private static boolean isVersion1(String string) {
        return string.equalsIgnoreCase("1.0");
    }

    private static File getXMLFile(File file) {
        return new File(InstalledProductDataVersionImpl.getAppdataFolder(file), XML_FILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, Product[] productArray) throws IOException {
        InstalledProductDataVersionImpl.createAppdataFolderIfNecessary(file);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = InstalledProductDataVersionImpl.createXMLOutputStream(file);
            this.writeXML(this.installConfiguration, fileOutputStream, productArray);
            InstalledProductDataVersionImpl.deleteVersionTxtFileIfNecessary(file);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }
    }

    private static void deleteVersionTxtFileIfNecessary(File file) throws IOException {
        File file2 = InstalledProductDataVersionImpl.getVersionTxtFile(file);
        if (file2.exists()) {
            FileUtils.forceDelete((File)file2);
        }
    }

    private static FileOutputStream createXMLOutputStream(File file) throws FileNotFoundException {
        File file2 = InstalledProductDataVersionImpl.getXMLFile(file);
        file2.setWritable(true);
        return new FileOutputStream(file2);
    }

    private static void createAppdataFolderIfNecessary(File file) {
        InstalledProductDataVersionImpl.getAppdataFolder(file).mkdirs();
    }

    private void writeXML(InstallConfiguration installConfiguration, FileOutputStream fileOutputStream, Product[] productArray) throws IOException {
        Document document = new Document(this.createXMLContent(installConfiguration, productArray));
        XMLOutputter xMLOutputter = new XMLOutputter();
        xMLOutputter.setFormat(Format.getPrettyFormat());
        xMLOutputter.output(document, (OutputStream)fileOutputStream);
    }

    private Element createXMLContent(InstallConfiguration installConfiguration, Product[] productArray) {
        Element element = this.createUsageElement(installConfiguration, productArray);
        return InstalledProductDataVersionImpl.createRootElement(element);
    }

    private Element createUsageElement(InstallConfiguration installConfiguration, Product[] productArray) {
        Element element = new Element(USAGE_TAG);
        element.setAttribute(USAGE_ID, installConfiguration.getUsageId(this.arch, productArray));
        element.setAttribute(USAGE_DISPLAYED_STRING, installConfiguration.getUsageString(this.arch, productArray));
        return element;
    }

    private static Element createRootElement(Element element) {
        Element element2 = new Element(ROOT_TAG);
        element2.setAttribute(VERSION_TAG, VERSION);
        element2.addContent((Content)element);
        return element2;
    }

    private static File getAppdataFolder(File file) {
        return new File(file, APPDATA);
    }
}

