/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl;

import com.google.inject.Inject;
import com.mathworks.install.ComponentContainer;
import com.mathworks.install.ComponentData;
import com.mathworks.install.FileListParser;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.InstalledProductData;
import com.mathworks.install.InstalledProductDataVersion;
import com.mathworks.install.OwningProductResponse;
import com.mathworks.install.Product;
import com.mathworks.install.ProductContainer;
import com.mathworks.install.XMLParseException;
import com.mathworks.install.XMLParserFactory;
import com.mathworks.install_impl.ComponentFileListParser;
import com.mathworks.install_impl.OwningProductResponseImpl;
import com.mathworks.install_impl.ProductFileListParser;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.logging.AppLogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

final class InstalledProductDataImpl
implements InstalledProductData {
    private static final String APPDATA = "appdata";
    private static final String PRODUCT_CONTENTS_NAME = "prodcontents.bin";
    private static final String COMPONENT_CONTENTS_NAME = "compcontents.bin";
    private static final String PRODUCTS = "products";
    private static final String COMPONENTS = "components";
    private static final String FILES = "files";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String INSTALLED_PRODUCT_DATA_NAME = "installedProductData.bin";
    private static final String INSTALLED_PRODUCT_TEXT_FILE = "installedProductData.txt";
    private static final String DELIMITER = "|";
    private Map<String, List<String>> installedProductContents = Collections.synchronizedMap(new HashMap());
    private Map<String, List<String>> installedComponentContents = Collections.synchronizedMap(new HashMap());
    private Map<String, Long> installedProductData = Collections.synchronizedMap(new HashMap());
    private Map<String, Set<String>> componentToFileListMap = Collections.synchronizedMap(new HashMap());
    private Map<File, String> filesToWrite = Collections.synchronizedMap(new HashMap());
    private List<File> filesToDelete = Collections.synchronizedList(new ArrayList());
    private List<File> lockedFilesToDelete = Collections.synchronizedList(new ArrayList());
    private List<File> lockedFilesToUpdate = Collections.synchronizedList(new ArrayList());
    private final ProductContainer prodContainer;
    private final ComponentContainer compContainer;
    private final XMLParserFactory parserFactory;
    private final ExecutorService executor;
    private final Platform platform;
    private final InstalledProductDataVersion installedProductDataVersion;
    private final IO io;
    private final AppLogger appLogger;
    private final Long installedDate;

    @Inject
    public InstalledProductDataImpl(ProductContainer productContainer, ComponentContainer componentContainer, XMLParserFactory xMLParserFactory, ExecutorService executorService, Platform platform, InstalledProductDataVersion installedProductDataVersion, IO iO, AppLogger appLogger) {
        this.prodContainer = productContainer;
        this.compContainer = componentContainer;
        this.parserFactory = xMLParserFactory;
        this.executor = executorService;
        this.platform = platform;
        this.installedProductDataVersion = installedProductDataVersion;
        this.io = iO;
        this.appLogger = appLogger;
        this.installedDate = Calendar.getInstance().getTimeInMillis();
    }

    public final void loadAllData(File file) throws IOException, XMLParseException, ExecutionException, InterruptedException {
        HashMap hashMap = new HashMap();
        File file2 = new File(file, APPDATA);
        this.startLoadingProductData(hashMap, file.getAbsolutePath());
        this.startLoadingComponentAndFileData(file, hashMap, file2);
        this.startLoadingInstalledProductData(file);
        InstalledProductDataImpl.blockUntilLoadingIsComplete(hashMap);
    }

    private void startLoadingInstalledProductData(File file) throws IOException {
        File file2 = this.getInstalledProductDataMap(file);
        if (file2.isFile()) {
            Map map = Collections.synchronizedMap((Map)InstalledProductDataImpl.deserializeData(file2));
            for (String string : map.keySet()) {
                this.installedProductData.put(string, (Long)map.get(string));
            }
        }
    }

    public final void writeContentsData(File file, Product[] productArray) throws IOException {
        this.writeInstalledProductAndComponentContents(file);
        for (String string : this.componentToFileListMap.keySet()) {
            this.serializeData(InstalledProductDataImpl.getFileListFile(string, file.getAbsolutePath()), this.componentToFileListMap.get(string));
        }
        File file2 = new File(file, APPDATA);
        if (this.installedProductContents.isEmpty()) {
            this.io.deleteDirectory(file2);
        } else {
            this.installedProductDataVersion.write(file, productArray);
        }
    }

    public void updateContentsData(File file, List<String> list) throws IOException {
        for (String string : this.componentToFileListMap.keySet()) {
            if (!list.contains(InstalledProductDataImpl.extractNameFromComponentNameAndVersion(string))) continue;
            this.filesToDelete.add(InstalledProductDataImpl.getFileListFile(string, file.toString()));
        }
        this.mergeFileListDataForAComponent();
        this.writeInstalledProductAndComponentContents(file);
        for (String string : this.componentToFileListMap.keySet()) {
            if (!list.contains(InstalledProductDataImpl.extractNameFromComponentNameAndVersion(string))) continue;
            this.serializeData(InstalledProductDataImpl.getFileListFile(string, file.getAbsolutePath()), this.componentToFileListMap.get(string));
        }
    }

    private void writeInstalledProductAndComponentContents(File file) throws IOException {
        for (File file2 : this.filesToDelete) {
            this.io.deleteFile(file2);
        }
        this.filesToDelete.clear();
        File file3 = new File(file, APPDATA);
        this.writeContentsTo(file3, PRODUCT_CONTENTS_NAME, this.installedProductContents, file.getAbsolutePath());
        this.writeContentsTo(file3, COMPONENT_CONTENTS_NAME, this.installedComponentContents, file.getAbsolutePath());
        this.writeOutFiles();
    }

    private void mergeFileListDataForAComponent() {
        Object object;
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (String string : this.componentToFileListMap.keySet()) {
            object = InstalledProductDataImpl.extractNameFromComponentNameAndVersion(string);
            InstalledProductDataImpl.addToMappedList((String)object, string, hashMap);
        }
        for (String string : hashMap.keySet()) {
            object = (List)hashMap.get(string);
            if (object.isEmpty()) continue;
            Collections.sort(object, Collections.reverseOrder());
            String string2 = (String)object.get(0);
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                linkedHashSet.addAll((Collection<String>)this.componentToFileListMap.get(string3));
                this.componentToFileListMap.remove(string3);
            }
            this.componentToFileListMap.put(string2, InstalledProductDataImpl.reverseSort(linkedHashSet));
        }
    }

    private static Set<String> reverseSort(Set<String> set) {
        ArrayList<String> arrayList = new ArrayList<String>(set);
        Collections.sort(arrayList, Collections.reverseOrder());
        return new LinkedHashSet<String>(arrayList);
    }

    public void writeInstalledProductData(File file, InstallableProduct[] installableProductArray) throws IOException {
        File file2 = this.getInstalledProductDataMap(file);
        File file3 = this.getInstalledProductTextFile(file);
        for (InstallableProduct installableProduct : installableProductArray) {
            this.installedProductData.put(installableProduct.getProductData().getProductBaseCode(), this.installedDate);
            if (!installableProduct.isMATLABRuntimeProduct()) continue;
            try {
                this.io.writeStringToFile(Integer.toString(installableProduct.getProductData().getProductNumber()) + System.getProperty("line.separator"), file3, 0L, 420, true, new IOObserver[0]);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (!this.installedProductData.isEmpty()) {
            this.serializeData(file2, this.installedProductData);
        }
    }

    public void updateComponentVersionInFileListMap(File file, String string) throws IOException {
        String string2 = InstalledProductDataImpl.extractNameFromComponentNameAndVersion(string);
        for (String string3 : this.componentToFileListMap.keySet()) {
            String string4 = InstalledProductDataImpl.extractNameFromComponentNameAndVersion(string3);
            if (!string4.equalsIgnoreCase(string2) || string3.equalsIgnoreCase(string)) continue;
            Set<String> set = this.componentToFileListMap.get(string3);
            this.componentToFileListMap.remove(string3);
            this.filesToDelete.add(InstalledProductDataImpl.getFileListFile(string3, file.getAbsolutePath()));
            this.componentToFileListMap.put(string, set);
            this.serializeData(InstalledProductDataImpl.getFileListFile(string, file.getAbsolutePath()), this.componentToFileListMap.get(string));
            break;
        }
    }

    public void writeLockedFilesPath(File file) {
        for (File file2 : this.lockedFilesToDelete) {
            try {
                FileUtils.writeStringToFile((File)file, (String)("DELETE|" + file2.toString() + System.getProperty("line.separator")), (boolean)true);
            }
            catch (Exception exception) {
                this.appLogger.safeLogMsg(exception.getMessage());
            }
        }
        for (File file2 : this.lockedFilesToUpdate) {
            try {
                FileUtils.writeStringToFile((File)file, (String)("UPDATE|" + file2.toString() + System.getProperty("line.separator")), (boolean)true);
            }
            catch (Exception exception) {
                this.appLogger.safeLogMsg(exception.getMessage());
            }
        }
    }

    public boolean isLockedFilesExist() {
        return !this.lockedFilesToDelete.isEmpty() || !this.lockedFilesToUpdate.isEmpty();
    }

    public int getNumberOfLockedFiles() {
        return this.lockedFilesToDelete.size() + this.lockedFilesToUpdate.size() - 1;
    }

    public void clearInstalledProductData(File file, InstallableProduct[] installableProductArray) throws IOException, InterruptedException {
        File file2 = this.getInstalledProductDataMap(file);
        File file3 = this.getInstalledProductTextFile(file);
        for (InstallableProduct installableProduct : installableProductArray) {
            String string = installableProduct.getProductData().getProductBaseCode();
            if (!this.installedProductData.containsKey(string)) continue;
            this.installedProductData.remove(string);
        }
        if (!this.installedProductData.isEmpty()) {
            this.serializeData(file2, this.installedProductData);
        } else {
            if (file2.isFile()) {
                this.io.deleteFile(file2);
            }
            if (file3.isFile()) {
                this.io.deleteFile(file3);
            }
        }
    }

    private File getInstalledProductDataMap(File file) {
        File file2 = new File(file, APPDATA);
        return new File(file2, INSTALLED_PRODUCT_DATA_NAME);
    }

    private File getInstalledProductTextFile(File file) {
        File file2 = new File(file, APPDATA);
        return new File(file2, INSTALLED_PRODUCT_TEXT_FILE);
    }

    public Map<String, Long> getInstalledProductData(String string) throws IOException {
        File file = this.getInstalledProductDataMap(new File(string));
        Map<String, Long> map = new HashMap<String, Long>();
        if (file.isFile()) {
            map = Collections.synchronizedMap((Map)InstalledProductDataImpl.deserializeData(file));
        }
        return map;
    }

    public void addToLockedFilesToDelete(List<String> list) {
        for (String string : list) {
            this.lockedFilesToDelete.add(new File(string));
        }
    }

    public void addToLockedFilesToUpdate(List<String> list) {
        for (String string : list) {
            this.lockedFilesToUpdate.add(new File(string));
        }
    }

    private String getKeyForProductName(String string) {
        return string + ' ' + this.platform.getArchString();
    }

    private static void addToMappedList(String string, String string2, Map<String, List<String>> map) {
        List<String> list;
        List<String> list2 = map.get(string);
        if (list2 == null) {
            list = Collections.synchronizedList(new ArrayList());
            map.put(string, list);
        } else {
            list = list2;
        }
        for (String string3 : list) {
            if (!string3.equalsIgnoreCase(string2)) continue;
            return;
        }
        list.add(string2);
    }

    public final void installProductFileData(String string, String string2, String[] stringArray) {
        String string3 = this.getKeyForProductName(string);
        File file = new File(new File(string2, APPDATA), PRODUCTS);
        for (String string4 : stringArray) {
            File file2 = new File(file, string3 + ' ' + InstalledProductDataImpl.getRandomNumber() + ".xml");
            String string5 = file2.getAbsolutePath();
            this.filesToWrite.put(file2, string4);
            InstalledProductDataImpl.addToMappedList(string3, string5, this.installedProductContents);
        }
    }

    public final void installComponentFileData(String string, String string2, String string3) {
        File file = new File(new File(string2, APPDATA), COMPONENTS);
        File file2 = new File(file, string + ' ' + InstalledProductDataImpl.getRandomNumber() + ".xml");
        this.filesToWrite.put(file2, string3);
        InstalledProductDataImpl.addToMappedList(string, file2.getAbsolutePath(), this.installedComponentContents);
    }

    public final void uninstallComponentFileData(String string, String string2) {
        String string3 = this.getComponentToFileListMapKey(string);
        this.removeEntry(string2, string3, this.installedComponentContents);
    }

    public final void installFileListData(Set<String> set, String string, String string2) {
        this.componentToFileListMap.put(string, set);
    }

    public final String[] getNonSharedFiles(String string, String string2) {
        String string3 = this.getComponentToFileListMapKey(string);
        if (this.componentToFileListMap.containsKey(string3)) {
            Set<String> set = this.componentToFileListMap.get(string3);
            for (String string4 : this.componentToFileListMap.keySet()) {
                if (string4.equalsIgnoreCase(string3)) continue;
                this.removeSharedFiles(set, string4);
            }
            return InstalledProductDataImpl.transformIntoAbsolutePaths(string2, set);
        }
        return EMPTY_STRING_ARRAY;
    }

    public String[] getAbsolutePaths(List<String> list, String string) {
        return InstalledProductDataImpl.transformIntoAbsolutePaths(string, new HashSet<String>(list));
    }

    private String getComponentToFileListMapKey(String string) {
        if (this.componentToFileListMap.containsKey(InstalledProductDataImpl.extractNameFromComponentNameAndVersion(string))) {
            return InstalledProductDataImpl.extractNameFromComponentNameAndVersion(string);
        }
        return string;
    }

    public final long getTotalFileCount(String[] stringArray, String string) {
        Set<String> set = this.getAllFilesInComponents(stringArray);
        this.removeFilesAlsoInComponentsNotBeingUninstalled(stringArray, set);
        return set.size();
    }

    private Collection<String> getComponentIdentifiers(ComponentData[] componentDataArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (ComponentData componentData : componentDataArray) {
            hashSet.add(componentData.getComponentNameAndVersion());
        }
        return hashSet;
    }

    private Collection<String> getComponentFiles(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : this.componentToFileListMap.get(string)) {
            if (!string2.endsWith(".phl")) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    public List<String> getInstalledPathEntriesForProduct(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>(list);
        String string = this.platform.getArchString();
        InstallableProduct[] installableProductArray = this.prodContainer.getInstallableProducts(string);
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        for (InstallableProduct installableProduct : installableProductArray) {
            Collection<String> collection = this.getComponentIdentifiers(installableProduct.getRequiredComponents(string));
            if (hashSet.contains(installableProduct.getProductData().getProductBaseCode())) {
                hashSet2.addAll(collection);
                continue;
            }
            hashSet3.addAll(collection);
        }
        for (String string2 : hashSet2) {
            if (hashSet3.contains(string2)) continue;
            arrayList.addAll(this.getComponentFiles(string2));
        }
        return arrayList;
    }

    public List<ComponentData> getComponentsToUninstallForSSI(List<String> list) {
        ArrayList<ComponentData> arrayList = new ArrayList<ComponentData>();
        HashSet<String> hashSet = new HashSet<String>(list);
        String string = this.platform.getArchString();
        InstallableProduct[] installableProductArray = this.prodContainer.getInstallableProducts(string);
        HashSet<ComponentData> hashSet2 = new HashSet<ComponentData>();
        HashSet<ComponentData> hashSet3 = new HashSet<ComponentData>();
        for (InstallableProduct installableProduct : installableProductArray) {
            ComponentData[] componentDataArray = installableProduct.getRequiredComponents(string);
            if (hashSet.contains(installableProduct.getProductData().getProductBaseCode())) {
                hashSet2.addAll(Arrays.asList(componentDataArray));
                continue;
            }
            hashSet3.addAll(Arrays.asList(componentDataArray));
        }
        hashSet2.removeAll(hashSet3);
        arrayList.addAll(hashSet2);
        return arrayList;
    }

    public OwningProductResponse getOwningFiles(File file, String[] stringArray) {
        InstallableProduct[] installableProductArray;
        HashSet<Product> hashSet = new HashSet<Product>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        for (String string : stringArray) {
            File file2 = new File(string);
            String string2 = FilenameUtils.normalize((String)file2.getAbsolutePath());
            hashSet3.add(string2);
            hashSet2.add(string2);
        }
        String string = this.platform.getArchString();
        for (InstallableProduct installableProduct : installableProductArray = this.prodContainer.getInstallableProducts(string)) {
            ComponentData[] componentDataArray;
            for (ComponentData componentData : componentDataArray = installableProduct.getRequiredComponents(string)) {
                Iterator<String> iterator = this.componentToFileListMap.get(componentData.getComponentNameAndVersion()).iterator();
                while (iterator.hasNext()) {
                    FileCollectionMatcher fileCollectionMatcher = new FileCollectionMatcher();
                    FileCollections<Boolean> fileCollections = new FileCollections<Boolean>(fileCollectionMatcher, hashSet3);
                    String string3 = iterator.next();
                    File file3 = new File(file, string3);
                    String string4 = file3.getAbsolutePath();
                    if (!fileCollections.findMatch(string4).booleanValue()) continue;
                    hashSet.add(installableProduct.getProductData());
                    Collections.addAll(hashSet, installableProduct.getRequiredProducts());
                    FileCollectionRemoveMatch fileCollectionRemoveMatch = new FileCollectionRemoveMatch(hashSet2);
                    FileCollections<Void> fileCollections2 = new FileCollections<Void>(fileCollectionRemoveMatch, hashSet2);
                    fileCollections2.findMatch(string4);
                }
            }
        }
        return new OwningProductResponseImpl(hashSet.toArray(new Product[hashSet.size()]), hashSet2.toArray(new String[hashSet2.size()]));
    }

    private void loadProductDataOnly(String string) throws IOException, ExecutionException, XMLParseException, InterruptedException {
        HashMap hashMap = new HashMap();
        this.startLoadingProductData(hashMap, string);
        InstalledProductDataImpl.blockUntilLoadingIsComplete(hashMap);
    }

    public final InstallableProduct[] getInstallableProds(File file) {
        InstallableProduct[] installableProductArray = null;
        try {
            this.loadProductDataOnly(file.getAbsolutePath());
            installableProductArray = this.prodContainer.getInstallableProducts(this.platform.getArchString());
        }
        catch (XMLParseException | IOException | InterruptedException | ExecutionException throwable) {
            // empty catch block
        }
        return installableProductArray;
    }

    private void removeFilesAlsoInComponentsNotBeingUninstalled(String[] stringArray, Set<String> set) {
        for (String string : this.installedComponentContents.keySet()) {
            if (InstalledProductDataImpl.beingUninstalled(string, stringArray)) continue;
            for (String string2 : this.componentToFileListMap.get(string)) {
                set.remove(string2);
            }
        }
    }

    private static boolean beingUninstalled(String string, String[] stringArray) {
        boolean bl = false;
        for (String string2 : stringArray) {
            if (!string2.equalsIgnoreCase(string) && !InstalledProductDataImpl.extractNameFromComponentNameAndVersion(string2).equalsIgnoreCase(string)) continue;
            bl = true;
        }
        return bl;
    }

    private static String extractNameFromComponentNameAndVersion(String string) {
        return string.split(" ")[0];
    }

    public final void removeComponent(String string, String string2) {
        String string3 = this.getComponentToFileListMapKey(string);
        this.filesToDelete.add(InstalledProductDataImpl.getFileListFile(string3, string2));
        this.componentToFileListMap.remove(string3);
        this.removeEntry(string2, string3, this.installedComponentContents);
    }

    public final void removeFilesFromAComponent(String string, String string2, List list) throws IOException {
        for (String string3 : this.componentToFileListMap.keySet()) {
            if (!string.equalsIgnoreCase(InstalledProductDataImpl.extractNameFromComponentNameAndVersion(string3))) continue;
            Set<String> set = this.componentToFileListMap.get(string3);
            set.removeAll(list);
            this.componentToFileListMap.put(string3, set);
        }
    }

    public final void removeProduct(String string, String string2) {
        String string3 = this.getKeyForProductName(string);
        this.removeEntry(string2, string3, this.installedProductContents);
    }

    private void removeEntry(String string, String string2, Map<String, List<String>> map) {
        if (map.containsKey(string2)) {
            this.deleteAll(map.get(string2), string);
            map.remove(string2);
        }
    }

    private void deleteAll(List<String> list, String string) {
        for (String string2 : list) {
            File file = string2.startsWith(string) ? new File(string2) : new File(string, string2);
            this.filesToDelete.add(file);
        }
    }

    private static String[] transformIntoAbsolutePaths(String string, Set<String> set) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string2 : set) {
            linkedHashSet.add(new File(string, string2).getAbsolutePath());
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    private void writeOutFiles() throws IOException {
        for (File file : this.filesToWrite.keySet()) {
            this.io.createParentIfNecessary(file);
            try {
                this.io.writeStringToFile(this.filesToWrite.get(file), file, 0L, 420, new IOObserver[0]);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.filesToWrite.clear();
    }

    private static long getRandomNumber() {
        long l = new SecureRandom().nextLong();
        l = l == Long.MIN_VALUE ? 0L : Math.abs(l);
        return l;
    }

    private void writeContentsTo(File file, String string, Map<String, List<String>> map, String string2) throws IOException {
        File file2 = new File(file, string);
        if (!map.isEmpty()) {
            for (String string3 : map.keySet()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string4 : map.get(string3)) {
                    if (string4.startsWith(string2)) {
                        arrayList.add(string4.substring(string2.length(), string4.length()));
                        continue;
                    }
                    arrayList.add(string4);
                }
                map.put(string3, arrayList);
            }
            this.serializeData(file2, map);
        } else if (file2.isFile()) {
            this.io.deleteFile(file2);
        }
    }

    public static File getFileListFile(String string, String string2) {
        return new File(new File(new File(string2, APPDATA), FILES), string + "_manifest.bin");
    }

    private void removeSharedFiles(Set<String> set, String string) {
        for (String string2 : this.componentToFileListMap.get(string)) {
            if (!set.contains(string2)) continue;
            set.remove(string2);
        }
    }

    private Set<String> getAllFilesInComponents(String[] stringArray) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string : stringArray) {
            String string2 = this.getComponentToFileListMapKey(string);
            if (!this.componentToFileListMap.containsKey(string2)) continue;
            linkedHashSet.addAll((Collection<String>)this.componentToFileListMap.get(string2));
        }
        return linkedHashSet;
    }

    private void startLoadingProductData(Map<Future<?>, FileListParser> map, String string) throws IOException {
        File file = new File(new File(string, APPDATA), PRODUCT_CONTENTS_NAME);
        if (file.isFile()) {
            InstalledProductDataImpl.setUpContentsMap(new File(string), file, this.installedProductContents);
            for (String string2 : this.installedProductContents.keySet()) {
                ProductFileListParser productFileListParser = new ProductFileListParser(string2, this.parserFactory, this.prodContainer, this.compContainer, this.installedProductContents, InstalledProductDataImpl.getArchForName(string2));
                map.put(this.executor.submit((Runnable)((Object)productFileListParser)), productFileListParser);
            }
        }
    }

    private void startLoadingComponentAndFileData(File file, Map<Future<?>, FileListParser> map, File file2) throws IOException {
        File file3 = new File(file2, COMPONENT_CONTENTS_NAME);
        if (file3.isFile()) {
            InstalledProductDataImpl.setUpContentsMap(file, file3, this.installedComponentContents);
            for (String string : this.installedComponentContents.keySet()) {
                ComponentFileListParser componentFileListParser = new ComponentFileListParser(string, file.getAbsolutePath(), this.parserFactory, this.prodContainer, this.compContainer, this.installedComponentContents, this.componentToFileListMap, InstalledProductDataImpl.getArchForName(string));
                map.put(this.executor.submit((Runnable)((Object)componentFileListParser)), componentFileListParser);
            }
        }
    }

    private static String getArchForName(String string) {
        return string.substring(string.lastIndexOf(32) + 1);
    }

    private static void setUpContentsMap(File file, File file2, Map<String, List<String>> map) throws IOException {
        Map map2 = Collections.synchronizedMap((Map)InstalledProductDataImpl.deserializeData(file2));
        for (String string : map2.keySet()) {
            List list = (List)map2.get(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : list) {
                arrayList.add(file + string2);
            }
            map.put(string, arrayList);
        }
    }

    private static void blockUntilLoadingIsComplete(Map<Future<?>, FileListParser> map) throws InterruptedException, ExecutionException, IOException, XMLParseException {
        for (Future<?> future : map.keySet()) {
            future.get();
            FileListParser fileListParser = map.get(future);
            if (fileListParser.getIOException() != null) {
                throw fileListParser.getIOException();
            }
            if (fileListParser.getXMLParseException() == null) continue;
            throw fileListParser.getXMLParseException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeData(File file, Object object) throws IOException {
        this.io.createParentIfNecessary(file);
        ObjectOutputStream objectOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
            objectOutputStream.writeObject(object);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(objectOutputStream);
            IOUtils.closeQuietly(bufferedOutputStream);
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)objectOutputStream);
        IOUtils.closeQuietly((OutputStream)bufferedOutputStream);
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }

    static Object deserializeData(File file) throws IOException {
        Object object = null;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            objectInputStream = new ObjectInputStream(bufferedInputStream);
            object = objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                throw new IOException();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(objectInputStream);
                IOUtils.closeQuietly(bufferedInputStream);
                IOUtils.closeQuietly((InputStream)fileInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)objectInputStream);
        IOUtils.closeQuietly((InputStream)bufferedInputStream);
        IOUtils.closeQuietly((InputStream)fileInputStream);
        return object;
    }

    private static class FileCollectionRemoveMatch
    implements FileCollectionVisitor<Void> {
        private final Set<String> collectionToDeleteFrom;
        private final Set<String> fileNamesToDelete = new HashSet<String>();

        FileCollectionRemoveMatch(Set<String> set) {
            this.collectionToDeleteFrom = set;
        }

        @Override
        public void matchWhileVisiting(String string) {
            this.fileNamesToDelete.add(string);
        }

        @Override
        public Void afterVisit() {
            for (String string : this.fileNamesToDelete) {
                this.collectionToDeleteFrom.remove(string);
            }
            return null;
        }
    }

    private static class FileCollectionMatcher
    implements FileCollectionVisitor<Boolean> {
        private boolean matchFound = false;

        private FileCollectionMatcher() {
        }

        @Override
        public void matchWhileVisiting(String string) {
            this.matchFound = true;
        }

        @Override
        public Boolean afterVisit() {
            return this.matchFound;
        }
    }

    private static interface FileCollectionVisitor<V> {
        public void matchWhileVisiting(String var1);

        public V afterVisit();
    }

    private class FileCollections<V> {
        private final FileCollectionVisitor<V> fileVisitor;
        private final Set<String> collection;

        FileCollections(FileCollectionVisitor<V> fileCollectionVisitor, Set<String> set) {
            this.fileVisitor = fileCollectionVisitor;
            this.collection = Collections.unmodifiableSet(set);
        }

        V findMatch(String string) {
            for (String string2 : this.collection) {
                if (!FilenameUtils.equalsOnSystem((String)string2, (String)string)) continue;
                this.fileVisitor.matchWhileVisiting(string2);
            }
            return this.fileVisitor.afterVisit();
        }
    }
}

