/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl;

import com.google.inject.Inject;
import com.mathworks.install.ComponentContainer;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstalledProductData;
import com.mathworks.install.InstalledProductDataFactory;
import com.mathworks.install.InstalledProductDataVersion;
import com.mathworks.install.ProductContainer;
import com.mathworks.install.XMLParseException;
import com.mathworks.install.XMLParserFactory;
import com.mathworks.install_impl.InstalledProductDataImpl;
import com.mathworks.install_impl.InstalledProductDataVersionImpl;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

final class InstalledProductDataFactoryImpl
implements InstalledProductDataFactory {
    private final XMLParserFactory xmlParserFactory;
    private final ExecutorService executorService;
    private final Platform platform;
    private final InstallConfiguration installConfiguration;
    private final IO io;
    private final AppLogger appLogger;

    @Inject
    public InstalledProductDataFactoryImpl(XMLParserFactory xMLParserFactory, ExecutorService executorService, Platform platform, InstallConfiguration installConfiguration, IO iO, AppLogger appLogger) {
        this.xmlParserFactory = xMLParserFactory;
        this.executorService = executorService;
        this.platform = platform;
        this.installConfiguration = installConfiguration;
        this.io = iO;
        this.appLogger = appLogger;
    }

    public InstalledProductData createInstalledProductData(File file, ProductContainer productContainer, ComponentContainer componentContainer) throws IOException, ExecutionException, XMLParseException, InterruptedException {
        InstalledProductDataImpl installedProductDataImpl = new InstalledProductDataImpl(productContainer, componentContainer, this.xmlParserFactory, this.executorService, this.platform, this.createInstalledProductDataVersion(), this.io, this.appLogger);
        installedProductDataImpl.loadAllData(file);
        return installedProductDataImpl;
    }

    public InstalledProductDataVersion createInstalledProductDataVersion() {
        return new InstalledProductDataVersionImpl(this.installConfiguration, this.platform.getArchString());
    }
}

