/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl;

import com.mathworks.install.ComponentContainer;
import com.mathworks.install.ComponentData;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallableComponent;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.Product;
import com.mathworks.install.ProductState;
import com.mathworks.install.ValidatedFik;
import com.mathworks.install.usage.UsageStrategy;
import com.mathworks.install_impl.input.DownloadLocationUtility;
import com.mathworks.install_impl.usage.UsageStrategyFactory;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;

final class InstallableProductImpl
implements InstallableProduct {
    private static final Product[] EMPTY_PRODUCTS = new Product[0];
    private final Product product;
    private final ComponentContainer componentContainer;
    private final Map<String, ComponentData> requiredComponents;
    private Product[] requiredProducts;
    private Product[] altDependencies;
    private String releaseFamily;
    private String releaseDescription;
    private String licenseAgreementType;
    private String productType;
    private ProductState productState = ProductState.NOTHING;
    private UsageStrategy usageStrategy = UsageStrategyFactory.createUsageStrategy(new String[0]);
    private Map<String, String> xml = new HashMap<String, String>();

    public InstallableProductImpl(Product product, ComponentData[] componentDataArray, ComponentContainer componentContainer) {
        this.product = product;
        this.componentContainer = componentContainer;
        this.requiredComponents = new LinkedHashMap<String, ComponentData>();
        for (ComponentData componentData : componentDataArray) {
            this.requiredComponents.put(componentData.getName(), componentData);
        }
        this.requiredProducts = EMPTY_PRODUCTS;
        this.altDependencies = EMPTY_PRODUCTS;
    }

    public Product[] getRequiredProducts() {
        return (Product[])this.requiredProducts.clone();
    }

    public Product[] getAltDependencies() {
        return (Product[])this.altDependencies.clone();
    }

    public String getReleaseFamily() {
        return this.releaseFamily;
    }

    public String getReleaseDescription() {
        return this.releaseDescription;
    }

    public String getLicenseAgreementType() {
        return this.licenseAgreementType;
    }

    public String getProductType() {
        return this.productType;
    }

    public ComponentData[] getRequiredComponents(String string) {
        ArrayList<ComponentData> arrayList = new ArrayList<ComponentData>();
        for (ComponentData componentData : this.requiredComponents.values()) {
            if (!componentData.hasPlatform(string)) continue;
            arrayList.add(componentData);
        }
        return arrayList.toArray(new ComponentData[arrayList.size()]);
    }

    public Product getProductData() {
        return this.product;
    }

    public boolean matchesDependency(Product product) {
        return this.product.getProductNumber() == product.getProductNumber();
    }

    public boolean isSupported(InstallConfiguration installConfiguration, ValidatedFik validatedFik) {
        return this.usageStrategy.isSupported(installConfiguration, validatedFik, this.product, this.getDownloadSize());
    }

    public boolean canActivate(InstallConfiguration installConfiguration) {
        return this.usageStrategy.canActivate(installConfiguration);
    }

    public boolean isCustomerFacing() {
        return this.usageStrategy.isCustomerFacing();
    }

    public long getDownloadSize() {
        return this.visitInstallableComponents(new InstallableComponentVisitor(){

            @Override
            public long getValue(InstallableComponent installableComponent) {
                return installableComponent.getRemainingDownloadSize();
            }
        });
    }

    private long getActualDownloadSize() {
        return this.visitInstallableComponents(new InstallableComponentVisitor(){

            @Override
            public long getValue(InstallableComponent installableComponent) {
                return installableComponent.getDownloadSize();
            }
        });
    }

    private long visitInstallableComponents(InstallableComponentVisitor installableComponentVisitor) {
        long l = 0L;
        for (ComponentData componentData : this.requiredComponents.values()) {
            InstallableComponent installableComponent;
            if (!componentData.hasPlatform(this.product.getArchitecture()) || (installableComponent = this.componentContainer.getInstallableComponent(componentData)) == null) continue;
            l += installableComponentVisitor.getValue(installableComponent);
        }
        return l;
    }

    public String[] getXML() {
        return new ArrayList<String>(this.xml.keySet()).toArray(new String[this.xml.size()]);
    }

    public boolean isSupported(InstallConfiguration installConfiguration) {
        return this.usageStrategy.isSupported(installConfiguration, this.product);
    }

    public void writeOutXML(File file) throws IOException {
        if (this.getActualDownloadSize() > 0L) {
            for (Map.Entry<String, String> entry : this.xml.entrySet()) {
                File file2 = DownloadLocationUtility.getLocationForProductdata(file, entry.getValue());
                File file3 = new File(file2, "productdata_" + this.getProductData().getName() + "_" + InstallableProductImpl.getRandomNumber() + ".xml");
                FileUtils.writeStringToFile((File)file3, (String)entry.getKey());
            }
        }
    }

    public boolean isMATLABRuntimeProduct() {
        return this.product.getProductNumber() >= 35000 & this.product.getProductNumber() <= 36000;
    }

    public InstallableComponent getInstallableComponent(ComponentData componentData) {
        return this.componentContainer.getInstallableComponent(componentData);
    }

    private static long getRandomNumber() {
        long l = new SecureRandom().nextLong();
        l = l == Long.MIN_VALUE ? 0L : Math.abs(l);
        return l;
    }

    public void addComponents(ComponentData[] componentDataArray) {
        for (ComponentData componentData : componentDataArray) {
            if (this.requiredComponents.containsKey(componentData.getName())) continue;
            this.requiredComponents.put(componentData.getName(), componentData);
        }
    }

    public void setRequiredProds(Product[] productArray) {
        this.requiredProducts = (Product[])productArray.clone();
    }

    public void setAltDependencies(Product[] productArray) {
        this.altDependencies = (Product[])productArray.clone();
    }

    public void setReleaseFamily(String string) {
        this.releaseFamily = string;
    }

    public void setReleaseDescription(String string) {
        this.releaseDescription = string;
    }

    public void setLicenseAgreementType(String string) {
        this.licenseAgreementType = string;
    }

    public void setProductType(String string) {
        this.productType = string;
    }

    ProductState getState() {
        return this.productState;
    }

    void setState(ProductState productState) {
        this.productState = productState;
    }

    public void setInstallerTypeUsage(String[] stringArray) {
        this.usageStrategy = UsageStrategyFactory.createUsageStrategy(stringArray);
    }

    public void addXML(String string, String string2) {
        this.xml.put(string, string2);
    }

    private static interface InstallableComponentVisitor {
        public long getValue(InstallableComponent var1);
    }
}

