/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl;

import com.mathworks.install.ComponentData;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallableComponent;
import com.mathworks.install.archive.MissingEntryException;
import com.mathworks.install.input.ComponentSource;
import com.mathworks.install.input.ComponentSourceProvider;
import com.mathworks.install.resources.InstallResourceKeys;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.instutil.IOObserver;
import java.io.File;
import java.io.IOException;

class InstallableComponentImpl
implements InstallableComponent {
    private final ComponentData compData;
    private final String xml;
    private final String fileName;
    private final String type;
    private final long uncompressedBytes;
    private final long size;
    private final ComponentSourceProvider componentSourceProvider;
    private final int locationId;
    private final String[] componentSourceIds;
    private boolean downloaded;
    private boolean installed;

    public InstallableComponentImpl(ComponentData componentData, String string, String string2, String string3, long l, long l2, ComponentSourceProvider componentSourceProvider, int n, String ... stringArray) {
        this.compData = componentData;
        this.xml = string;
        this.fileName = string2;
        this.type = string3;
        this.uncompressedBytes = l;
        this.size = l2;
        this.componentSourceProvider = componentSourceProvider;
        this.locationId = n;
        this.componentSourceIds = (String[])stringArray.clone();
    }

    public String getType() {
        return this.type;
    }

    public long getUncompressedBytes() {
        return this.uncompressedBytes;
    }

    public ComponentData getComponentData() {
        return this.compData;
    }

    public void download(File file, InstallFlowControlHandler installFlowControlHandler, IOObserver iOObserver, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        if (!this.downloaded) {
            this.componentSourceProvider.download(file, this.fileName, this.compData, this.size, this.xml, iOObserver);
            for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                installStatusObserver.confirm();
            }
            this.downloaded = true;
        }
    }

    public void downloadAndShowError(File file, InstallFlowControlHandler installFlowControlHandler, IOObserver iOObserver, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        if (!this.downloaded) {
            try {
                this.download(file, installFlowControlHandler, iOObserver, installStatusObserverArray);
            }
            catch (IOException iOException) {
                String string = InstallResourceKeys.EXTRACT_TITLE.getString(new Object[0]);
                String string2 = InstallResourceKeys.DOWNLOAD_RETRY_MESSAGE.getString(new Object[]{this.fileName, iOException.getMessage()});
                boolean bl = installFlowControlHandler.shouldRetry(string, string2, (Throwable)iOException);
                if (bl) {
                    for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                        installStatusObserver.reset();
                    }
                    this.downloadAndShowError(file, installFlowControlHandler, iOObserver, installStatusObserverArray);
                }
                throw iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(File file, File file2, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        if (!this.installed) {
            try {
                this.componentSourceProvider.open();
                ComponentSource componentSource = null;
                for (String string : this.componentSourceIds) {
                    try {
                        componentSource = this.componentSourceProvider.getComponentSource(file2, string, this.compData);
                        for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                            installStatusObserver.addComponent(this.compData);
                        }
                        componentSource.extract(file, installFlowControlHandler, installStatusObserverArray);
                        this.installed = true;
                        break;
                    }
                    catch (MissingEntryException missingEntryException) {
                    }
                }
                if (componentSource == null) {
                    throw new MissingEntryException(this.fileName);
                }
            }
            finally {
                this.componentSourceProvider.close();
            }
        }
    }

    public long getRemainingDownloadSize() {
        return this.downloaded ? 0L : this.getDownloadSize();
    }

    public long getDownloadSize() {
        return this.componentSourceProvider.getDownloadSize(this.size);
    }

    public int getLocationId() {
        return this.locationId;
    }

    public String getXML() {
        return this.xml;
    }

    public boolean isInstalled() {
        return this.installed;
    }
}

