/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl;

import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallOptionProvider;
import com.mathworks.install.InstallOptionType;
import com.mathworks.install.Product;
import com.mathworks.install_impl.InstallOptionImpl;
import java.util.ArrayList;

public class InstallOptionProviderImpl
implements InstallOptionProvider {
    private static final int MDCS = 94;
    private static final int MATLAB = 1;
    private static final int MATLAB_COMPILER = 28;
    private static final int LICENSE_MANAGER = 0;
    private static final int MPS = 126;
    private static final int POLYSPACE_BUG_FINDER = 164;
    private static final int POLYSPACE_CODE_PROVER = 165;
    private static final int POLYSPACE_SERVER = 166;

    private static InstallOption createSymbolicLinkOption(InstallOptionType installOptionType, boolean bl) {
        InstallOptionImpl installOptionImpl = new InstallOptionImpl(null, bl, installOptionType);
        installOptionImpl.setContext("/usr/local/bin");
        return installOptionImpl;
    }

    private static boolean containsAnythingOtherThanLicenseManager(Product[] productArray) {
        return !InstallOptionProviderImpl.containsLicenseManager(productArray) || productArray.length > 1;
    }

    private static boolean containsLicenseManager(Product[] productArray) {
        return InstallOptionProviderImpl.containsProduct(productArray, 0);
    }

    private static boolean containsProduct(Product[] productArray, int n) {
        for (Product product : productArray) {
            if (product.getProductNumber() != n) continue;
            return true;
        }
        return false;
    }

    public InstallOption[] getDefaultInstallOptions(Product[] productArray) {
        ArrayList<InstallOption> arrayList = new ArrayList<InstallOption>();
        if (InstallOptionProviderImpl.containsLicenseManager(productArray)) {
            arrayList.add(new InstallOptionImpl(System.getProperty("user.name"), true, InstallOptionType.LICENSE_SERVICE));
            if (InstallOptionProviderImpl.containsAnythingOtherThanLicenseManager(productArray)) {
                arrayList.add(new InstallOptionImpl(null, true, InstallOptionType.SERVER_AND_CLIENT_LICENSE_FILE));
            } else {
                arrayList.add(new InstallOptionImpl(null, true, InstallOptionType.SERVER_LICENSE_FILE));
            }
        } else {
            arrayList.add(new InstallOptionImpl(null, true, InstallOptionType.CLIENT_LICENSE_FILE));
        }
        if (this.isPolyspaceProduct(productArray)) {
            arrayList.add(new InstallOptionImpl("", false, InstallOptionType.POLYSPACE_SHORTCUT));
            arrayList.add(new InstallOptionImpl("", this.startMenuShortcutDefaultStatus(productArray), InstallOptionType.POLYSPACE_START_MENU_SHORTCUT));
        } else if (!this.isServerProduct(productArray)) {
            if (InstallOptionProviderImpl.containsAnythingOtherThanLicenseManager(productArray)) {
                arrayList.add(new InstallOptionImpl("", false, InstallOptionType.DESKTOP_SHORTCUT));
                arrayList.add(new InstallOptionImpl("", this.startMenuShortcutDefaultStatus(productArray), InstallOptionType.START_MENU_SHORTCUT));
            }
            if (InstallOptionProviderImpl.containsProduct(productArray, 1) || InstallOptionProviderImpl.containsProduct(productArray, 28)) {
                arrayList.add(InstallOptionProviderImpl.createSymbolicLinkOption(InstallOptionType.SYMBOLIC_LINK, this.getSymLinkDefault()));
            }
        }
        return arrayList.toArray(new InstallOption[arrayList.size()]);
    }

    private boolean isPolyspaceProduct(Product[] productArray) {
        return InstallOptionProviderImpl.containsProduct(productArray, 164) || InstallOptionProviderImpl.containsProduct(productArray, 165);
    }

    private boolean startMenuShortcutDefaultStatus(Product[] productArray) {
        return InstallOptionProviderImpl.containsProduct(productArray, 1) || InstallOptionProviderImpl.containsProduct(productArray, 164);
    }

    public InstallOption getDefaultPreferencesOption() {
        return new InstallOptionImpl(null, false, InstallOptionType.DELETE_PREFERENCES);
    }

    public InstallOption[] getUninstallOptions(Product[] productArray) {
        ArrayList<InstallOption> arrayList = new ArrayList<InstallOption>();
        if (InstallOptionProviderImpl.containsLicenseManager(productArray)) {
            arrayList.add(new InstallOptionImpl(System.getProperty("user.name"), true, InstallOptionType.LICENSE_SERVICE));
        }
        if (!this.isServerProduct(productArray) && InstallOptionProviderImpl.containsAnythingOtherThanLicenseManager(productArray)) {
            if (InstallOptionProviderImpl.containsProduct(productArray, 1)) {
                arrayList.add(new InstallOptionImpl("", true, InstallOptionType.DESKTOP_SHORTCUT));
                arrayList.add(new InstallOptionImpl("", true, InstallOptionType.START_MENU_SHORTCUT));
                arrayList.add(new InstallOptionImpl("", true, InstallOptionType.DELETE_MARKER_FILE));
            }
            if (InstallOptionProviderImpl.containsProduct(productArray, 1) || InstallOptionProviderImpl.containsProduct(productArray, 28)) {
                arrayList.add(InstallOptionProviderImpl.createSymbolicLinkOption(InstallOptionType.SYMBOLIC_LINK, true));
            }
            if (InstallOptionProviderImpl.containsProduct(productArray, 164)) {
                arrayList.add(new InstallOptionImpl("", true, InstallOptionType.POLYSPACE_SHORTCUT));
                arrayList.add(new InstallOptionImpl("", true, InstallOptionType.POLYSPACE_START_MENU_SHORTCUT));
            }
        }
        return arrayList.toArray(new InstallOption[arrayList.size()]);
    }

    private boolean isServerProduct(Product[] productArray) {
        return InstallOptionProviderImpl.containsProduct(productArray, 94) || InstallOptionProviderImpl.containsProduct(productArray, 126) || InstallOptionProviderImpl.containsProduct(productArray, 166);
    }

    public boolean getSymLinkDefault() {
        return false;
    }

    public InstallOption getJITLicenseOption(String string) {
        return new InstallOptionImpl(string, !string.isEmpty(), InstallOptionType.JIT_INSTALL);
    }
}

