/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.mathworks.install.ApplicationSpecificCommand;
import com.mathworks.install.CommandContainer;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallConfigurationPersistence;
import com.mathworks.install.InstallOptionProvider;
import com.mathworks.install.InstallerRequirements;
import com.mathworks.install.command.CommandFactory;
import com.mathworks.install.service.ServiceFactory;
import com.mathworks.install_impl.ApplicationSpecificCommandAdapter;
import com.mathworks.install_impl.CommandContainerImpl;
import com.mathworks.install_impl.InstallOptionProviderImpl;
import com.mathworks.install_impl.command.CommandModule;
import com.mathworks.install_impl.service.ServiceModule;
import com.mathworks.instutil.FileIO;
import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.FilePermissionsUtil;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.InstUtilPropertyKey;
import com.mathworks.instutil.LicenseNumberProvider;
import com.mathworks.instutil.LicenseNumberProviderImpl;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.SecurityOverride;
import java.util.Properties;

public class InstallCommonModule
extends AbstractModule {
    @Provides
    static CommandContainer provideCommandContainer(Platform platform, Properties properties, CommandFactory commandFactory, ServiceFactory serviceFactory, InstallConfiguration installConfiguration, InstallConfigurationPersistence installConfigurationPersistence, IO iO, InstallerRequirements installerRequirements, LicenseNumberProvider licenseNumberProvider) {
        String string = properties.getProperty(InstUtilPropertyKey.LIBDIR.get());
        String string2 = string == null ? properties.getProperty("root") : string;
        return new CommandContainerImpl(string2, commandFactory, serviceFactory, installConfiguration, iO, installConfigurationPersistence, installerRequirements, properties, platform, licenseNumberProvider);
    }

    @Provides
    @Singleton
    public static LicenseNumberProvider provideLicenseProvider(Properties properties) {
        return new LicenseNumberProviderImpl(properties.getProperty("licenseNumber", ""));
    }

    @Provides
    static IO provideIO(FilePermissions filePermissions, SecurityOverride securityOverride) {
        return new FileIO(filePermissions, securityOverride);
    }

    protected void configure() {
        this.bind(Platform.class).toInstance((Object)new PlatformImpl());
        this.bind(FilePermissions.class).to(FilePermissionsUtil.class);
        this.bind(InstallOptionProvider.class).to(InstallOptionProviderImpl.class);
        this.bind(ApplicationSpecificCommand.class).to(ApplicationSpecificCommandAdapter.class);
        this.install((Module)new ServiceModule());
        this.install((Module)new CommandModule());
    }
}

