/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl;

import com.mathworks.install.ComponentAggregator;
import com.mathworks.install.InstallableComponent;

final class ComponentSizeAggregator
implements ComponentAggregator {
    private long totalBytesAdded = 0L;
    private long totalBytesRemoved = 0L;
    private long totalDownloadSize = 0L;
    private long totalNumberOfFilesRemoved = 0L;

    ComponentSizeAggregator() {
    }

    public void add(InstallableComponent installableComponent) {
        this.totalBytesAdded += installableComponent.getUncompressedBytes();
        this.totalDownloadSize += installableComponent.getRemainingDownloadSize();
    }

    public void remove(InstallableComponent installableComponent, long l) {
        this.totalBytesRemoved += installableComponent.getUncompressedBytes();
        this.totalNumberOfFilesRemoved += l;
    }

    public long getTotalSize() {
        return this.getTotalDownloadSize() + this.totalBytesAdded - this.totalBytesRemoved;
    }

    public long getTotalDownloadSize() {
        return this.totalDownloadSize;
    }

    public long getTotalInstallUnits(long l) {
        return this.getTotalDownloadSize() + this.totalBytesAdded + this.totalNumberOfFilesRemoved * l;
    }
}

