/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.mathworks.install.ComponentContainer;
import com.mathworks.install.ComponentData;
import com.mathworks.install.ComponentInstaller;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallableComponent;
import com.mathworks.install.InstalledProductData;
import com.mathworks.install.UpdateComponentContainer;
import com.mathworks.install.resources.InstallResourceKeys;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.install_impl.status.InstallStatusObserverAdapter;
import com.mathworks.instutil.FolderUtils;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.ParentFolderOperation;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ComponentInstallerImpl
implements ComponentInstaller {
    private static final String VERSION_INFO_COMMON_COMPONENT_NAME = "version_info_common";
    private final InstalledProductData fileList;
    private final IO ioUtil;
    private final AppLogger logger;
    private final long statusFactor;
    private final UpdateComponentContainer updateComponentContainer;
    private InstallableComponent versionInfoComponent;

    @Inject
    public ComponentInstallerImpl(@Named(value="uninstallStatusFactor") Long l, InstalledProductData installedProductData, IO iO, AppLogger appLogger, UpdateComponentContainer updateComponentContainer) {
        this.statusFactor = l;
        this.fileList = installedProductData;
        this.ioUtil = iO;
        this.logger = appLogger;
        this.updateComponentContainer = updateComponentContainer;
    }

    public void installComponents(File file, File file2, InstallableComponent[] installableComponentArray, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        MyInstallStatusObserver myInstallStatusObserver = new MyInstallStatusObserver(file, (FolderUtils)this.ioUtil);
        this.extractComponents(file, file2, installableComponentArray, installFlowControlHandler, myInstallStatusObserver, installStatusObserverArray);
        myInstallStatusObserver.writeToFileList(installableComponentArray, this.fileList);
    }

    private void extractComponents(File file, File file2, InstallableComponent[] installableComponentArray, InstallFlowControlHandler installFlowControlHandler, MyInstallStatusObserver myInstallStatusObserver, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        ArrayList<InstallStatusObserver> arrayList = new ArrayList<InstallStatusObserver>();
        arrayList.addAll(Arrays.asList(installStatusObserverArray));
        arrayList.add(myInstallStatusObserver);
        for (InstallableComponent installableComponent : installableComponentArray) {
            this.installComponent(installableComponent, file, file2, installFlowControlHandler, arrayList.toArray(new InstallStatusObserver[arrayList.size()]));
        }
    }

    public void updateComponents(File file, File file2, File file3, InstallFlowControlHandler installFlowControlHandler, ComponentContainer componentContainer, List<String> list, Set<String> set, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        InstallableComponent[] installableComponentArray;
        Map map = componentContainer.getUpdatableComponents(list, set);
        for (InstallableComponent installableComponent : installableComponentArray = map.values().toArray(new InstallableComponent[map.values().size()])) {
            if (installableComponent.isInstalled()) continue;
            if (this.isVersionInfoComponent(installableComponent)) {
                this.versionInfoComponent = installableComponent;
                continue;
            }
            List list2 = this.updateComponentContainer.getFilesToUpdate(installableComponent.getComponentData().getName());
            this.detectLockedFilesAndInstallComponent(file, file2, file3, installFlowControlHandler, installableComponent, list2, installStatusObserverArray);
        }
    }

    public void addComponents(File file, File file2, File file3, InstallFlowControlHandler installFlowControlHandler, ComponentContainer componentContainer, List<String> list, Set<String> set, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        Map map = componentContainer.getUpdatableInstallableComponents(list);
        if (!map.isEmpty()) {
            InstallableComponent[] installableComponentArray;
            for (InstallableComponent installableComponent : installableComponentArray = map.values().toArray(new InstallableComponent[0])) {
                if (installableComponent.isInstalled()) continue;
                List list2 = this.updateComponentContainer.getFilesToUpdate(installableComponent.getComponentData().getName());
                this.detectLockedFilesAndInstallComponent(file, file2, file3, installFlowControlHandler, installableComponent, list2, installStatusObserverArray);
            }
        }
    }

    private void detectLockedFilesAndInstallComponent(File file, File file2, File file3, InstallFlowControlHandler installFlowControlHandler, InstallableComponent installableComponent, List<String> list, InstallStatusObserver[] installStatusObserverArray) throws IOException, InterruptedException {
        HashSet<String> hashSet = new HashSet<String>();
        if (!list.isEmpty()) {
            this.deleteFiles(file, list, hashSet, installStatusObserverArray);
        }
        if (hashSet.isEmpty()) {
            this.installComponents(file, file3, new InstallableComponent[]{installableComponent}, installFlowControlHandler, installStatusObserverArray);
        } else {
            this.handleLockedComponent(file, file2, file3, installFlowControlHandler, installableComponent, installStatusObserverArray);
        }
    }

    public void handleLockedComponent(File file, File file2, File file3, InstallFlowControlHandler installFlowControlHandler, InstallableComponent installableComponent, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        List list = this.updateComponentContainer.getFilesToUpdate(installableComponent.getComponentData().getName());
        MyInstallStatusObserver myInstallStatusObserver = new MyInstallStatusObserver(file2, (FolderUtils)this.ioUtil);
        this.extractComponents(file2, file3, new InstallableComponent[]{installableComponent}, installFlowControlHandler, myInstallStatusObserver, installStatusObserverArray);
        myInstallStatusObserver.writeToFileList(new InstallableComponent[]{installableComponent}, this.fileList, file);
        this.fileList.addToLockedFilesToUpdate(list);
    }

    private boolean isVersionInfoComponent(InstallableComponent installableComponent) {
        return installableComponent.getComponentData().getName().equals(VERSION_INFO_COMMON_COMPONENT_NAME);
    }

    /*
     * WARNING - void declaration
     */
    public void uninstallComponents(File file, InstallableComponent[] installableComponentArray, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws InterruptedException, IOException {
        for (InstallableComponent installableComponent : installableComponentArray) {
            void var12_16;
            String string = installableComponent.getComponentData().getComponentNameAndVersion();
            InstallStatusObserver[] installStatusObserverArray2 = installStatusObserverArray;
            int n = installStatusObserverArray2.length;
            boolean bl = false;
            while (var12_16 < n) {
                InstallStatusObserver installStatusObserver = installStatusObserverArray2[var12_16];
                installStatusObserver.removeComponent(installableComponent.getComponentData());
                ++var12_16;
            }
            String[] objectArray = this.fileList.getNonSharedFiles(installableComponent.getComponentData().getComponentNameAndVersion(), file.getAbsolutePath());
            HashSet hashSet = new HashSet();
            for (String string2 : objectArray) {
                installFlowControlHandler.checkTaskState();
                File file2 = new File(string2);
                this.ioUtil.deleteFile(file2, true, hashSet);
                for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                    installStatusObserver.removeFile(file2);
                    installStatusObserver.updateUnits(this.statusFactor);
                }
            }
            this.fileList.removeComponent(string, file.getAbsolutePath());
            this.fileList.addToLockedFilesToDelete(new ArrayList(hashSet));
        }
    }

    public void deleteFilesFromComponent(File file, ComponentContainer componentContainer, Set<String> set, InstallStatusObserver ... installStatusObserverArray) throws IOException {
        List list = this.updateComponentContainer.getComponentsWithFileDeletions();
        Map map = componentContainer.getUpdatableComponents(list, set);
        for (ComponentData componentData : map.keySet()) {
            String string = componentData.getName();
            List list2 = this.updateComponentContainer.getFilesToDelete(string);
            HashSet<String> hashSet = new HashSet<String>();
            this.deleteFiles(file, list2, hashSet, installStatusObserverArray);
            this.fileList.removeFilesFromAComponent(string, file.getAbsolutePath(), list2);
            this.fileList.addToLockedFilesToDelete(new ArrayList<String>(hashSet));
        }
    }

    public void updateAppdataForComponentsWithTouchedFiles(File file, ComponentContainer componentContainer, Set<String> set) throws IOException {
        List list = this.updateComponentContainer.getComponentsWithFilesTouchedButNotUpdated();
        Map map = componentContainer.getUpdatableComponents(list, set);
        for (ComponentData componentData : map.keySet()) {
            String string = componentData.getComponentNameAndVersion();
            this.fileList.updateComponentVersionInFileListMap(file, string);
        }
    }

    private void deleteFiles(File file, List<String> list, Set<String> set, InstallStatusObserver[] installStatusObserverArray) {
        String[] stringArray;
        for (String string : stringArray = this.fileList.getAbsolutePaths(list, file.getAbsolutePath())) {
            File file2 = new File(string);
            if (!file2.exists()) continue;
            this.ioUtil.deleteFile(file2, true, set);
            for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                installStatusObserver.removeFile(file2);
                installStatusObserver.updateUnits(this.statusFactor);
            }
        }
    }

    private void installComponent(InstallableComponent installableComponent, File file, File file2, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws InterruptedException, IOException {
        try {
            installableComponent.install(file, file2, installFlowControlHandler, installStatusObserverArray);
        }
        catch (IOException iOException) {
            String string = InstallResourceKeys.EXTRACT_TITLE.getString(new Object[0]);
            String string2 = InstallResourceKeys.INSTALL_RETRY_MESSAGE.getString(new Object[]{installableComponent.getComponentData().getName(), iOException.getMessage(), this.logger.getPath()});
            if (installFlowControlHandler.shouldRetry(string, string2, (Throwable)iOException)) {
                for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
                    installStatusObserver.reset();
                }
                this.installComponent(installableComponent, file, file2, installFlowControlHandler, installStatusObserverArray);
            }
            throw iOException;
        }
        for (InstallStatusObserver installStatusObserver : installStatusObserverArray) {
            installStatusObserver.confirm();
        }
    }

    public InstallableComponent getVersionInfoComponent() {
        return this.versionInfoComponent;
    }

    private static class MyInstallStatusObserver
    extends InstallStatusObserverAdapter {
        private final Map<String, Set<String>> fileListByComponentMap = new HashMap<String, Set<String>>();
        private Set<String> currentComponentFiles;
        private final File destinationFolder;
        private final FolderUtils folderUtils;

        MyInstallStatusObserver(File file, FolderUtils folderUtils) {
            this.destinationFolder = file;
            this.folderUtils = folderUtils;
        }

        @Override
        public void addComponent(ComponentData componentData) {
            this.currentComponentFiles = new LinkedHashSet<String>();
            this.fileListByComponentMap.put(componentData.getName(), this.currentComponentFiles);
        }

        @Override
        public void addFile(File file) {
            final ArrayList arrayList = new ArrayList();
            this.folderUtils.recursivelyOperateOnFileAndParents(file, this.destinationFolder, new ParentFolderOperation(){

                public void execute(File file) {
                    arrayList.add(this.trimOffMatlabRootToConserveMemory(file));
                }
            });
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                this.currentComponentFiles.add((String)arrayList.get(i));
            }
            String string = this.trimOffMatlabRootToConserveMemory(file);
            this.currentComponentFiles.add(string);
        }

        private String trimOffMatlabRootToConserveMemory(File file) {
            String string;
            String string2 = file.getAbsolutePath();
            String string3 = string2.startsWith(string = this.destinationFolder.getAbsolutePath() + File.separator) ? string2.substring(string.length(), string2.length()) : string2;
            return string3;
        }

        public void writeToFileList(InstallableComponent[] installableComponentArray, InstalledProductData installedProductData) throws IOException {
            this.writeToFileList(installableComponentArray, installedProductData, this.destinationFolder);
        }

        public void writeToFileList(InstallableComponent[] installableComponentArray, InstalledProductData installedProductData, File file) throws IOException {
            for (InstallableComponent installableComponent : installableComponentArray) {
                String string = installableComponent.getComponentData().getName();
                if (!this.fileListByComponentMap.containsKey(string)) continue;
                String string2 = installableComponent.getComponentData().getComponentNameAndVersion();
                installedProductData.installComponentFileData(string2, file.getAbsolutePath(), installableComponent.getXML());
                Set<String> set = MyInstallStatusObserver.reverseOrder(this.fileListByComponentMap.get(string));
                installedProductData.installFileListData(set, string2, file.getAbsolutePath());
            }
        }

        private static Set<String> reverseOrder(Set<String> set) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String object : set) {
                arrayList.add(object);
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            Collections.reverse(arrayList);
            for (String string : arrayList) {
                linkedHashSet.add(string);
            }
            return linkedHashSet;
        }
    }
}

