/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.InstallableComponent;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.instutil.IOObserver;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class ComponentDownloadCallable
implements Callable<List<InstallableComponent>> {
    private BlockingQueue<InstallableComponent> queue;
    private final InstallStatusObserver[] observers;
    private final File downloadFolder;
    private InstallFlowControlHandler flowControlHandler;
    private IOObserver ioObserver;
    private final AppLogger appLogger;
    private final AtomicInteger timeoutCounter;

    ComponentDownloadCallable(BlockingQueue<InstallableComponent> blockingQueue, InstallStatusObserver[] installStatusObserverArray, File file, InstallFlowControlHandler installFlowControlHandler, IOObserver iOObserver, AppLogger appLogger, AtomicInteger atomicInteger) {
        this.queue = blockingQueue;
        this.observers = (InstallStatusObserver[])installStatusObserverArray.clone();
        this.downloadFolder = file;
        this.flowControlHandler = installFlowControlHandler;
        this.ioObserver = iOObserver;
        this.appLogger = appLogger;
        this.timeoutCounter = atomicInteger;
    }

    @Override
    public List<InstallableComponent> call() throws InterruptedException {
        InstallableComponent installableComponent;
        ArrayList<InstallableComponent> arrayList = new ArrayList<InstallableComponent>();
        while ((installableComponent = this.queue.poll(100L, TimeUnit.MILLISECONDS)) != null) {
            try {
                installableComponent.download(this.downloadFolder, this.flowControlHandler, this.ioObserver, this.observers);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.timeoutCounter.getAndIncrement();
                this.appLogger.logMsg(socketTimeoutException.getMessage());
                arrayList.add(installableComponent);
            }
            catch (IOException iOException) {
                this.appLogger.logMsg(iOException.getMessage());
                arrayList.add(installableComponent);
            }
        }
        return arrayList;
    }
}

