/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl;

import com.mathworks.install.ComponentContainer;
import com.mathworks.install.ComponentData;
import com.mathworks.install.InstallableComponent;
import com.mathworks.install.input.ComponentSourceProvider;
import com.mathworks.install_impl.InstallableComponentImpl;
import com.mathworks.install_impl.input.NoOpComponentSourceProvider;
import com.mathworks.instutil.VersionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ComponentContainerImpl
implements ComponentContainer {
    private final Map<String, ComponentData> componentFlyweightMap = new HashMap<String, ComponentData>();
    private final Map<ComponentData, InstallableComponent> componentToInstallableComponentMap = new HashMap<ComponentData, InstallableComponent>();
    private final Map<ComponentData, InstallableComponent> installedComponentMap = new HashMap<ComponentData, InstallableComponent>();

    ComponentContainerImpl() {
    }

    public synchronized void clearCachedComponents() {
        this.componentFlyweightMap.clear();
        this.componentToInstallableComponentMap.clear();
    }

    public synchronized InstallableComponent addInstallableComponent(ComponentData componentData, String string, String string2, String string3, String string4, String string5, long l, long l2, ComponentSourceProvider componentSourceProvider, int n, String ... stringArray) {
        InstallableComponent installableComponent = this.componentToInstallableComponentMap.get(componentData);
        if (installableComponent == null) {
            installableComponent = new InstallableComponentImpl(componentData, string, string2, string5, l, l2, componentSourceProvider, n, stringArray);
            this.componentToInstallableComponentMap.put(componentData, installableComponent);
        }
        componentSourceProvider.addComponent(componentData.getComponentNameAndVersion());
        return installableComponent;
    }

    public synchronized InstallableComponent addUninstallableComponent(ComponentData componentData, String string, String string2, String string3, String string4, String string5, long l, long l2, int n) {
        InstallableComponent installableComponent = this.componentToInstallableComponentMap.get(componentData);
        if (installableComponent == null) {
            installableComponent = new InstallableComponentImpl(componentData, string, string2, string5, l, l2, new NoOpComponentSourceProvider(), n, new String[0]);
            this.componentToInstallableComponentMap.put(componentData, installableComponent);
        }
        this.installedComponentMap.put(componentData, installableComponent);
        return installableComponent;
    }

    public synchronized Map<ComponentData, InstallableComponent> getUpdatableInstallableComponents(List<String> list) {
        HashMap<ComponentData, InstallableComponent> hashMap = new HashMap<ComponentData, InstallableComponent>();
        Set<ComponentData> set = this.componentToInstallableComponentMap.keySet();
        for (ComponentData componentData : set) {
            if (!list.contains(componentData.getName())) continue;
            hashMap.put(componentData, this.componentToInstallableComponentMap.get(componentData));
        }
        return hashMap;
    }

    public synchronized Map<ComponentData, InstallableComponent> getUpdatableComponents(List<String> list, Set<String> set) {
        HashMap<ComponentData, InstallableComponent> hashMap = new HashMap<ComponentData, InstallableComponent>();
        Set<ComponentData> set2 = this.componentToInstallableComponentMap.keySet();
        for (ComponentData componentData : set2) {
            if (!list.contains(componentData.getName()) || !set.contains(componentData.getName())) continue;
            hashMap.put(componentData, this.componentToInstallableComponentMap.get(componentData));
        }
        return hashMap;
    }

    public synchronized ComponentData createComponent(String string, String string2, String string3, String[] stringArray, boolean bl) {
        String string4 = string + " " + string2;
        ComponentData componentData = this.componentFlyweightMap.get(string4);
        if (componentData == null) {
            componentData = new ComponentDataFlyweight(string, string2, string3, stringArray, bl);
            this.componentFlyweightMap.put(string4, componentData);
        } else if (!componentData.matches(string3, stringArray)) {
            // empty if block
        }
        return componentData;
    }

    public synchronized InstallableComponent getInstallableComponent(ComponentData componentData) {
        return this.componentToInstallableComponentMap.get(componentData);
    }

    public synchronized InstallableComponent[] getInstalledComponents() {
        return this.installedComponentMap.values().toArray(new InstallableComponent[this.installedComponentMap.size()]);
    }

    public synchronized Set<String> getInstalledComponentNames() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (InstallableComponent installableComponent : this.installedComponentMap.values()) {
            linkedHashSet.add(installableComponent.getComponentData().getName());
        }
        return linkedHashSet;
    }

    public void uninstallComponents(InstallableComponent[] installableComponentArray) {
        for (InstallableComponent installableComponent : installableComponentArray) {
            this.installedComponentMap.remove(installableComponent.getComponentData());
        }
    }

    private static final class ComponentDataFlyweight
    implements ComponentData {
        private final Collection<String> platforms = new ArrayList<String>();
        private final String componentName;
        private final String version;
        private final String locale;
        private final boolean isInstructionSet;

        ComponentDataFlyweight(String string, String string2, String string3, String[] stringArray, boolean bl) {
            this.componentName = string;
            this.version = string2;
            this.locale = string3;
            this.platforms.addAll(Arrays.asList(stringArray));
            this.isInstructionSet = bl;
        }

        public String getVersion() {
            return this.version;
        }

        public String getName() {
            return this.componentName;
        }

        public boolean isOlderThan(ComponentData componentData) {
            return VersionUtils.compareVersionNumbers((String)this.getVersion(), (String)componentData.getVersion()) < 0;
        }

        public boolean hasPlatform(String string) {
            for (String string2 : this.platforms) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }

        public String getComponentNameAndVersion() {
            return this.getName() + ' ' + this.getVersion();
        }

        public boolean matches(String string, String[] stringArray) {
            return string.equals(this.locale) && Arrays.equals(stringArray, this.platforms.toArray(new String[this.platforms.size()]));
        }

        public ArrayList<String> getPlatforms() {
            return new ArrayList<String>(this.platforms);
        }

        public String getLocale() {
            return this.locale;
        }

        public boolean isInstructionSet() {
            return this.isInstructionSet;
        }
    }
}

