/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install_impl;

import com.mathworks.install.CommandContainer;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallConfigurationPersistence;
import com.mathworks.install.InstallOption;
import com.mathworks.install.InstallableProduct;
import com.mathworks.install.InstallerRequirements;
import com.mathworks.install.Product;
import com.mathworks.install.command.Command;
import com.mathworks.install.command.CommandFactory;
import com.mathworks.install.service.ServiceFactory;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.LicenseNumberProvider;
import com.mathworks.instutil.Platform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;

final class CommandContainerImpl
implements CommandContainer {
    private final String sourcePath;
    private final CommandFactory commandFactory;
    private final ServiceFactory serviceFactory;
    private final InstallConfiguration installConfiguration;
    private final IO io;
    private final InstallConfigurationPersistence installConfigurationPersistence;
    private final InstallerRequirements installerRequirements;
    private final Properties properties;
    private final Platform platform;
    private final LicenseNumberProvider licenseNumberProvider;

    public CommandContainerImpl(String string, CommandFactory commandFactory, ServiceFactory serviceFactory, InstallConfiguration installConfiguration, IO iO, InstallConfigurationPersistence installConfigurationPersistence, InstallerRequirements installerRequirements, Properties properties, Platform platform, LicenseNumberProvider licenseNumberProvider) {
        this.sourcePath = string;
        this.commandFactory = commandFactory;
        this.serviceFactory = serviceFactory;
        this.installConfiguration = installConfiguration;
        this.io = iO;
        this.installConfigurationPersistence = installConfigurationPersistence;
        this.installerRequirements = installerRequirements;
        this.properties = properties;
        this.platform = platform;
        this.licenseNumberProvider = licenseNumberProvider;
    }

    private static Product[] getProducts(InstallableProduct[] installableProductArray) {
        return CommandContainerImpl.getProductCollection(installableProductArray).toArray(new Product[installableProductArray.length]);
    }

    private static Collection<Product> getProductCollection(InstallableProduct[] installableProductArray) {
        HashSet<Product> hashSet = new HashSet<Product>();
        for (InstallableProduct installableProduct : installableProductArray) {
            hashSet.add(installableProduct.getProductData());
        }
        return hashSet;
    }

    public Command[] getPreInstallCommands(InstallableProduct ... installableProductArray) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        this.addPreInstallCommandsForConfiguration(arrayList, CommandContainerImpl.getProducts(installableProductArray));
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    public Command[] getPostInstallCommands(InstallOption[] installOptionArray, InstallableProduct ... installableProductArray) {
        Collection<Command> collection = this.getCommandsWithoutOptions(installableProductArray);
        this.addPostInstallPreUninstallCommandsForOptions(installOptionArray, CommandContainerImpl.getProducts(installableProductArray), collection);
        this.addPostInstallPostUninstallCommandsForOptions(installOptionArray, CommandContainerImpl.getProducts(installableProductArray), collection);
        return collection.toArray(new Command[collection.size()]);
    }

    public Command[] getPostInstallCommandsNextGen(InstallOption[] installOptionArray, InstallableProduct ... installableProductArray) {
        Collection<Command> collection = this.getCommandsWithoutOptionsNextGen(installableProductArray);
        this.addPostInstallPreUninstallCommandsForOptions(installOptionArray, CommandContainerImpl.getProducts(installableProductArray), collection);
        this.addPostInstallPostUninstallCommandsForOptions(installOptionArray, CommandContainerImpl.getProducts(installableProductArray), collection);
        return collection.toArray(new Command[collection.size()]);
    }

    public Command[] getPostInstallCommands(InstallableProduct ... installableProductArray) {
        Collection<Command> collection = this.getCommandsWithoutOptions(installableProductArray);
        return collection.toArray(new Command[collection.size()]);
    }

    private Collection<Command> getCommandsWithoutOptionsNextGen(InstallableProduct[] installableProductArray) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        this.addRegisterApplicationCommands(arrayList, CommandContainerImpl.getProducts(installableProductArray));
        this.addPostInstallCommandsForConfiguration(arrayList, CommandContainerImpl.getProducts(installableProductArray));
        this.addInstallUninstallerCommands(arrayList, installableProductArray);
        this.addRegisterUninstallerCommands(arrayList, CommandContainerImpl.getProducts(installableProductArray));
        return arrayList;
    }

    private Collection<Command> getCommandsWithoutOptions(InstallableProduct[] installableProductArray) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        this.addRegisterApplicationCommands(arrayList, CommandContainerImpl.getProducts(installableProductArray));
        this.addPostInstallCommandsForConfiguration(arrayList, CommandContainerImpl.getProducts(installableProductArray));
        this.addInstallUninstallerCommands(arrayList, installableProductArray);
        this.addRegisterUninstallerCommands(arrayList, CommandContainerImpl.getProducts(installableProductArray));
        return arrayList;
    }

    public Command[] getPreUninstallCommands(InstallOption[] installOptionArray, InstallableProduct ... installableProductArray) {
        return this.getPreUninstallCommandOverride(installOptionArray, CommandContainerImpl.getProducts(installableProductArray));
    }

    public Command[] getPreUninstallCommandOverride(InstallOption[] installOptionArray, Product[] productArray) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        this.addRegisterApplicationCommands(arrayList, productArray);
        this.addPreInstallCommandsForConfiguration(arrayList, productArray);
        this.addPostInstallCommandsForConfiguration(arrayList, productArray);
        this.addPostInstallPreUninstallCommandsForOptions(installOptionArray, productArray, arrayList);
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    public Command[] getPostUninstallCommands(InstallOption[] installOptionArray, InstallableProduct ... installableProductArray) {
        return this.getPostUninstallCommandOverride(installOptionArray, CommandContainerImpl.getProducts(installableProductArray));
    }

    public Command[] getPostUninstallCommandOverride(InstallOption[] installOptionArray, Product ... productArray) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        this.addRegisterUninstallerCommands(arrayList, productArray);
        this.addPostUninstallCommandsForConfiguration(arrayList, productArray);
        this.addPostInstallPostUninstallCommandsForOptions(installOptionArray, productArray, arrayList);
        return arrayList.toArray(new Command[arrayList.size()]);
    }

    private void addInstallUninstallerCommands(Collection<Command> collection, InstallableProduct[] installableProductArray) {
        collection.addAll(Arrays.asList(this.installConfiguration.createInstallUninstallerCommands(this.platform.getArchString(), this.sourcePath, CommandContainerImpl.getProducts(installableProductArray), this.commandFactory, this.installConfigurationPersistence)));
    }

    private void addPostInstallCommandsForConfiguration(Collection<Command> collection, Product[] productArray) {
        collection.addAll(Arrays.asList(this.installConfiguration.getPostInstallCommands(this.platform.getArchString(), productArray, this.commandFactory, this.serviceFactory, this.io, this.properties)));
    }

    private void addPostUninstallCommandsForConfiguration(Collection<Command> collection, Product[] productArray) {
        collection.addAll(Arrays.asList(this.installConfiguration.getPostUninstallCommands(this.platform.getArchString(), productArray, this.commandFactory, this.io)));
    }

    private void addRegisterApplicationCommands(Collection<Command> collection, Product[] productArray) {
        collection.addAll(Arrays.asList(this.installConfiguration.createRegisterApplicationCommands(this.platform.getArchString(), productArray, this.commandFactory)));
    }

    private void addPreInstallCommandsForConfiguration(Collection<Command> collection, Product[] productArray) {
        collection.addAll(Arrays.asList(this.installConfiguration.getPreInstallCommands(this.platform.getArchString(), productArray, this.commandFactory, this.serviceFactory)));
    }

    private void addRegisterNextGenUninstallerCommands(Collection<Command> collection, Product[] productArray) {
        collection.addAll(Arrays.asList(this.installConfiguration.createRegisterNextGenUninstallerCommands(this.platform.getArchString(), productArray, this.commandFactory, this.installerRequirements)));
    }

    private void addRegisterUninstallerCommands(Collection<Command> collection, Product[] productArray) {
        collection.addAll(Arrays.asList(this.installConfiguration.createRegisterUninstallerCommands(this.platform.getArchString(), productArray, this.commandFactory, this.installerRequirements)));
    }

    private void addPostInstallPostUninstallCommandsForOptions(InstallOption[] installOptionArray, Product[] productArray, Collection<Command> collection) {
        if (this.installConfiguration.shouldAddCommandsForOptions(productArray)) {
            for (InstallOption installOption : installOptionArray) {
                this.addPostUninstallCommandsForOption(collection, productArray, installOption);
            }
        }
    }

    private void addPostUninstallCommandsForOption(Collection<Command> collection, Product[] productArray, InstallOption installOption) {
        if (installOption.isSelected()) {
            switch (installOption.getType()) {
                case DESKTOP_SHORTCUT: {
                    collection.addAll(Arrays.asList(this.installConfiguration.createDesktopShortcutCommands(this.platform.getArchString(), this.commandFactory, this.installerRequirements)));
                    break;
                }
                case POLYSPACE_SHORTCUT: {
                    collection.addAll(Arrays.asList(this.installConfiguration.createDesktopShortcutForPolyspaceCommands(this.platform.getArchString(), this.commandFactory, this.installerRequirements)));
                    break;
                }
                case POLYSPACE_START_MENU_SHORTCUT: {
                    collection.addAll(Arrays.asList(this.installConfiguration.createStartMenuShortcutForPolyspaceCommands(this.commandFactory, this.installerRequirements, this.platform)));
                    break;
                }
                case START_MENU_SHORTCUT: {
                    collection.addAll(Arrays.asList(this.installConfiguration.createStartMenuShortcutCommands(this.commandFactory, this.installerRequirements, this.platform)));
                    break;
                }
                case SERVER_LICENSE_FILE: 
                case CLIENT_LICENSE_FILE: 
                case SERVER_AND_CLIENT_LICENSE_FILE: {
                    collection.add(this.commandFactory.createWriteLicenseFileCommand(installOption));
                    break;
                }
                case SYMBOLIC_LINK: {
                    collection.addAll(Arrays.asList(this.installConfiguration.createSymbolicLinkCommands(productArray, this.platform.getArchString(), installOption, this.commandFactory)));
                    break;
                }
                case DELETE_PREFERENCES: {
                    collection.add(this.commandFactory.createDeletePreferencesCommand(installOption));
                    break;
                }
                case DELETE_MARKER_FILE: {
                    collection.add(this.commandFactory.createDeleteMarkerFileCommand());
                    break;
                }
            }
        }
    }

    private void addPostInstallPreUninstallCommandsForOptions(InstallOption[] installOptionArray, Product[] productArray, Collection<Command> collection) {
        if (productArray.length > 0) {
            for (InstallOption installOption : installOptionArray) {
                this.addPreUninstallCommandsForOption(collection, installOption);
            }
        }
    }

    private void addPreUninstallCommandsForOption(Collection<Command> collection, InstallOption installOption) {
        if (installOption.isSelected()) {
            switch (installOption.getType()) {
                case JIT_INSTALL: {
                    collection.add(this.commandFactory.createUpdateJITFileCommand(installOption, this.licenseNumberProvider));
                    break;
                }
                case LICENSE_SERVICE: {
                    collection.add(this.commandFactory.createInstallLicenseManagerServiceCommand(installOption, this.serviceFactory.createLicenseManagerService()));
                    break;
                }
                case CUSTOM: {
                    collection.addAll(Arrays.asList(installOption.getCommands(this.commandFactory, this.serviceFactory)));
                    break;
                }
            }
        }
    }
}

