/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webproxy;

import com.mathworks.webproxy.PropertiesProxyConfiguration;
import com.mathworks.webproxy.ProxyConfigurationVisitor;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.Properties;

public class SystemPropertiesProxyConfiguration
implements PropertiesProxyConfiguration {
    private static final String DEFAULT_EMPTY_STR = "";
    public static final String PROXY_HOST_SYSTEM_PROP = "tmw.proxyHost.override";
    public static final String PROXY_USER_SYSTEM_PROP = "tmw.proxyUser.override";
    public static final String PROXY_PASSWORD_SYSTEM_PROP = "tmw.proxyPassword.override";
    public static final String PROXY_PORT_SYSTEM_PROP = "tmw.proxyPort.override";
    private String fHostProperty;
    private String fPortProperty;
    private String fUserProperty;
    private String fPasswordProperty;

    SystemPropertiesProxyConfiguration(Properties properties) {
        this.fHostProperty = properties.getProperty(PROXY_HOST_SYSTEM_PROP, DEFAULT_EMPTY_STR);
        this.fPortProperty = properties.getProperty(PROXY_PORT_SYSTEM_PROP, DEFAULT_EMPTY_STR);
        this.fUserProperty = properties.getProperty(PROXY_USER_SYSTEM_PROP, DEFAULT_EMPTY_STR);
        this.fPasswordProperty = properties.getProperty(PROXY_PASSWORD_SYSTEM_PROP, DEFAULT_EMPTY_STR);
    }

    @Override
    public PasswordAuthentication getPasswordAuthentication() {
        return new PasswordAuthentication(this.getUsername(), this.getPassword());
    }

    @Override
    public boolean accept(ProxyConfigurationVisitor proxyConfigurationVisitor) {
        if (!this.getProxy().equals(Proxy.NO_PROXY)) {
            proxyConfigurationVisitor.visit(this);
            return true;
        }
        return false;
    }

    @Override
    public Proxy findProxyForURL(URL uRL) {
        return this.getProxy();
    }

    private Proxy getProxy() {
        try {
            if (!this.fHostProperty.isEmpty()) {
                int n = this.getPortNumber();
                InetSocketAddress inetSocketAddress = new InetSocketAddress(this.fHostProperty, n);
                return new Proxy(Proxy.Type.HTTP, inetSocketAddress);
            }
            return Proxy.NO_PROXY;
        }
        catch (Exception exception) {
            return Proxy.NO_PROXY;
        }
    }

    private int getPortNumber() {
        int n;
        try {
            n = Integer.parseInt(this.fPortProperty);
        }
        catch (NumberFormatException numberFormatException) {
            n = 80;
        }
        return n;
    }

    private String getUsername() {
        return this.fUserProperty;
    }

    private char[] getPassword() {
        return this.fPasswordProperty.toCharArray();
    }
}

