/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.ddux.client.installer;

import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.ddux.model.Key;
import com.mathworks.webservices.ddux.model.Settings;
import java.util.HashMap;
import java.util.List;

public class InstallerDDUXSettingsResponse {
    private boolean isShown;
    private boolean isChecked;
    private boolean isSelectable;

    InstallerDDUXSettingsResponse(Settings settings) {
        this.createResponseObject(settings);
    }

    public boolean isShown() {
        return this.isShown;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public boolean isSelectable() {
        return this.isSelectable;
    }

    private void createResponseObject(Settings settings) {
        List<Key> keys = settings.getKey();
        if (keys.size() < 3) {
            throw new MathWorksServiceException("The server failed to respond with a valid settings response");
        }
        HashMap<String, List<String>> mapOfKeys = new HashMap<String, List<String>>();
        for (Key key : keys) {
            mapOfKeys.put(key.getName(), key.getValue());
        }
        this.isShown = Boolean.parseBoolean((String)((List)mapOfKeys.get("installer.ddux.checkbox.isShown")).get(0));
        this.isChecked = Boolean.parseBoolean((String)((List)mapOfKeys.get("installer.ddux.checkbox.isChecked")).get(0));
        this.isSelectable = Boolean.parseBoolean((String)((List)mapOfKeys.get("installer.ddux.checkbox.isSelectable")).get(0));
    }
}

