/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.ddux.client.installer;

import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.http.HttpMethodName;
import com.mathworks.webservices.client.core.http.HttpRequest;

public class InstallerDDUXSettingsRequest {
    private String securityToken;
    private String application;
    private String applicationVersion;
    private String clientString;
    private String locale;
    private String entitlementId;

    public String getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public String getClientString() {
        return this.clientString;
    }

    public void setClientString(String clientString) {
        this.clientString = clientString;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getEntitlementId() {
        return this.entitlementId;
    }

    public void setEntitlementId(String entitlementId) {
        this.entitlementId = entitlementId;
    }

    protected HttpRequest createHttpRequest(String endpoint) {
        if (this.getEntitlementId() == null || "".equals(this.getEntitlementId())) {
            throw new MathWorksClientException("Invalid/empty entitlement Id");
        }
        if (this.getApplicationVersion() == null || "".equals(this.getApplicationVersion())) {
            throw new MathWorksClientException("Invalid/empty application Version");
        }
        if (this.getApplication() == null || "".equals(this.getApplication())) {
            throw new MathWorksClientException("Invalid/empty application Name");
        }
        if (this.getSecurityToken() == null || "".equals(this.getSecurityToken())) {
            throw new MathWorksClientException("A token is required for this request");
        }
        HttpRequest httpRequest = new HttpRequest(HttpMethodName.GET, endpoint, "/installer/ddux");
        httpRequest.setClientString(this.getClientString());
        httpRequest.setLocale(this.getLocale());
        httpRequest.addParameter("entitlementId", this.getEntitlementId());
        httpRequest.addParameter("applicationVersion", this.getApplicationVersion());
        httpRequest.addParameter("applicationName", this.getApplication());
        httpRequest.addHeader("Accept-Language", this.getLocale());
        httpRequest.addHeader("x-mw-authentication", this.getSecurityToken());
        return httpRequest;
    }
}

