/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.client.core.json;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mathworks.webservices.client.core.MathWorksClientException;
import java.io.IOException;
import java.io.InputStream;

public class JacksonResponseHandler {
    public static ObjectMapper objectMapper;

    public JacksonResponseHandler() {
        objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public <T> T handleResponse(InputStream response, Class<T> cls) {
        try {
            return (T)objectMapper.readValue(response, cls);
        }
        catch (JsonGenerationException e) {
            throw new MathWorksClientException("The client was not able to process the returned response", e);
        }
        catch (JsonMappingException e) {
            throw new MathWorksClientException("The client was not able to process the returned response", e);
        }
        catch (IOException e) {
            throw new MathWorksClientException("The client was not able to process the returned response", e);
        }
    }
}

