/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.client.core.http;

import com.mathworks.webservices.client.core.ClientConfiguration;
import com.mathworks.webservices.client.core.auth.ProxyServerCredentialsProvider;
import com.mathworks.webservices.client.core.auth.ProxyServerCredentialsProviderAdapter;
import com.mathworks.webservices.client.core.http.HttpResponse;
import com.mathworks.webservices.client.core.http.HttpsProtocolSocketFactory;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpHost;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class MathWorksHttpClient {
    private static final Protocol HTTP_PROTOCOL = Protocol.getProtocol((String)"http");
    private static final Protocol HTTPS_PROTOCOL = Protocol.getProtocol((String)"https");
    private HttpClient httpClient;
    private HostConfiguration hostConfiguration;
    private boolean endpointIsHttps = false;
    private String endpointHost;
    private int endpointPort;
    private SSLContext sslContext;

    public MathWorksHttpClient() {
        this(new ClientConfiguration());
    }

    public MathWorksHttpClient(ClientConfiguration config) {
        if (null == config) {
            config = new ClientConfiguration();
        }
        this.configureClient(config);
    }

    public void clearProxySettings() {
        this.httpClient.getParams().setParameter("http.authentication.credential-provider", null);
        this.hostConfiguration.setProxyHost(null);
    }

    public void setProxyConfiguration(String host, int port) {
        this.setProxyConfiguration(host, port, null, null);
    }

    public void setEndpoint(String endpoint) throws URIException {
        URI endpointURI = new URI(endpoint);
        Protocol p = Protocol.getProtocol((String)endpointURI.getScheme());
        this.endpointIsHttps = p.isSecure();
        this.endpointHost = endpointURI.getHost();
        this.endpointPort = endpointURI.getPort() != -1 ? endpointURI.getPort() : p.getDefaultPort();
        this.configureProtocol();
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        this.configureProtocol();
    }

    private SSLContext getSSLContext() {
        if (this.sslContext == null) {
            try {
                SSLContext ctxt = SSLContext.getInstance("TLSv1.2");
                ctxt.init(null, null, null);
                return ctxt;
            }
            catch (GeneralSecurityException ex) {
                throw new Error(ex);
            }
        }
        return this.sslContext;
    }

    private void configureProtocol() {
        this.configureProtocol(this.endpointIsHttps, this.endpointHost, this.endpointPort);
    }

    private void configureProtocol(boolean isHttps, String hostName, int port) {
        HttpHost host = null;
        if (isHttps) {
            Protocol protocol = new Protocol(HTTPS_PROTOCOL.getScheme(), (SecureProtocolSocketFactory)new HttpsProtocolSocketFactory(this.getSSLContext()), HTTPS_PROTOCOL.getDefaultPort());
            host = new HttpHost(hostName, port, protocol);
        } else if (hostName != null) {
            host = new HttpHost(hostName, port, HTTP_PROTOCOL);
        }
        this.hostConfiguration.setHost(host);
    }

    public void setProxyConfiguration(String host, int port, String username, String password) {
        this.clearProxySettings();
        if (host != null && port > 0) {
            this.hostConfiguration.setProxy(host, port);
            if (username != null && password != null) {
                AuthScope authScope = new AuthScope(host, port);
                WindowsUser user = this.getWindowsUser(username);
                Object credentials = user == null ? new UsernamePasswordCredentials(username, password) : new NTCredentials(user.username, password, host, user.domain);
                this.httpClient.getState().setProxyCredentials(authScope, (Credentials)credentials);
            }
        }
    }

    WindowsUser getWindowsUser(String username) {
        String[] array;
        if (username != null && (array = username.split("\\\\")).length == 2) {
            WindowsUser user = new WindowsUser();
            user.domain = array[0];
            user.username = array[1];
            return user;
        }
        return null;
    }

    public void setProxyConfiguration(String host, int port, ProxyServerCredentialsProvider credentialsProvider) {
        this.clearProxySettings();
        this.setProxyConfiguration(host, port);
        ProxyServerCredentialsProviderAdapter provider = new ProxyServerCredentialsProviderAdapter(credentialsProvider);
        this.httpClient.getParams().setParameter("http.authentication.credential-provider", (Object)provider);
    }

    private HttpClient configureClient(ClientConfiguration config) {
        assert (null != config);
        this.httpClient = new HttpClient();
        this.hostConfiguration = this.httpClient.getHostConfiguration();
        this.httpClient.setHttpConnectionManager((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        this.httpClient.getParams().setSoTimeout(config.getSocketTimeout());
        this.httpClient.getParams().setConnectionManagerTimeout((long)config.getConnectionTimeout());
        this.customizeHttpClient(this.httpClient);
        return this.httpClient;
    }

    protected void customizeHttpClient(HttpClient httpClient) {
    }

    public HttpResponse invoke(HttpMethodBase request) throws IOException {
        if (this.endpointHost == null) {
            this.setEndpoint(request.getURI().toString());
        }
        request.setHostConfiguration(null);
        int statusCode = this.httpClient.executeMethod(this.hostConfiguration, (HttpMethod)request);
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setStatusCode(statusCode);
        httpResponse.setResponseBody(request.getResponseBodyAsStream());
        httpResponse.setStatusText(request.getStatusText());
        for (Header header : request.getResponseHeaders()) {
            httpResponse.addHeader(header.getName(), header.getValue());
        }
        return httpResponse;
    }

    private class WindowsUser {
        String username;
        String domain;

        private WindowsUser() {
        }
    }
}

