/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.client.core.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

class HttpsProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private final SSLSocketFactory socketFactory;

    HttpsProtocolSocketFactory(SSLContext sslContext) {
        this.socketFactory = sslContext.getSocketFactory();
    }

    public boolean equals(Object other) {
        if (other instanceof HttpsProtocolSocketFactory) {
            HttpsProtocolSocketFactory o = (HttpsProtocolSocketFactory)other;
            return this.socketFactory.equals(o.socketFactory);
        }
        return false;
    }

    public int hashCode() {
        return 37 * this.socketFactory.hashCode();
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return HttpsProtocolSocketFactory.configureSSLParameters(this.socketFactory.createSocket(socket, host, port, autoClose));
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return HttpsProtocolSocketFactory.configureSSLParameters(this.socketFactory.createSocket(host, port));
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        return HttpsProtocolSocketFactory.configureSSLParameters(this.socketFactory.createSocket(host, port, localAddress, localPort));
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException {
        Socket socket = this.socketFactory.createSocket(host, port, localAddress, localPort);
        int linger = params.getLinger();
        if (linger == 0) {
            socket.setSoLinger(false, linger);
        } else if (linger > 0) {
            socket.setSoLinger(true, linger);
        }
        if (params.isParameterSet("http.socket.receivebuffer")) {
            socket.setReceiveBufferSize(params.getReceiveBufferSize());
        }
        if (params.isParameterSet("http.socket.sendbuffer")) {
            socket.setSendBufferSize(params.getSendBufferSize());
        }
        if (params.isParameterSet("http.socket.timeout")) {
            socket.setSoTimeout(params.getSoTimeout());
        }
        if (params.isParameterSet("http.tcp.nodelay")) {
            socket.setTcpNoDelay(params.getTcpNoDelay());
        }
        return HttpsProtocolSocketFactory.configureSSLParameters(socket);
    }

    private static Socket configureSSLParameters(Socket socket) {
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLParameters sslParams = sslSocket.getSSLParameters();
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            sslParams.setProtocols(new String[]{"TLSv1.2"});
            sslSocket.setSSLParameters(sslParams);
        }
        return socket;
    }
}

