/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.client.core;

import com.mathworks.webservices.client.core.ClientConfiguration;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.client.core.MathWorksServiceResponse;
import com.mathworks.webservices.client.core.ProxyAuthenticationRequiredException;
import com.mathworks.webservices.client.core.ServiceNotFoundException;
import com.mathworks.webservices.client.core.ServiceUnavailableException;
import com.mathworks.webservices.client.core.WebServiceClient;
import com.mathworks.webservices.client.core.auth.ProxyServerCredentialsProvider;
import com.mathworks.webservices.client.core.http.HttpRequest;
import com.mathworks.webservices.client.core.http.HttpResponse;
import com.mathworks.webservices.client.core.http.MathWorksHttpClient;
import com.mathworks.webservices.client.core.http.ResponseHandler;
import com.mathworks.webservices.client.core.json.ErrorMessage;
import com.mathworks.webservices.client.core.json.ErrorResponse;
import com.mathworks.webservices.client.core.json.JacksonResponseHandler;
import com.mathworks.webservices.client.core.xml.JaxbResponseHandler;
import java.io.IOException;
import javax.net.ssl.SSLContext;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.URIException;

public abstract class MathWorksWebServiceClient
implements WebServiceClient {
    private final int SERVICE_MOVED_PERMANENTLY = 301;
    private final int SERVICE_NOT_FOUND = 404;
    private final int PROXY_AUTHENTICATION_REQUIRED = 407;
    private final int SERVICE_UNAVAILABLE = 503;
    private String locale;
    private String clientString;
    protected String endpoint;
    protected final MathWorksHttpClient httpClient;
    protected final ResponseHandler responseHandler;
    protected final JacksonResponseHandler jacksonResponseHandler;

    public MathWorksWebServiceClient(ClientConfiguration config) {
        this.responseHandler = new JaxbResponseHandler();
        this.httpClient = new MathWorksHttpClient(config);
        this.jacksonResponseHandler = new JacksonResponseHandler();
    }

    public MathWorksWebServiceClient(ClientConfiguration config, ResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
        this.httpClient = new MathWorksHttpClient(config);
        this.jacksonResponseHandler = new JacksonResponseHandler();
    }

    public MathWorksWebServiceClient(ClientConfiguration config, JacksonResponseHandler jacksonResponseHandler) {
        this.responseHandler = new JaxbResponseHandler();
        this.jacksonResponseHandler = jacksonResponseHandler;
        this.httpClient = new MathWorksHttpClient(config);
    }

    public MathWorksWebServiceClient(MathWorksHttpClient httpClient, ResponseHandler responseHandler) {
        this.httpClient = httpClient;
        this.responseHandler = responseHandler;
        this.jacksonResponseHandler = new JacksonResponseHandler();
    }

    public MathWorksWebServiceClient(MathWorksHttpClient httpClient, JacksonResponseHandler jacksonResponseHandler) {
        this.responseHandler = new JaxbResponseHandler();
        this.httpClient = httpClient;
        this.jacksonResponseHandler = jacksonResponseHandler;
    }

    public void setEndpoint(String endpoint) throws IllegalArgumentException {
        try {
            this.httpClient.setEndpoint(endpoint);
            this.endpoint = endpoint;
        }
        catch (URIException ux) {
            throw new IllegalArgumentException(ux);
        }
    }

    @Override
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public void setClientString(String clientString) {
        this.clientString = clientString;
    }

    public <T extends MathWorksServiceResponse> T executeRequest(HttpRequest request) throws MathWorksServiceException, MathWorksClientException {
        return this.executeRequest(request, this.responseHandler);
    }

    public <T extends MathWorksServiceResponse> T executeRequest(HttpRequest request, Class<T> cls) throws MathWorksServiceException, MathWorksClientException {
        return this.executeRequest(request, this.jacksonResponseHandler, cls);
    }

    public <T extends MathWorksServiceResponse> T executeRequest(HttpRequest request, JacksonResponseHandler jacksonResponseHandler, Class<T> cls) throws MathWorksServiceException, MathWorksClientException {
        this.addClientLevelLocaleAndClientStringIfEmptyOnRequest(request);
        this.validateRequest(request);
        try {
            ErrorMessage message;
            ErrorResponse error;
            Header endpointHeader;
            request.getRequest().setFollowRedirects(false);
            HttpResponse resp = this.httpClient.invoke(request.getRequest());
            int respCode = resp.getStatusCode();
            if (301 == respCode && (endpointHeader = request.getRequest().getResponseHeader("x-mw-new-endpoint")) != null) {
                String newEndpoint = endpointHeader.getValue();
                if (newEndpoint != null && !newEndpoint.equalsIgnoreCase(this.endpoint)) {
                    this.endpoint = newEndpoint;
                    request.setEndpoint(this.endpoint);
                    resp = this.httpClient.invoke(request.getRequest(true));
                } else {
                    throw new ServiceNotFoundException("301 response did not provide a valid endpoint header.");
                }
            }
            if (407 == respCode) {
                throw new ProxyAuthenticationRequiredException(resp.getStatusText());
            }
            if (404 == respCode) {
                try {
                    error = this.jacksonResponseHandler.handleResponse(resp.getResponseBody(), ErrorResponse.class);
                }
                catch (Exception ex) {
                    ServiceNotFoundException snfe = new ServiceNotFoundException(resp.getStatusText(), ex);
                    snfe.setRequestId(resp.getRequestId());
                    throw snfe;
                }
                error.setHeaders(resp.getHttpHeaders());
                message = this.getErrorMessage(error);
                ServiceNotFoundException ex = new ServiceNotFoundException(message.getMessage());
                ex.setErrorCode(message.getCode());
                ex.setRequestId(error.getRequestId());
                ex.setSeverity(message.getSeverity());
                throw ex;
            }
            if (503 == respCode) {
                try {
                    error = this.jacksonResponseHandler.handleResponse(resp.getResponseBody(), ErrorResponse.class);
                }
                catch (Exception ex) {
                    ServiceUnavailableException sue = new ServiceUnavailableException(ex.getMessage(), ex);
                    sue.setRequestId(resp.getRequestId());
                    sue.setStatusCode(resp.getStatusCode());
                    throw sue;
                }
                error.setHeaders(resp.getHttpHeaders());
                message = this.getErrorMessage(error);
                ServiceUnavailableException ex = new ServiceUnavailableException(message.getMessage());
                ex.setStatusCode(respCode);
                ex.setErrorCode(message.getCode());
                ex.setRequestId(error.getRequestId());
                ex.setSeverity(message.getSeverity());
                throw ex;
            }
            if (301 != respCode && respCode > 299) {
                try {
                    error = this.jacksonResponseHandler.handleResponse(resp.getResponseBody(), ErrorResponse.class);
                }
                catch (Exception ex) {
                    MathWorksClientException mce = new MathWorksClientException(ex.getMessage(), ex);
                    mce.setRequestId(resp.getRequestId());
                    throw mce;
                }
                error.setHeaders(resp.getHttpHeaders());
                if ("Server".equalsIgnoreCase(error.getErrorType())) {
                    message = this.getErrorMessage(error);
                    MathWorksServiceException ex = new MathWorksServiceException(message.getMessage());
                    ex.setStatusCode(respCode);
                    ex.setErrorCode(message.getCode());
                    ex.setSeverity(message.getSeverity());
                    ex.setRequestId(error.getRequestId());
                    throw ex;
                }
                message = this.getErrorMessage(error);
                MathWorksClientException ex = new MathWorksClientException(message.getMessage());
                ex.setErrorCode(message.getCode());
                ex.setSeverity(message.getSeverity());
                ex.setRequestId(error.getRequestId());
                throw ex;
            }
            MathWorksServiceResponse response = (MathWorksServiceResponse)jacksonResponseHandler.handleResponse(resp.getResponseBody(), cls);
            response.setHeaders(resp.getHttpHeaders());
            MathWorksServiceResponse mathWorksServiceResponse = response;
            return (T)mathWorksServiceResponse;
        }
        catch (IOException e) {
            throw new MathWorksClientException("unable to connect to host " + e.getMessage(), e);
        }
        finally {
            if (request.getRequest() != null) {
                request.getRequest().releaseConnection();
            }
        }
    }

    public <T extends MathWorksServiceResponse> T executeRequest(HttpRequest request, ResponseHandler handler) throws MathWorksServiceException, MathWorksClientException {
        this.addClientLevelLocaleAndClientStringIfEmptyOnRequest(request);
        this.validateRequest(request);
        try {
            com.mathworks.webservices.client.core.xml.ErrorMessage message;
            com.mathworks.webservices.client.core.xml.ErrorResponse error;
            Header endpointHeader;
            request.getRequest().setFollowRedirects(false);
            HttpResponse resp = this.httpClient.invoke(request.getRequest());
            int respCode = resp.getStatusCode();
            if (301 == respCode && (endpointHeader = request.getRequest().getResponseHeader("x-mw-new-endpoint")) != null) {
                String newEndpoint = endpointHeader.getValue();
                if (newEndpoint != null && !newEndpoint.equalsIgnoreCase(this.endpoint)) {
                    this.endpoint = newEndpoint;
                    request.setEndpoint(this.endpoint);
                    resp = this.httpClient.invoke(request.getRequest(true));
                } else {
                    throw new ServiceNotFoundException("301 response did not provide a valid endpoint header.");
                }
            }
            if (407 == respCode) {
                throw new ProxyAuthenticationRequiredException(resp.getStatusText());
            }
            if (404 == respCode) {
                try {
                    error = (com.mathworks.webservices.client.core.xml.ErrorResponse)this.responseHandler.handleResponse(resp.getResponseBody());
                }
                catch (Exception ex) {
                    ServiceNotFoundException snfe = new ServiceNotFoundException(resp.getStatusText(), ex);
                    snfe.setRequestId(resp.getRequestId());
                    throw snfe;
                }
                error.setHeaders(resp.getHttpHeaders());
                message = this.getErrorMessage(error);
                ServiceNotFoundException ex = new ServiceNotFoundException(message.getMessage());
                ex.setErrorCode(message.getCode());
                ex.setRequestId(error.getRequestId());
                ex.setSeverity(message.getSeverity());
                throw ex;
            }
            if (503 == respCode) {
                try {
                    error = (com.mathworks.webservices.client.core.xml.ErrorResponse)this.responseHandler.handleResponse(resp.getResponseBody());
                }
                catch (Exception ex) {
                    ServiceUnavailableException sue = new ServiceUnavailableException(ex.getMessage(), ex);
                    sue.setRequestId(resp.getRequestId());
                    sue.setStatusCode(resp.getStatusCode());
                    throw sue;
                }
                error.setHeaders(resp.getHttpHeaders());
                message = this.getErrorMessage(error);
                ServiceUnavailableException ex = new ServiceUnavailableException(message.getMessage());
                ex.setStatusCode(respCode);
                ex.setErrorCode(message.getCode());
                ex.setRequestId(error.getRequestId());
                ex.setSeverity(message.getSeverity());
                throw ex;
            }
            if (301 != respCode && respCode > 299) {
                try {
                    error = (com.mathworks.webservices.client.core.xml.ErrorResponse)this.responseHandler.handleResponse(resp.getResponseBody());
                }
                catch (Exception ex) {
                    MathWorksClientException mce = new MathWorksClientException(ex.getMessage(), ex);
                    mce.setRequestId(resp.getRequestId());
                    throw mce;
                }
                error.setHeaders(resp.getHttpHeaders());
                if ("Server".equalsIgnoreCase(error.getErrorType())) {
                    message = this.getErrorMessage(error);
                    MathWorksServiceException ex = new MathWorksServiceException(message.getMessage());
                    ex.setStatusCode(respCode);
                    ex.setErrorCode(message.getCode());
                    ex.setSeverity(message.getSeverity());
                    ex.setRequestId(error.getRequestId());
                    throw ex;
                }
                message = this.getErrorMessage(error);
                MathWorksClientException ex = new MathWorksClientException(message.getMessage());
                ex.setErrorCode(message.getCode());
                ex.setSeverity(message.getSeverity());
                ex.setRequestId(error.getRequestId());
                throw ex;
            }
            MathWorksServiceResponse response = (MathWorksServiceResponse)handler.handleResponse(resp.getResponseBody());
            response.setHeaders(resp.getHttpHeaders());
            MathWorksServiceResponse mathWorksServiceResponse = response;
            return (T)mathWorksServiceResponse;
        }
        catch (IOException e) {
            throw new MathWorksClientException("unable to connect to host " + e.getMessage(), e);
        }
        finally {
            if (request.getRequest() != null) {
                request.getRequest().releaseConnection();
            }
        }
    }

    ErrorMessage getErrorMessage(ErrorResponse error) {
        try {
            ErrorMessage message = error.getErrors().get(0);
            return message;
        }
        catch (Throwable t) {
            ErrorMessage message = new ErrorMessage();
            message.setCode("");
            message.setMessage("");
            message.setSeverity("");
            return message;
        }
    }

    com.mathworks.webservices.client.core.xml.ErrorMessage getErrorMessage(com.mathworks.webservices.client.core.xml.ErrorResponse error) {
        try {
            com.mathworks.webservices.client.core.xml.ErrorMessage message = error.getErrors().get(0);
            return message;
        }
        catch (Throwable t) {
            com.mathworks.webservices.client.core.xml.ErrorMessage message = new com.mathworks.webservices.client.core.xml.ErrorMessage();
            message.setCode("");
            message.setMessage("");
            message.setSeverity("");
            return message;
        }
    }

    void addClientLevelLocaleAndClientStringIfEmptyOnRequest(HttpRequest request) {
        String clientString = request.getClientString();
        if (clientString == null || "".equals(clientString)) {
            request.setClientString(this.clientString);
        }
        request.addHeader("x-mw-clientstring", request.getClientString());
        String locale = request.getLocale();
        if (locale == null || "".equals(locale)) {
            request.setLocale(this.locale);
        }
        if ((locale = request.getHeaders().get("Accept-Language")) == null || "".equals(locale)) {
            request.addHeader("Accept-Language", this.locale);
        }
    }

    void validateRequest(HttpRequest request) throws MathWorksClientException {
        String endpoint = request.getEndpoint();
        if (endpoint == null || "".equals(endpoint)) {
            throw new MathWorksClientException("You must define an endpoint for the service client.");
        }
        String clientString = request.getClientString();
        if (clientString == null || "".equals(clientString)) {
            throw new MathWorksClientException("You must set the clientString on your request.");
        }
        String locale = request.getLocale();
        if (locale == null || "".equals(locale)) {
            throw new MathWorksClientException("You must set the locale on your request.");
        }
    }

    @Override
    public void clearProxySettings() {
        this.httpClient.clearProxySettings();
    }

    @Override
    public void setProxyConfiguration(String host, int port) {
        this.httpClient.setProxyConfiguration(host, port);
    }

    @Override
    public void setProxyConfiguration(String host, int port, String username, String password) {
        this.httpClient.setProxyConfiguration(host, port, username, password);
    }

    @Override
    public void setProxyConfiguration(String host, int port, ProxyServerCredentialsProvider credentialsProvider) {
        this.httpClient.setProxyConfiguration(host, port, credentialsProvider);
    }

    @Override
    public void setSSLContext(SSLContext sslContext) {
        this.httpClient.setSSLContext(sslContext);
    }
}

